/*
  main.cpp - A KControl Application

  written 1998 by Henning Busacker
  
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   
  */

#define QT_CLEAN_NAMESPACE
#include <kcontrol.h>
#include <kmsgbox.h>
#include "dpms.h"

class KDPMSApplication : public KControlApplication
{
public:

  KDPMSApplication(int &argc, char **arg, const char *name);

  void init();
  void apply();
  void defaultValues();
private:

  KDPMSConfig *dpms;
};


KDPMSApplication::KDPMSApplication(int &argc, char **argv, const char *name)
  : KControlApplication(argc, argv, name)
{
  dpms = 0;

  if (runGUI())
    {
      if (!pages || pages->contains("dpms"))
        addPage(dpms = new KDPMSConfig(dialog, "dpms", FALSE), 
		i18n("&DPMS"), "kdpms.html");

      if (dpms)
        dialog->show();
      else
        {
          fprintf(stderr, i18n("usage: kcmdpms [-init | dpms]\n"));
	  justInit = TRUE;
        }
    }
}


void KDPMSApplication::init()
{
  KDPMSConfig *dpmsconfig = new KDPMSConfig(0, 0, TRUE);
  delete dpmsconfig;
}


void KDPMSApplication::apply()
{
  if (dpms)
    dpms->applySettings();
}

void KDPMSApplication::defaultValues()
{
  if (dpms)
    dpms->defaultSettings();
}


int main(int argc, char **argv)
{
  KDPMSApplication app(argc, argv, "kcmdpms");
  app.setTitle(i18n("DPMS settings"));
  bool b=DPMSExtension::DPMSCapable(app.getDisplay());
  if (!b)
  {
   KMsgBox::message(0,"DPMS",
   i18n("Sorry, your X11 Server lacks DPMS Support.\n"));
   return 1; 
 }
  
  if (app.runGUI())
    return app.exec();
  else
    {
      app.init();
      return 0;
    }
}
