/*
 * dpms.h
 *
 * Copyright (c) 1998 Henning Busacker henning.busacker@duesseldorf.netsurf.de
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#ifndef __KDPMSCONFIG_H__
#define __KDPMSCONFIG_H__

#include <kapp.h>

#include <qlcdnum.h> 
#include <qlabel.h> 
#include <qbttngrp.h>
#include <qpushbt.h>
#include <qchkbox.h> 

#include <kslider.h>
#include <kcontrol.h>
#include "xdpms.h"

class KDPMSConfig : public KConfigWidget
{
  Q_OBJECT
public:
  KDPMSConfig( QWidget *parent=0, const char *name=0, bool init=FALSE );
  ~KDPMSConfig( );
  void resizeEvent( QResizeEvent * );
  void saveParams( void );

public slots:

  void loadSettings();
  void applySettings();
  void defaultSettings();

private slots:
  void btnStandbyClicked();
  void btnSuspendClicked();
  void btnOffClicked();
  void chkEnabledToggled(bool);
private:
  void GetSettings( void );

  int getDPMSstandby();
  int getDPMSsuspend();
  int getDPMSoff();
  bool getDPMSenabled();
  
  void setDPMSstandby(int);
  void setDPMSsuspend(int);
  void setDPMSoff(int);
  void setDPMSenabled(bool);

  KSlider *standby, *suspend, *off;
  QLabel *vlabel, *plabel, *dlabel, *v1,*p1,*d1;
  QLCDNumber *v, *p, *d;
  QCheckBox * enabled;

  QPushButton *btnStandby, *btnSuspend, *btnOff;

  KConfig *config;
  DPMSExtension* DPMS;
  int standbyTime, suspendTime, offTime;
  bool dpmsEnabled; 
};

#endif

