/*
 * dpms.cpp
 *
 * Copyright (c) 1998 Henning Busacker <henning.busacker@duesseldorf.netsurf.de>
 *
 * Requires the Qt widget libraries, available at no cost at
 * http://www.troll.no/
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <iostream.h>
#include <stdio.h> 
#include <sys/stat.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <stdlib.h>

#define QT_CLEAN_NAMESPACE 
#include <qfileinf.h> 
#include <qstring.h>
#include <qmsgbox.h> 

#include <kmsgbox.h> 
#include "dpms.h"
#include "geom.h"
#include "xdpms.h"


static bool GUI;

KDPMSConfig::~KDPMSConfig ()
{
  if (GUI)
    {
      delete enabled;
      delete standby;
      delete suspend;
      delete off;
      delete p;
      delete d;
      delete v;
      delete p1;
      delete d1;
      delete v1;
      delete vlabel;
      delete plabel;
      delete dlabel;
      delete btnStandby;
      delete btnSuspend;
      delete btnOff;
    }
      delete DPMS;
}

KDPMSConfig::KDPMSConfig (QWidget * parent, const char *name, bool init)
    : KConfigWidget (parent, name)
{
  if (init)
    GUI = FALSE;
  else
    GUI = TRUE;

  if (GUI)
    {
      standby = new KSlider(0,120,1,5, KSlider::Horizontal,    this, "standby");
      suspend = new KSlider(0,120,1,10, KSlider::Horizontal, this, "suspend");
      off = new KSlider(0,120,1,15, KSlider::Horizontal, this, "off");
      standby->setSteps(5,10);
      suspend->setSteps(5,10);
      off->setSteps(5,10);
      btnStandby=new QPushButton(i18n("Test"),this,"btnStandby");
      btnSuspend=new QPushButton(i18n("Test"),this,"btnSuspend");
      btnOff=new QPushButton(i18n("Test"),this,"btnOff");
      btnStandby->setAutoResize(true);
      btnSuspend->setAutoResize(true);
      btnOff->setAutoResize(true);
      btnStandby->setMinimumWidth(80);
      btnSuspend->setMinimumWidth(80);
      btnOff->setMinimumWidth(80);

      v = new QLCDNumber (3, this, "v");
      p = new QLCDNumber (3, this, "p");
      d = new QLCDNumber (3, this, "d");
      v->setFrameStyle( QFrame::NoFrame );
      p->setFrameStyle( QFrame::NoFrame );
      d->setFrameStyle( QFrame::NoFrame );

      vlabel = new QLabel(i18n("Standby Time"), this);
      plabel = new QLabel(i18n("Suspend Time"), this);
      dlabel = new QLabel(i18n("Off Time"), this);
      v1 = new QLabel(i18n("Min"), this);
      p1 = new QLabel(i18n("Min"), this);
      d1 = new QLabel(i18n("Min"), this);

      enabled = new QCheckBox(i18n("DPMS enabled"),this,"enabled");
      
      connect( standby,    SIGNAL(valueChanged(int)), v, SLOT(display(int)) );
      connect( suspend,    SIGNAL(valueChanged(int)), p, SLOT(display(int)) );
      connect( off,        SIGNAL(valueChanged(int)), d, SLOT(display(int)) );
      connect( btnStandby, SIGNAL(clicked()),            SLOT(btnStandbyClicked()) );
      connect( btnSuspend, SIGNAL(clicked()),            SLOT(btnSuspendClicked()) );
      connect( btnOff,     SIGNAL(clicked()),            SLOT(btnOffClicked()) );
      connect( enabled,    SIGNAL(toggled(bool)),        SLOT(chkEnabledToggled(bool)) );
      enabled->adjustSize();
      v->adjustSize();
      p->adjustSize();
      d->adjustSize();
      v1->adjustSize();
      p1->adjustSize();
      d1->adjustSize();
      vlabel->adjustSize();
      plabel->adjustSize();
      dlabel->adjustSize();
      btnSuspend->adjustSize();
      btnStandby->adjustSize();
      btnOff->adjustSize();
       
    }

  config = kapp->getConfig();
  DPMS = new DPMSExtension(kapp->getDisplay());
  GetSettings();

  if (init)
    saveParams();
}

void KDPMSConfig::resizeEvent(QResizeEvent *)
{
  int h = SPACE_YO;
  int w = 0;

  w = max(w, vlabel->width());
  w = max(w, plabel->width());
  w = max(w, dlabel->width());
  enabled->setGeometry(SPACE_XO, h, 200,h);
  h += enabled->height() + SPACE_YI;

  vlabel->move(SPACE_XO, h);
  standby->setGeometry(w + 2*SPACE_XO, h, 200, vlabel->height()+15);
  btnStandby->setGeometry(w+4*SPACE_XO+200,h,btnStandby->width(),btnStandby->height());
  h += vlabel->height() + SPACE_YI;
  int center = standby->x() + ( standby->width() - v->width() )/2;
  int dh = ( v->height() - v1->height() )/2;
  v->move(center, h);
  v1->move(v->x() + v->width() + 3, h+dh);

  h += v->height() + SPACE_YO;

  plabel->move(SPACE_XO, h);
  suspend->setGeometry(w + 2*SPACE_XO, h, 200, vlabel->height()+15);
  btnSuspend->setGeometry(w+4*SPACE_XO+200,h,btnSuspend->width(),btnSuspend->height());
  h += plabel->height() + SPACE_YI;
  p->move(center, h);
  p1->move(v->x() + v->width() + 3, h+dh);

  h += p->height() + SPACE_YO;

  dlabel->move(SPACE_XO, h);
  off->setGeometry(w + 2*SPACE_XO, h, 200, vlabel->height()+15);
  btnOff->setGeometry(w+4*SPACE_XO+200,h,btnOff->width(),btnOff->height());
  h += dlabel->height() + SPACE_YI;
  d->move(center, h);
  d1->move(v->x() + v->width() + 3, h+dh);

//  h += d->height() + SPACE_YO;

}

// set the slider and the LCD to 'val'
void KDPMSConfig::setDPMSstandby(int val)
{
  standby->setValue(val/60);
  v->display(val/60);
}

void KDPMSConfig::setDPMSsuspend(int val)
{
  suspend->setValue(val/60);
  p->display(val/60);
}

void KDPMSConfig::setDPMSoff(int val)
{
  off->setValue(val/60);
  d->display(val/60);
}
void KDPMSConfig::setDPMSenabled(bool val)
{
  enabled->setChecked(val);
}
// return the current LCD setting
int  KDPMSConfig::getDPMSstandby()
{
  return v->intValue()*60;
}

int  KDPMSConfig::getDPMSsuspend()
{
  return p->intValue()*60;
}

int  KDPMSConfig::getDPMSoff()
{
  return d->intValue()*60;
}
bool  KDPMSConfig::getDPMSenabled()
{
  return enabled->isChecked();
}
void KDPMSConfig::GetSettings( void )
{
  struct Params   {CARD16 standbyTime;
                   CARD16 suspendTime;
                   CARD16 offTime; 
                   BOOL   dpmsEnabled;
                  } params;
  int   DPMSEnabled;  // from Config
  CARD16 state;

  config->setGroup("DPMS");
  standbyTime = config->readNumEntry("StandbyTime",-1);
  suspendTime = config->readNumEntry("SuspendTime",-1);
  offTime     = config->readNumEntry("OffTime",-1);
  DPMSEnabled = config->readNumEntry("DPMSEnabled",-1);

   DPMS->DPMSGetTimeouts( &params.standbyTime,
            		  &params.suspendTime,
                          &params.offTime);

   DPMS->DPMSInfo(&state,&params.dpmsEnabled);
  // if the config file didn't have anything, use the X server settings
  if (standbyTime == -1)
    standbyTime = params.standbyTime;
  if (suspendTime == -1)
    suspendTime = params.suspendTime;
  if (offTime == -1)
    offTime = params.offTime;
   if (DPMSEnabled == -1)
     dpmsEnabled = params.dpmsEnabled;
   else dpmsEnabled=(DPMSEnabled==1); 
  // the GUI should reflect the real values
  if (GUI)
    {
      setDPMSstandby(params.standbyTime);
      setDPMSsuspend(params.suspendTime);
      setDPMSoff(params.offTime);
      setDPMSenabled(params.dpmsEnabled);
      btnStandby->setEnabled(params.dpmsEnabled);
      btnSuspend->setEnabled(params.dpmsEnabled);
      btnOff->setEnabled(params.dpmsEnabled);

    }
}

void KDPMSConfig::saveParams( void )
{

  if (GUI)
    {
      standbyTime = getDPMSstandby();
      suspendTime = getDPMSsuspend();
      offTime = getDPMSoff();
      dpmsEnabled=getDPMSenabled();
    }

  DPMS->DPMSSetTimeouts( standbyTime,
                         suspendTime,
                         offTime);
  if (dpmsEnabled)
      { DPMS->DPMSEnable();
       }
      else
      { DPMS->DPMSDisable();
       }
  if (GUI)
    {
      btnStandby->setEnabled(dpmsEnabled);
      btnSuspend->setEnabled(dpmsEnabled);
      btnOff->setEnabled(dpmsEnabled);
      config->setGroup("DPMS");
      config->writeEntry("StandbyTime",standbyTime);
      config->writeEntry("SuspendTime",suspendTime);
      config->writeEntry("OffTime",offTime);
      config->writeEntry("DPMSEnabled",dpmsEnabled);
      config->sync();
    }
}



void KDPMSConfig::loadSettings()
{
  GetSettings();
}

void KDPMSConfig::applySettings()
{
  saveParams();
}
void KDPMSConfig::defaultSettings()
{
      setDPMSstandby(600);
      setDPMSsuspend(1200);
      setDPMSoff(1800);
      setDPMSenabled(true);
  DPMS->DPMSSetTimeouts( 600,
                         1200,
                         1800);
  DPMS->DPMSEnable();
}
void KDPMSConfig::btnStandbyClicked()
{
DPMS->DPMSForceLevel(DPMSModeStandby);
}
void KDPMSConfig::btnSuspendClicked()
{
DPMS->DPMSForceLevel(DPMSModeSuspend);
}
void KDPMSConfig::btnOffClicked()
{
DPMS->DPMSForceLevel(DPMSModeOff);
}
void KDPMSConfig::chkEnabledToggled(bool toggle)
{
   if (toggle) DPMS->DPMSEnable(); 
   else DPMS->DPMSDisable();

   btnStandby->setEnabled(toggle);
   btnSuspend->setEnabled(toggle);
   btnOff->setEnabled(toggle);


}
#include "dpms.moc"
