/******************************************************************************
**         File: $RCSfile$
**
**  Description:
**
**      Created: $Date$
**
**      Changes: $Revision$ 
**   $Log$ 
**
** Distribution: $Name$ 
******************************************************************************/   

/*-----------------------------------------------------------------------------
-- SYSTEM INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include <qpainter.h> 

/*-----------------------------------------------------------------------------
-- PRIVATE INCLUDE FILE DECLARATIONS
-----------------------------------------------------------------------------*/
#include "DebugInfo.h"
#include "kdiffDisplay.h"
#include "kdiffDisplay.moc"

/*-----------------------------------------------------------------------------
-- DEFINITIONS
-----------------------------------------------------------------------------*/

#define SCRBAR_WIDTH	15
#define L_R_GAP   2


/*-----------------------------------------------------------------------------
-- TYPE DEFINITIONS
-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
-- GLOBAL VARIABLES
-----------------------------------------------------------------------------*/


//
// Name:  kdiffDisplay::kdiffDisplay ( QWidget* parent=0 ) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
kdiffDisplay::kdiffDisplay ( QWidget* parent=0, const char* name=0 )
             :QWidget( parent, name=0 ) 
{
  dprintf( "START::kdiffDisplay ( >%p<, >%s< )\n", parent, name );

  leftTextPi = new QPixmap();
  rightTextPi = new QPixmap();
  backCo = QColor( 255, 255, 255 );
  foreCo = QColor( 0, 0, 0 );
  deleteCo = QColor( 240, 80, 80 );
  changeCo = QColor( 80, 240, 80 );
  insertCo = QColor( 80, 80, 240 );

  /* Scrollbars
  -------------*/
  leftHorSb = new QScrollBar( QScrollBar::Horizontal,this );
  rightHorSb = new QScrollBar( QScrollBar::Horizontal,this );
  vertSb = new QScrollBar( QScrollBar::Vertical,this );
  
  connect( leftHorSb, SIGNAL(valueChanged(int)), SLOT(leftHorSbScrolled(int)));
  connect( rightHorSb, SIGNAL(valueChanged(int)), SLOT(rightHorSbScrolled(int)));
  connect( vertSb, SIGNAL(valueChanged(int)), SLOT(vertSbScrolled(int)));
 
  /* dropzone
  -----------*/
  diffDropZone = new KDNDDropZone( this, DndURL );
  connect( diffDropZone, SIGNAL( dropAction( KDNDDropZone *) ),
           this, SLOT( dropEvent( KDNDDropZone *) ) );
  
  drawTextFn = QFont( "Courier", 12 ); 
  setFont( drawTextFn );
  drawTextMt = new QFontMetrics( fontMetrics() );

  maxLeftLineLenght = 0;
  maxRightLineLenght = 0;
  lineCount = 0;
  topLineNr = 0;
  visibleLines = 0;
  visibleChars = 0;

  diffText = 0;
  showFLines = TRUE;


 

  dprintf( "END::kdiffDisplay ( QWidget* parent=0 )=><\n");

} 


//
// Name:  kdiffDisplay::~kdiffDisplay(  ) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
kdiffDisplay::~kdiffDisplay ( ) 
{
  dprintf( "START::~kdiffDisplay( )\n" );

  if ( leftTextPi !=0 ) delete leftTextPi;
  if ( rightTextPi !=0 ) delete rightTextPi;

  if ( leftHorSb !=0 ) delete leftHorSb;
  if ( rightHorSb !=0 ) delete rightHorSb;
  if ( vertSb !=0 ) delete vertSb;
  
  if ( diffDropZone !=0 ) delete diffDropZone;
  
  dprintf( "END::~kdiffDisplay(  )=><\n");
} 


//
// Name:  kdiffDisplay::leftHorSbScrolled( int value )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::leftHorSbScrolled( int value )
{
  dprintf( "START::leftHorSbScrolled( >%d< )\n", value );
  value = value;
  repaint(FALSE);
  dprintf( "END::leftHorSbScrolled( )=>void<\n");
}


//
// Name:  kdiffDisplay::rightHorSbScrolled( int value )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::rightHorSbScrolled( int value )
{
  dprintf( "START::rightHorSbScrolled( >%d< )\n", value );
  value = value;
  repaint(FALSE);
  dprintf( "END::rightHorSbScrolled( )=>void<\n");
}


//
// Name:  kdiffDisplay::vertSbScrolled( int value )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::vertSbScrolled( int value )
{
  dprintf( "START::vertSbScrolled( >%d< )\n", value );

  topLineNr = value;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::vertSbScrolled( )=>void<\n");
}


//
// Name: kdiffDisplay::showLineNr( bool on ) 
//
// Comment:
//
//
void kdiffDisplay::showLineNr( bool on ) 
{
  dprintf( "START::showLineNr( >%d< ) \n", on );

  showFLines = on;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::showLineNr( ... )=>void<\n");
}


//
// Name:  kdiffDisplay::setBackColor( const QColor &col )
//
// Comment:
//
//
void kdiffDisplay::setBackColor( const QColor &col )
{
  dprintf( "START::setBackColor( ... )\n" );

  backCo = col;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  else
    clearDisplay();
    
  repaint(FALSE);

  dprintf( "END::setBackColor( ... )=>void<\n");
}


//
// Name: kdiffDisplay::setForeColor( const QColor &col )
//
// Comment:
//
//
void kdiffDisplay::setForeColor( const QColor &col )
{
  dprintf( "START::setForeColor( ... )\n" );

  foreCo = col;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::setForeColor( ... )=>void<\n");
}


//
// Name:  kdiffDisplay::setInsertColor( const QColor &col )
//
// Comment:
//
//
void kdiffDisplay::setInsertColor( const QColor &col )
{
  dprintf( "START::setInsertColor( ... )\n" );

  insertCo = col;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::setInsertColor( ... )=>void<\n");
}


//
// Name: kdiffDisplay::setDeleteColor( const QColor &col ) 
//
// Comment:
//
//
void kdiffDisplay::setDeleteColor( const QColor &col )
{
  dprintf( "START::setDeleteColor( ... )\n" );

  deleteCo = col;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::setDeleteColor( ... )=>void<\n");
}


//
// Name:  kdiffDisplay::setChangeColor( const QColor &col )
//
// Comment:
//
//
void kdiffDisplay::setChangeColor( const QColor &col )
{
  dprintf( "START::setChangeColor( ... )\n" );

  changeCo = col;
  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::setChangeColor( ... )=>void<\n");
}

//
// Name:  kdiffDisplay::setDisplayFont( cont QFont &fontCfg );
//
// Comment:
//
//
void kdiffDisplay::setDisplayFont( const QFont &fontCfg )
{
  dprintf( "START::setDisplayFont( ... )\n" );
  drawTextFn = fontCfg;
  setFont( drawTextFn );
  if ( drawTextMt != 0 )
    delete drawTextMt;
  drawTextMt = new QFontMetrics( fontMetrics() );

  if ( diffText != 0 )
    drawTextToPixmaps( diffText, topLineNr, visibleLines );
  repaint(FALSE);

  dprintf( "END::setDisplayFont( ... )=>void<\n");
}


//
// Name:  kdiffDisplay::displayPrevDiff( )
//
// Comment:
//
//
void kdiffDisplay::displayPrevDiff( )
{
  dprintf( "START::displayPrevDiff( )\n" );

  if ( diffText != 0 )
  {
    topLineNr = diffText->getPrevDiffLine( topLineNr );
    vertSb->setValue( topLineNr );
  }
  repaint(FALSE);

  dprintf( "END::displayPrevDiff( )=>void<\n");
}

//
// Name:  kdiffDisplay::displayNextDiff( )
//
// Comment:
//
//
void kdiffDisplay::displayNextDiff( )
{
  dprintf( "START::displayNextDiff( )\n" );

  if ( diffText != 0 )
  {
    topLineNr = diffText->getNextDiffLine( topLineNr );
    vertSb->setValue( topLineNr );
  }
  repaint(FALSE);

  dprintf( "END::displayNextDiff( )=>void<\n");
}

//
// Name:  kdiffDisplay::setText( KDiff *lrText )
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::setText( KDiff *lrText )
{
  
  dprintf( "START::setText( ... )\n" );

  topLineNr = 0;

  diffText = lrText;

  maxLeftLineLenght=diffText->getMaxLeftLineLenght();
  maxRightLineLenght=diffText->getMaxRightLineLenght();
  lineCount = diffText->getLeftLineCount();
  if ( lineCount < diffText->getRightLineCount() )
  {
    lineCount = diffText->getRightLineCount();
  }
  
  //resize( this->width(), this->height()); 
  resizeEvent( NULL ); // bad way to force geometryCalculation, but it
                       // works unless we have no need to the parameter
  
  drawTextToPixmaps( diffText, topLineNr, visibleLines );
    
  repaint( FALSE );
  
 
  dprintf( "END::setText( )=>void<\n");

}


//
// Name:  kdiffDisplay::clearDisplay()
//
// Comment:
//
//
void kdiffDisplay::clearDisplay()
{
  QPainter pl;
  QPainter pr;

  dprintf( "START::clearDisplay()\n" );

  if ( leftTextPi != 0 )
    delete leftTextPi;
  leftTextPi = new QPixmap( leftTextRe.width(), leftTextRe.height() );

  if ( rightTextPi != 0 )
    delete rightTextPi;
  rightTextPi = new QPixmap( rightTextRe.width(), rightTextRe.height() );

  leftHorSb->setRange( 0, 0 );
  rightHorSb->setRange( 0, 0 );
  vertSb->setRange( 0, 0 );

  diffText = 0;


  if ( leftTextPi->isNull() == FALSE )
  {
    pl.begin( leftTextPi );
    pr.begin( rightTextPi );
  
    leftTextPi->fill( backCo );
    rightTextPi->fill( backCo );

    pl.end( );
    pr.end( );
  }

  
  repaint(FALSE); 

  dprintf( "END::clearDisplay( )=>void<\n");

}


//
// Name: void kdiffDisplay::paintEvent(QPaintEvent *pe ) 
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::paintEvent(QPaintEvent *pe )
{
  dprintf( "START::paintEvent( >%p< )\n", pe );
  
  if ( leftTextPi != NULL && rightTextPi != NULL )
  {
     bitBlt( this, leftTextRe.x(), leftTextRe.y(), 
          leftTextPi,                                 // source 
          leftHorSb->value()* drawTextMt->width('W'), // xpos,
          0,                                          // ypos,
          leftTextRe.width(), leftTextRe.height(),    // width and height
          CopyROP );

     bitBlt( this, rightTextRe.x(), rightTextRe.y(), 
          rightTextPi,                                // source 
          rightHorSb->value()* drawTextMt->width('W'),// xpos
          0,                                          // ypos,
          rightTextRe.width(), rightTextRe.height(),  // width and height
          CopyROP );
  }         
         
  dprintf( "END::paintEvent( )=>void<\n");
} 


//
// Name: void kdiffDisplay::resizeEvent(QResizeEvent *re );
//
// Comment:
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::resizeEvent(QResizeEvent *re )
{
  int diffViewSize;
  int horSbWidth;
  int widthPi;
  int vlTest;
  
  dprintf( "START::resizeEvent( >%p< )\n", re );
  
  diffViewSize = int(double( double(this->width())/100) * L_R_GAP );
  horSbWidth = ( this->width()-diffViewSize ) / 2 - SCRBAR_WIDTH / 2;

  leftHorSb->setGeometry( 0, this->height()-SCRBAR_WIDTH,
                          horSbWidth, SCRBAR_WIDTH );

  rightHorSb->setGeometry( horSbWidth+diffViewSize, this->height()-SCRBAR_WIDTH,
                           horSbWidth, SCRBAR_WIDTH );
             
  vertSb->setGeometry( this->width() - SCRBAR_WIDTH, 0,
                       SCRBAR_WIDTH, this->height()- SCRBAR_WIDTH ); 

  leftTextRe.setRect( 0, 0, horSbWidth, this->height()-SCRBAR_WIDTH );   
  rightTextRe.setRect( horSbWidth+diffViewSize, 0,horSbWidth, this->height()-SCRBAR_WIDTH );

  // change pixmap sizes
  widthPi=maxLeftLineLenght * drawTextMt->width('W');
  if ( widthPi < leftTextRe.width() )
    widthPi = leftTextRe.width();
  if ( leftTextPi != 0 )
    delete leftTextPi;
  leftTextPi = new QPixmap( widthPi, leftTextRe.height() );

  widthPi=maxRightLineLenght * drawTextMt->width('W');
  if ( widthPi < rightTextRe.width() )
    widthPi = rightTextRe.width();
  if ( rightTextPi != 0 )
    delete rightTextPi;
  rightTextPi = new QPixmap( widthPi, rightTextRe.height() );


  {
    QPainter pl;
    QPainter pr;
    pl.begin( leftTextPi );
    pr.begin( rightTextPi );
   
    leftTextPi->fill( backCo );
    rightTextPi->fill( backCo );

    pl.end( );
    pr.end( );

  }

  visibleChars=leftTextRe.width()/drawTextMt->width('W');
  leftHorSb->setRange( 0, (maxLeftLineLenght - visibleChars)>0?maxLeftLineLenght - visibleChars:0 );
  visibleChars = rightTextRe.width()/drawTextMt->width('W');
  rightHorSb->setRange( 0, (maxRightLineLenght - visibleChars)>0?maxRightLineLenght - visibleChars:0 );
  leftHorSb->setValue( 1 );
  rightHorSb->setValue( 1 );


  visibleLines=leftTextRe.height()/drawTextMt->height();
  vlTest = rightTextRe.height()/drawTextMt->height();
  visibleLines=(visibleLines>vlTest)?visibleLines:vlTest;
  vertSb->setRange( 1, lineCount-visibleLines>0?lineCount-visibleLines+1:1 );
  vertSb->setSteps( 1, visibleLines );
  vertSb->setValue( topLineNr );

  if ( diffText != 0 )
  {
      drawTextToPixmaps( diffText, topLineNr, visibleLines );
  }
  else
    repaint(FALSE);
  
  dprintf( "END::resizeEvent( );=>void<\n");
}



//
// Name: kdiffDisplay::drawTextToPixmaps
//
// Comment:
//
//
void kdiffDisplay::drawTextToPixmaps( KDiff *lrText, int startLine, int lines )
{
  QPainter pl;
  QPainter pr;
  QBrush brush;

  kDisplayText *kdt;
  
  int fLineShowXOffset = 0;
  int flineCharCount;
  int yPosTxt, yPosRect, xPosTxt;
  char dispStr[2048];

  dprintf( "START::drawTextToPixmaps( >%p<, >%d<, >%d< )\n", lrText, startLine, lines );

  if ( leftTextPi->isNull() == FALSE && rightTextPi->isNull() == FALSE )
  {

    pl.begin( leftTextPi ); 
    pl.setFont( drawTextFn );
    pl.setPen( foreCo );
    leftTextPi->fill( backCo );
 
    pr.begin( rightTextPi );
    pr.setFont( drawTextFn );
    pr.setPen( foreCo );
    rightTextPi->fill( backCo );

    flineCharCount = ( lineCount>10000?6:lineCount>1000?5:lineCount>100?4:3 ) + 1;
    xPosTxt = 5;
    if ( showFLines == TRUE )
    {
      fLineShowXOffset =flineCharCount * drawTextMt->width('W');
      xPosTxt = 5 + fLineShowXOffset;
    }

    // draw the lines into the left and right part
    for( int i = 0; i<=lines; i++ )
    {
      yPosRect=(i)*drawTextMt->height();
      yPosTxt = yPosRect + drawTextMt->height();

      // draw left text
      kdt = lrText->getLeftDisplayText( startLine + i );
      if ( kdt != 0 )
      {
        switch( kdt->attribut )
        {
          case DISPLAY_DELETE:
            brush=QBrush(deleteCo);
            pl.fillRect( xPosTxt, yPosRect+drawTextMt->descent(), leftTextPi->width() , drawTextMt->height(), brush );
          break;
          case DISPLAY_INSERT:
            brush=QBrush(insertCo);
            pl.fillRect( xPosTxt, yPosRect+drawTextMt->descent(),leftTextPi->width() , drawTextMt->height(), brush );     
          break;      
          case DISPLAY_CHANGE:
            brush = QBrush(changeCo);
            pl.fillRect( xPosTxt, yPosRect+drawTextMt->descent(), leftTextPi->width(), drawTextMt->height(), brush );     
          break;      
          default:
          break;   
        } // switch
  
        if ( showFLines == TRUE )
        {
           sprintf( dispStr, "%*d " ,flineCharCount-1, kdt->fLine );
           pl.drawText( 5, yPosTxt, dispStr );
        }

        pl.drawText( xPosTxt, yPosTxt, kdt->lineStr );

      } //if ( kdt != 0 )
      
      // draw right text
      kdt = lrText->getRightDisplayText( startLine + i );
      if ( kdt != 0 )
      {
        switch( kdt->attribut )
        {
          case DISPLAY_DELETE:
            brush=QBrush(deleteCo);
            pr.fillRect( xPosTxt, yPosRect+drawTextMt->descent(), rightTextPi->width() , drawTextMt->height(), brush );
          break;
          case DISPLAY_INSERT:
            brush=QBrush(insertCo);
            pr.fillRect( xPosTxt, yPosRect+drawTextMt->descent(),rightTextPi->width() , drawTextMt->height(), brush );     
          break;      
          case DISPLAY_CHANGE:
            brush = QBrush(changeCo);
            pr.fillRect( xPosTxt, yPosRect+drawTextMt->descent(), rightTextPi->width(), drawTextMt->height(), brush );     
          break;      
          default:
          break;   
        } // switch
        
        if ( showFLines == TRUE )
        {
           sprintf( dispStr, "%*d ",flineCharCount-1, kdt->fLine );
           pr.drawText( 5, yPosTxt, dispStr );
        }
        pr.drawText( xPosTxt, yPosTxt, kdt->lineStr );
      } // if ( kdt != 0 )
    
    } // for
  
    // draw the vertical line
    if ( showFLines == TRUE )
    { 
       pl.drawLine( xPosTxt - 5, 0, xPosTxt - 5, leftTextPi->height() );
       pr.drawLine( xPosTxt - 5, 0, xPosTxt - 5, rightTextPi->height() );
    }
    pr.end();
    pl.end();

  } //if ( leftTextPi->isNull() == FALSE && rightTextPi->isNull() == FALSE )

  dprintf( "END::drawTextToPixmaps( ... )=>void<\n");
} 


//
// Name: void kdiffDisplay::dropEvent;
//
// Comment: Emit the left or right drop-signals
//
// Parameter:
//
// ReturnParameter:
//
// ReturnValue:
//
void kdiffDisplay::dropEvent( KDNDDropZone *dropZone )
{
  QPoint mouseP;
  
  dprintf( "START::dropEvent( >%p< )\n", dropZone );

  mouseP = QPoint( dropZone->getMouseX(), dropZone->getMouseY() );
  mouseP = mapFromGlobal( mouseP );

  if (  leftTextRe.contains( mouseP ) == TRUE )
  {
    dprintf( "emit left\n");
    emit leftDropAction(dropZone); 
  }
  else
    if ( rightTextRe.contains( mouseP ) == TRUE )
    {
      dprintf( "emit right\n");
      emit rightDropAction(dropZone);  
    }
  dprintf( "END::dropEvent( ... )=>void<\n");
}
