/*
    xres  -  gvidm with command-line functionality
    Copyright (C) 2004 Steven Atkinson <stevenaaus@yahoo.com>
    gvidm - X11 video mode changer with a minimal interface
    Copyright (C) 2001 Matthew Mueller <donut@azstarnet.com>
    based on gvid:
    Copyright (C) 1999-2001 Keith Vanderline <kvand@mit.edu>
    
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "gvid.h"


Display		*display;
XF86VidModeModeInfo **vm_modelines;
int		vm_count;
char		*name;		/* argv[0] S.A. */


int switch_X11_Res(Display *display, int screen, int mode)
{
	XF86VidModeSwitchToMode(display, screen, vm_modelines[mode]);
	XFlush(display);
	return 1;
}

void GetUniqueModes(int screen) {
	/* My nvidia drive scans too many modes which I don't request....
	   Modes are generally ordered big to small and
	   here I dispose of all modes after the first out of order.
	*/
	int i, j, xres, last_xres ;

	i=0; xres=3000; /* big enough */

	XF86VidModeGetAllModeLines(display, screen, &vm_count, &vm_modelines);

	do {
		last_xres = xres;
		xres = vm_modelines[i]->hdisplay;
		i++;
	} while (xres <= last_xres && i < vm_count);

	if (i<vm_count) {
		for (j=i-1; j<vm_count; j++) {
			if (XF86VidModeDeleteModeLine(display, screen, vm_modelines[j]))
				printf ("mode %i deleted \n",j);
			else
				printf ("mode %i not deleted \n",j);
		}
		vm_count=i-1;
		printf ("new vm_count=%i",vm_count);
	}
}

void MenuEvent (GtkWidget *widget, gpointer mode_ptr)
{
	int mode_int, screen_count,i,j;

#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	memcpy(&mode_int, mode_ptr, sizeof(mode_int));

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	for (i=0; i<screen_count; i++)
	{
		GetUniqueModes(i);
		for (j=0; j<vm_count; j++)
		{
			if (mode_int--==0) switch_X11_Res(display, i, j);
		}
	}
}

void on_deactivate(void) {
	gtk_main_quit();
}

void create_popup(void)
{
	int i, j, screen_count, *mode_ptr, mode_number, dotclock;
	char label_str[80];
	GtkWidget *menuitem_ptr, *submenu_ptr, *menu_ptr;
	XF86VidModeModeLine modeline;
#ifdef HAVE_LIBXINERAMA
	int screen_exists[1024];
	XineramaScreenInfo *screen;
#endif

	mode_number=0;

#ifdef HAVE_LIBXINERAMA
	if (XineramaIsActive(display))
	{
		screen = XineramaQueryScreens(display, screen_exists);
		for (i=0; i==screen[i].screen_number; i++){}
		screen_count=i;
		XFree(screen);
	}
	else
	{
#endif
		screen_count=XScreenCount(display);
#ifdef HAVE_LIBXINERAMA
	}
#endif

	menu_ptr = gtk_menu_new();
	gtk_signal_connect (GTK_OBJECT (menu_ptr), "deactivate", GTK_SIGNAL_FUNC (on_deactivate), NULL);

	if (screen_count==1)
	{
		GetUniqueModes(0);
		XF86VidModeGetModeLine(display, 0, &dotclock, &modeline);
		for (j=0; j<vm_count; j++)
		{
			if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
				sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
			else
				sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

			mode_ptr = malloc(sizeof(mode_ptr));
			*mode_ptr = mode_number++;

			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
		}
	}
	else
	{
		for (i=0; i<screen_count; i++)
		{
			submenu_ptr = gtk_menu_new();
			sprintf(label_str, "Screen %i",i);
			menuitem_ptr = gtk_menu_item_new_with_label(label_str);
			gtk_menu_item_set_submenu(GTK_MENU_ITEM (menuitem_ptr), submenu_ptr);
			gtk_menu_append(GTK_MENU (menu_ptr), menuitem_ptr);
			gtk_widget_show(menuitem_ptr);
			gtk_widget_show(submenu_ptr);

			GetUniqueModes(i);
			XF86VidModeGetModeLine(display, i, &dotclock, &modeline);
			for (j=0; j<vm_count; j++)
			{
				if ((modeline.hdisplay==vm_modelines[j]->hdisplay)&&(modeline.vdisplay==vm_modelines[j]->vdisplay))
					sprintf(label_str, "* %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);
				else
					sprintf(label_str, "  %ix%i", vm_modelines[j]->hdisplay, vm_modelines[j]->vdisplay);

				mode_ptr = malloc(sizeof(mode_ptr));
				*mode_ptr = mode_number++;

				menuitem_ptr = gtk_menu_item_new_with_label(label_str);
				gtk_signal_connect(GTK_OBJECT (menuitem_ptr), "activate", GTK_SIGNAL_FUNC (MenuEvent), (gpointer)mode_ptr);
				gtk_menu_append(GTK_MENU (submenu_ptr), menuitem_ptr);
				gtk_widget_show(menuitem_ptr);
			}
		}
	}

	gtk_menu_popup(GTK_MENU(menu_ptr), NULL, NULL, NULL, NULL, 0, 0);
}

/* S.A. New procedures only handle single monitor displays.
   'vm_modelines' and 'vm_count' are now global variables.  */

void switch_mode_fail(char *message) {
	printf ("%s: %s\n",name,message);
	XFree(vm_modelines);
	exit(1);
}
void switch_mode_exit() {
	XFree(vm_modelines);
	exit(0);
}
void list_modes() {
        int j;

	GetUniqueModes(0);

	for (j=0; j<vm_count; j++)
		printf ("%ix%i ",vm_modelines[j]->hdisplay,\
			vm_modelines[j]->vdisplay);
	printf ("\n");
	switch_mode_exit();
}

/* My C is rusty and I couldn't get argc,argv working as global variables 
   Format of argv[2] is XXXxYYY
*/
void switch_mode(int argc, char **argv) {
        int x, y, j, j_match;
	char *y_string;

	if (argc != 3) 
		switch_mode_fail("wrong number args");
	if ((x=(int)strtol(argv[2],NULL,10))<=0) 
		switch_mode_fail("no x value");
	y_string=strchr(argv[2],'x');
	if (y_string==NULL)
		switch_mode_fail("no delimiter");
	if ((y=(int)strtol(++y_string,NULL,10))<=0)
                switch_mode_fail("no y value");

        GetUniqueModes(0);

	j_match=-1;
	for (j=0; j<vm_count; j++)
		if (vm_modelines[j]->hdisplay==x && \
			vm_modelines[j]->vdisplay==y) {
			j_match=j;
			break;
		};
		
		if (j_match>=0)
			switch_X11_Res(display, 0, j_match);	
		else
			switch_mode_fail("no such mode");

	switch_mode_exit();
}

/* find the mode with greatest X value and select */
void reset_mode() {
        int max_x, max_mode, j;

        GetUniqueModes(0);
	max_x=0;
	for (j=0; j<vm_count; j++)
		if (vm_modelines[j]->hdisplay>max_x) {
		max_mode=j;
		max_x=vm_modelines[j]->hdisplay;
	}
		
	switch_X11_Res(display, 0, max_mode);	

	switch_mode_exit();
}

void usage() {
	printf("\nUsage : %s [ -l | -r | -? | -m WidthxHeight ]\n\n"
	"Running with no options will popup a menu of possible resolutions.\n\n",name);
} /* end new procedures */

gint main(int argc,char **argv)
{
	/* S.A. copy string of unknown length ??? */
	int len=strlen(argv[0])+1;
	name=malloc(len);
	strcpy (name,argv[0]);

	if ((display=XOpenDisplay(""))==NULL) exit(1);
	if (argc > 1) {
		if (strcmp("-l",argv[1])==0) list_modes();
		if (strcmp("-r",argv[1])==0) reset_mode();
		if (strcmp("-m",argv[1])==0) switch_mode(argc,argv);
		if (strcmp("-?",argv[1])==0) { usage(); return 0; };
		printf("\n\
xres (C) 2004 Steven Atkinson <stevenaaus@yahoo.com>\n\
based on gvidm "M_VERSION" (C) 2001 Matthew Mueller <donut@azstarnet.com>\n\
based on gvid "VERSION" (C) 1999-2001 Keith Vanderline <kvand@mit.edu>\n\
Distributed under the terms of the GPL\n");
		usage();
		return 0;
	}
	gtk_init (&argc, &argv);
	create_popup();
	gtk_main ();
	return 0;
}
