/*	imv :	display image(s) 
  	built on "test.c" from imlib-devel.rpm by rasterman
	Changelog Steven A <stevenaaus@yahoo.com>
	10/11/01, 9/05/02, 3/11/02  (keypress dismiss),
	28/11/04 (debug feature, free images/windows as neccessary
		and program exit on middle button)
	
	No dynamic data allocation -> number of images limited
	
	space key press    : dispose
	q     key press    : dispose
	left   mouse click : dispose
	right  mouse click : lower
	middle mouse click : exit

	todo:	focus next window, might need an extra data
		structure BOOL winalive[MAX+1]
	todo:	change to imlib2
*/

#define MAX 150

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/extensions/shape.h>
#include <Imlib.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>

Display *disp;
ImlibData *id;
XSetWindowAttributes attr;
Window rootwindow, win[MAX+1];	/* arrays start at 0, but I start at 1 */
ImlibImage *im[MAX+1];
int debug;
int w,h,i;
int count, count_ok;		/* count=argc count_ok=argc-invalid */
struct stat st;			/* to check file existence */
XEvent ev;
KeyCode SPACE_KEY,Q_KEY;	/* constants */
extern char *basename();	/* pre-declare to avoid type warning (?) */

void err_message (const char *message,const char *arg) {
	fprintf(stderr,"imv: %s",message);
	if (arg!=NULL)
		fprintf(stderr," \"%s\"",arg);
	fprintf(stderr,"\n");
}

void CloseWindow (int i) { /* free imlib data, and close window */
	Imlib_kill_image(id,im[i]);
	XDestroyWindow (disp,win[i]);
	count_ok--;
	im[i] = NULL;
	win[i] = 0;
}

void CloseWhichWindow (Window w) { /* identify window and close */
	for (i=1; i<=count ; i++)
		if (win[i]==w) {
			CloseWindow (i);
			if (debug)
				printf ("closing %i\n",i-1); 
			return;
		} 
		err_message ("Can't close window :-<","");
}

int main(int argc, char **argv)
{

	/* if no args || arg[1] matches "-*" show usage */
	if ( argc<=1 || ((strncmp(argv[1],"-",1)==0) && (strcmp (argv[1],"-debug")!=0))) {
		printf("Usage: imv [-debug] image_file(s)\n");
		exit(1);
	}

	/* how many to do */
	if (argc-1>MAX) {
		printf ("%s: maximum %i images. Discarded images are -\n",argv[0],MAX);
		for (i=MAX+1; i<argc ; i++) 
			printf ("%s ",argv[i]);
		printf("\n");
		count=MAX;
	}
	else
		count=argc-1 ;
		
	disp=XOpenDisplay(NULL);	/* Connect to the default Xserver */
	id=Imlib_init(disp);		/* Immediately afterwards Intitialise Imlib */
	i=1;
	debug=0;
	rootwindow=DefaultRootWindow(disp);

	if (strcmp (argv[1],"-debug")==0) {
		i=2;
		debug=1;
		printf ("----------\n");
	}

	/* initialise images into windows */
	while (i<=count)
	{
		if (stat(argv[i],&st)==0)  /* check file exists */
		{
			if (S_ISREG(st.st_mode)) /* check is a regular file */
			{
				im[i]=Imlib_load_image(id,argv[i]);
				if (im[i]!=NULL)
				{	
					w=im[i]->rgb_width;h=im[i]->rgb_height;
	
					/* Create a Window to display in */
					win[i]=XCreateWindow(disp,rootwindow,0,0,w,h,0
					,id->x.depth, InputOutput,id->x.visual,0,&attr);
					if (debug)
						printf ("image %i, wid %X, %s\n",i-1,(int)win[i],basename(argv[i]));
					XStoreName(disp,win[i],basename(argv[i]));
					/* is this neccessary */
					XSelectInput(disp,win[i],
						ButtonPressMask |
						ButtonReleaseMask | KeyPressMask |
						KeyReleaseMask | FocusChangeMask );
	  				Imlib_apply_image(id,im[i],win[i]);
	  				XMapWindow(disp,win[i]); /* Display window */
					count_ok++;	/* number actual windows */
	
				}   /* i don't think Imlib fails and returns often */
				else err_message ("Imlib_load_image fail",argv[i]);
			}
			else err_message("Not a regular file",basename(argv[i]));
		}
		else err_message("No such file",argv[i]);

		i++;
	} /* while (initialise all images)*/
	if (debug)
		printf ("----------\ncount=%i, valid=%i\n----------\n",count-1,count_ok);
		/* count is -1 because of the "-debug" arg */


	XSync(disp,False);

	/* messy initialise constant */
	SPACE_KEY=XKeysymToKeycode(disp,XStringToKeysym("space"));
	Q_KEY=XKeysymToKeycode(disp,XStringToKeysym("q"));

	/* Event loop */   
	while (count_ok>0)
	{
		XNextEvent(disp,&ev);	/* Sit and wait for an event to happen */ 

		/* Raster had a handler for resize events here */
		if (ev.type==FocusIn) XAutoRepeatOff(disp);
		if (ev.type==FocusOut) XAutoRepeatOn(disp);
		/* &&& */
		if (ev.type==DestroyNotify) {
			/* well, this doesn't work - S.A
			  XAutoRepeatOn(disp);
			  exit;
			*/
		}
		if (ev.type==KeyPress) {
			if (ev.xkey.keycode==SPACE_KEY || ev.xkey.keycode==Q_KEY) {
				while (ev.type!=KeyRelease && ev.type!=FocusOut)
					XNextEvent (disp, &ev);
				CloseWhichWindow (ev.xany.window);
			}
		};
		if (ev.type==ButtonPress)
			switch ( ev.xbutton.button )
			{
				case Button3 :
					/* wait and get ButtonRelease, to stop it 
					   going to the underneath app. */
 					while (ev.type!=ButtonRelease)
                                                XNextEvent (disp, &ev);
					XLowerWindow (disp,ev.xany.window);
					if (debug)
						printf ("lowering %X\n",(int)ev.xany.window);
					break ;
				case Button2 :
					/* die you b*****d, but I'l bee nice and release everything */
					XAutoRepeatOn(disp);
					while (ev.type!=ButtonRelease)
						XNextEvent (disp, &ev);
				    for (i=1; i<=count ; i++) {
						if (win[i]!=0) {
						if (debug)
							printf ("killall %i\n",i-1); 
							Imlib_kill_image(id,im[i]);
							XDestroyWindow (disp,win[i]);
							count_ok--;
						}
					}
					if (debug)
						printf ("----------\n");
					exit (0);
				case Button1 :
					/* skip button release */
					while (ev.type!=ButtonRelease)
						XNextEvent (disp, &ev);
					CloseWhichWindow (ev.xany.window);
			};
	} /* while (event handling loop) */

	XAutoRepeatOn(disp);
	XSync(disp,False);	/* sync display before exit to enable repeat */
	exit(0);
}
