/*
 |
 |          Copyright (C) 1993, 1994, 1995, 1997, 1998 Hewlett-Packard Company
 |                         ALL RIGHTS RESERVED.
 |
 |	THIS MATERIAL IS PROVIDED "AS IS".  THERE ARE
 |	NO WARRANTIES OF ANY KIND WITH REGARD TO THIS
 |	MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE
 |	IMPLIED WARRANTIES OF MERCHANTABILITY AND
 |	FITNESS FOR A PARTICULAR PURPOSE.  Neither
 |	Hewlett-Packard nor Hugh Mahon shall be liable
 |	for errors contained herein, nor for
 |	incidental or consequential damages in
 |	connection with the furnishing, performance or
 |	use of this material.  Neither Hewlett-Packard
 |	nor Hugh Mahon assumes any responsibility for
 |	the use or reliability of this software or
 |	documentation.  This software and
 |	documentation is totally UNSUPPORTED.  There
 |	is no support contract available.  Hewlett-
 |	Packard has done NO Quality Assurance on ANY
 |	of the program or documentation.  You may find
 |	the quality of the materials inferior to
 |	supported materials.
 |
 |	This notice must be included with this software and any derivatives.
 |
 |
 |
 |	cutview.c
 |
 |	Display the (partial) contents of the X-Windows paste buffer.
 |
 |	written by Hugh Mahon 
 |
 |	Cutview allows the user to maintain a set of buffers containing
 |	the text from X-Windows cut operations.  The buffers may be edited
 |	within cutview, or an edit session outside of cutview may be started
 |	from a pop-up menu selection.  If the user wishes, 
 |	he can lock a buffer so that it won't be overwritten.
 |
 |
 |	$Source: /home/hugh/sources/cview/RCS/cutview.c,v $
 |	$Author: hugh $
 |	$State: Exp $  $Locker: hugh $
 |	$Date: 2001/02/04 03:54:27 $
 |
 */

char copyright_notice[] = 
	"Copyright (C) 1993, 1994, 1995, 1997, 1998 Hewlett-Packard Company, ALL RIGHTS RESERVED";

char version[] = "@(#)cutview $Revision: 1.63 $";

#define TRUE 1
#define FALSE 0
#include <stdio.h>
#include <fcntl.h>
#include <pwd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <time.h>
#include <errno.h>
#include <sys/wait.h>
#include <unistd.h>
#include <Xm/Xm.h>
#include <Xm/ArrowB.h>
#include <Xm/Text.h>
#include <Xm/Separator.h>
#include <Xm/PanedW.h>
#include <Xm/MenuShell.h>
#include <Xm/CascadeBG.h>
#include <Xm/SeparatoG.h>
#include <Xm/RowColumn.h>
#include <Xm/Form.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/Label.h>
#include <Xm/LabelG.h>
#include <Xm/DrawnB.h>
#include <Xm/ToggleB.h>
#include <X11/Xlib.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <X11/Intrinsic.h>
#include <X11/Xresource.h>
#include <Xm/Protocols.h>
#include <Xm/MwmUtil.h>

#ifndef SIGCLD
#define SIGCLD SIGCHLD
#endif

#define max(a, b) ((a) > (b) ? (a) : (b))

Display *disp_ptr;

struct menus {
	Widget menu;
	Widget buttons[32];
	};

Widget multi_buffer;
Widget pane;
struct menus multi_menu;

Widget single_buffer;
struct menus single_menu;
Widget single_form;
Widget arrow_buttons[2];
Widget lock_button;
Widget text_edit;
Widget single_menu_button;

Widget last_edited;			/* keeps track of last buffer to have
					   been edited.  		     */

XtIntervalId interval_id;
XtAppContext context_id;

XWMHints wmhints;

struct buffers {
	char *paste_buffer;		/* pointer to text in paste buffer   */
	int size_of_buff;		/* number of bytes in paste buffer   */
	char *display_text;		/* pointer to text displayed to user */
	int text_len;			/* length of text being displayed    */
	struct buffers *next, *prev;	/* pointers to next and prev buffers */
	int locked;			/* flag indicating if buffer is to be
					   overwritten (FALSE) or not (TRUE) */
	int curr_buff;			/* flag, TRUE if current buffer      */
	int editing;			/* flag, TRUE if buffer being edited */
	int access_stamp;		/* gives relative access of buffers  */
	Widget form;			/* form widget for this buffer       */
	Widget select_button;		/* toggle button for selecting buffer*/
	Widget button;			/* pb widget for this buffer (lock)  */
	Widget text_edit;		/* text widget for this buffer	     */
	time_t last_accessed;		/* time of last access 		     */
	};

struct buffers *list_of_buffers;	/* 'head' of buffer list	     */
struct buffers *curr_buffer;		/* most recent paste buffer	     */
struct buffers *tmp_buffer;		/* currently select buffer	     */
struct buffers *e_buffer;		/* buffer being edited		     */
struct buffers *garbage_list = NULL;	/* list of deleted buffers	     */

Boolean multi_buffer_mode = TRUE;
Boolean single_buffer_mode = FALSE;
Boolean changed_text = FALSE;
Boolean new_info = FALSE;
Boolean edit_in_progress = FALSE;
Boolean error_found;
Boolean file_read_flag = TRUE;	/* if false, do not read buffers file        */
Boolean small_window = FALSE;	/* if false, and num_of_buffs > 1, and toggle, 
				   start with small window (default is false */
Boolean toggle_windows = TRUE;	/* toggle windows 			     */
Boolean reset_paste_buffer = FALSE; /* do not check for changes in 
					text_changed_callback() until 
					reset_paste_buffer set true 	     */

Boolean update_flag = TRUE;	/*if false, do not update the buffers        */
Boolean help = FALSE;		/* if set, print usage message		     */
Boolean just_updated = TRUE;	/* if set, just updated text widget in check_buffer */
Boolean multi_resize_flag = FALSE;	/* allow buffers to resize	*/
Boolean single_resize_flag = FALSE;	/* allow buffers to resize	*/
Boolean locked_down = FALSE;		/* lock buffers and don't update */
Boolean setting_buffers = FALSE;	/* indicate buffers being set	*/
Boolean single_menu_flag = TRUE;	/* flag for turning on/off tab for 
					   a menu on the single buffer window*/

#if defined(__STDC__) || defined(__cplusplus)
#define P_(s) s
#else
#define P_(s) ()
#endif

void menu_event P_(( Widget, XEvent*, String*, Cardinal*));
void pick_callback P_((Widget, XtPointer, XtPointer));
void lock_callback P_((Widget, XtPointer, XtPointer));
void text_changed_callback P_((Widget, XtPointer, XtPointer));
void save_and_tell P_((Widget, XtPointer, XtPointer));
void quit P_((Widget, XtPointer, XtPointer));
void multi_to_single P_((Widget, XtPointer, XtPointer));
void single_to_multi P_((Widget, XtPointer, XtPointer));
void save_and_exit P_((int));
void Fatal_error P_((String));
void valueCB P_(( Widget, XtPointer, Atom*, Atom*, XtPointer, unsigned long*, int*));
void time_callback P_(( XtPointer, XtIntervalId*));
void clear_child P_((int));
void add_buffer P_((Widget, XtPointer, XtPointer));
void delete_a_buffer P_((Widget, XtPointer, XtPointer));
void edit_buffer P_((Widget, XtPointer, XtPointer));
void erase_a_buffer P_((Widget, XtPointer, XtPointer));
void print_buffer P_((Widget, XtPointer, XtPointer));
void save_the_buffers P_((Widget, XtPointer, XtPointer));
void toggle_update_callback P_((Widget, XtPointer, XtPointer));
void toggle_subset_callback P_((Widget, XtPointer, XtPointer));
void resize_set P_((String which));
void toggle_resize P_((Widget, XtPointer, XtPointer));
void up_button P_((Widget, XtPointer, XtPointer));
void down_button P_((Widget, XtPointer, XtPointer));
void save_buffers P_((void));
void read_buffers P_((void));
void inspect_buff_file P_((void));
void set_buffers P_((void));
void buffer_widgets P_((struct buffers *));
void set_up_single P_((int, char **));
void set_up_multi P_((int, char **));
void check_buffer P_((void));
void delete_buffer P_((struct buffers *));
void read_file P_((void));
int diff_buffers P_((int, char *));
int get_num P_((int));
void create_menu P_((Widget, struct menus *, int type));
void firstPosition P_((Widget));
static XImage *set_up_image P_((unsigned char *bits, int, int));
struct buffers *add_new_buffer P_((struct buffers *));
void find_buffer P_((Widget));
void check_for_changes P_((Widget));
void menu_button P_((Widget, XtPointer, XtPointer));
int subset_check P_((char *, int));


int num_of_buffs = 1;
int num_of_locked_buffs = 0;
int timer = 1;
int child_num = 0;
int print_child_num = 0;
int global_counter = 0;		/* counter for access stamp		     */

int arg;
unsigned int multi_width = 0;
unsigned int multi_height = 0;
int multi_x = 0;
int multi_y = 0;
unsigned int single_width = 0;
unsigned int single_height = 0;
int single_x = 0;
int single_y = 0;
int resize_index;
int buffer_height, buffer_width;
int global_argc, argc2;
char *global_argv[64], *argv_2[64];

#define CUTVIEW_FILE    ".cutview"
#define PRINT_COMMAND   "lp %s"
#define EDIT_COMMAND    "hpterm -e vi %s"

char edit_file_name[128];
char print_file_name[128];
char *print_command = PRINT_COMMAND;
char *edit_command = EDIT_COMMAND;
char *buff_file_name = CUTVIEW_FILE;
char buffers_file[128];
char *paste_buffer;
char *class_name = "CutView";
XmString update_options[2];
char *update_strings[] = {
	"Turn update on", 
	"Turn update off" };

XmString resize_options[2];
char *resize_strings[] = {
	"Turn resize on", 
	"Turn resize off" };

XmString subset_chk_opts[2];
char *subset_chk_strs[] = {
	"Turn subset check on", 
	"Turn subset check off" };

char subset_check_flag = FALSE;

XrmOptionDescRec options[] = {
	{ "-buffers",	"*buffers",	XrmoptionSepArg, (XtPointer) "1"}, 
	{ "-time",	"*time",	XrmoptionSepArg, (XtPointer) "1"}, 
	{ "-smallGeometry",	"*smallGeometry",	XrmoptionSepArg, (XtPointer) NULL}, 
	{ "-bigGeometry",	"*bigGeometry",	XrmoptionSepArg, (XtPointer) NULL}, 
	{ "-font",	"*fontList",	XrmoptionSepArg, (XtPointer) "fixed"}, 
	{ "-file",	"*buffersFile",	XrmoptionSepArg, (XtPointer) CUTVIEW_FILE}, 
	{ "-print",	"*printCommand", XrmoptionSepArg, (XtPointer) PRINT_COMMAND}, 
	{ "-edit",	"*editCommand", XrmoptionSepArg, (XtPointer) EDIT_COMMAND}, 
	{ "-small",	"*small",	XrmoptionNoArg, (XtPointer) "true"}, 
	{ "-smb",	"*singleMenu",	XrmoptionNoArg, (XtPointer) "off"}, 
	{ "-update",	"*update",	XrmoptionNoArg, (XtPointer) "off"}, 
	{ "-read",	"*readFile",	XrmoptionNoArg, (XtPointer) "off"}, 
	{ "-toggle",	"*toggle",	XrmoptionNoArg, (XtPointer) "off"}, 
	{ "-subset",	"*subset",	XrmoptionNoArg, (XtPointer) "on"}, 
	{ "-resize",	"*resize",	XrmoptionNoArg, (XtPointer) "on"}, 
	{ "-help",	"*help",	XrmoptionNoArg, (XtPointer) "on"}, 
	{ "-?",	"*help",	XrmoptionNoArg, (XtPointer) "on"}
	};

typedef struct app_info {
	Boolean small;
	Boolean single_menu;
	Boolean read;
	Boolean toggle;
	Boolean update;
	Boolean help;
	Boolean resize;
	Boolean subset;
	int 	buffers;
	int 	timer;
	char   *smallGeometry;
	char   *bigGeometry;
	char   *file_name;
	char   *print_command;
	char   *edit_command;
	} app_info, *info_pointer;

app_info cutview_info;

XtResource resources[] = {
	{ "buffers", "Buffers", XtRInt, sizeof(int), 
		XtOffset(info_pointer, buffers), XtRInt, (XtPointer) &num_of_buffs}, 
	{ "time", "Time", XtRInt, sizeof(int), 
		XtOffset(info_pointer, timer), XtRInt, (XtPointer) &timer}, 
	{ "small", "Small", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, small), XtRBoolean, (XtPointer) &small_window}, 
	{ "singleMenu", "SingleMenu", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, single_menu), XtRBoolean, (XtPointer) &single_menu_flag}, 
	{ "update", "Update", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, update), XtRBoolean, (XtPointer) &update_flag}, 
	{ "read", "Read", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, read), XtRBoolean, (XtPointer) &file_read_flag}, 
	{ "toggle", "Toggle", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, toggle), XtRBoolean, (XtPointer) &toggle_windows}, 
	{ "subset", "Subset", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, subset), XtRBoolean, (XtPointer) &subset_check_flag}, 
	{ "resize", "Resize", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, resize), XtRBoolean, (XtPointer) &single_resize_flag}, 
	{ "help", "Help", XtRBoolean, sizeof(Boolean), 
		XtOffset(info_pointer, help), XtRBoolean, (XtPointer) &help}, 
	{ "smallGeometry", "SmallGeometry", XtRString, sizeof(String), 
		XtOffset(info_pointer, smallGeometry), XtRString, (XtPointer) ""}, 
	{ "bigGeometry", "BigGeometry", XtRString, sizeof(String), 
		XtOffset(info_pointer, bigGeometry), XtRString, (XtPointer) ""}, 
	{ "buffersFile", "BuffersFile", XtRString, sizeof(String), 
		XtOffset(info_pointer, file_name), XtRString, (XtPointer) CUTVIEW_FILE}, 
	{ "printCommand", "PrintCommand", XtRString, sizeof(String), 
		XtOffset(info_pointer, print_command), XtRString, (XtPointer) PRINT_COMMAND}, 
	{ "editCommand", "EditCommand", XtRString, sizeof(String), 
		XtOffset(info_pointer, edit_command), XtRString, (XtPointer) EDIT_COMMAND}, 
	};

#define big_lock_width 15
#define big_lock_height 15
static unsigned char big_lock_bits[] = {
   0xf0, 0x07, 0xf8, 0x0f, 0x1c, 0x1c, 0x0c, 0x18, 0x0c, 0x18, 0x0c, 0x18,
   0x0c, 0x18, 0xfe, 0x3f, 0xfe, 0x3f, 0xfe, 0x3f, 0x3e, 0x3e, 0x3e, 0x3e,
   0xfe, 0x3f, 0xfe, 0x3f, 0x00, 0x00};

#define big_key_width 15
#define big_key_height 15
static unsigned char big_key_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xfe, 0x3f, 0xff, 0x3f,
   0x0f, 0x66, 0x1b, 0x66, 0x1b, 0x66, 0x1b, 0x3e, 0x1b, 0x1c, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

#define Selected_width 15
#define Selected_height 15
static unsigned char Selected_bits[] = {
   0xe0, 0x00, 0xe0, 0x01, 0xe0, 0x03, 0xe0, 0x07, 0xff, 0x0f, 0xff, 0x1f,
   0xff, 0x3f, 0xff, 0x7f, 0xff, 0x3f, 0xff, 0x1f, 0xff, 0x0f, 0xe0, 0x07,
   0xe0, 0x03, 0xe0, 0x01, 0xe0, 0x00};

#define unSelected_width 15
#define unSelected_height 15
static unsigned char unSelected_bits[] = {
   0x10, 0x01, 0x10, 0x02, 0x10, 0x04, 0x07, 0x00, 0x00, 0x10, 0x00, 0x20,
   0x00, 0x40, 0x00, 0x00, 0x00, 0x40, 0x00, 0x20, 0x00, 0x10, 0x07, 0x00,
   0x10, 0x04, 0x10, 0x02, 0x10, 0x01};

#define menu_width 16
#define menu_height 16
static unsigned char menu_bits[] = {
   0x00, 0x00, 0xe0, 0x7f, 0x20, 0x40, 0xbe, 0x5f, 0x22, 0x40, 0x22, 0x40,
   0xa2, 0x5f, 0x3e, 0x40, 0x20, 0x40, 0xa0, 0x5f, 0x20, 0x40, 0x20, 0x40,
   0xa0, 0x5f, 0x20, 0x40, 0xe0, 0x7f, 0x00, 0x00};

#define cutview_width 50
#define cutview_height 50
static unsigned char cutview_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00,
   0x00, 0x00, 0x08, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x80,
   0x01, 0x00, 0x00, 0x00, 0x18, 0x00, 0x80, 0x01, 0x00, 0x00, 0x00, 0x28,
   0x00, 0x40, 0x01, 0x00, 0x00, 0x00, 0x28, 0x00, 0x40, 0x01, 0x00, 0x00,
   0x00, 0x28, 0x00, 0x40, 0x01, 0x00, 0x00, 0x00, 0x48, 0x00, 0x20, 0x01,
   0x00, 0x00, 0x00, 0x48, 0x00, 0x20, 0x01, 0x00, 0x00, 0x00, 0x90, 0x00,
   0x90, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00,
   0x20, 0x01, 0x48, 0x00, 0x00, 0x00, 0x00, 0x20, 0x01, 0x48, 0x00, 0x00,
   0x00, 0x00, 0x60, 0x01, 0x68, 0x00, 0x00, 0x00, 0x00, 0x40, 0x02, 0x24,
   0x00, 0x00, 0x00, 0x00, 0xc0, 0x02, 0x34, 0x00, 0x00, 0x00, 0x00, 0x80,
   0x05, 0x1a, 0x00, 0x00, 0x00, 0x00, 0x00, 0x05, 0x0a, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x07, 0x0e, 0x00, 0xff, 0x1f, 0x00, 0x00, 0x0a, 0x05, 0xc0,
   0x23, 0x78, 0x00, 0x00, 0x0e, 0x07, 0x70, 0x10, 0x90, 0x03, 0x00, 0x9c,
   0x03, 0x00, 0x90, 0x13, 0x00, 0x00, 0x98, 0x01, 0x00, 0x90, 0x13, 0x00,
   0x00, 0xf8, 0x01, 0x00, 0x90, 0x13, 0x00, 0x00, 0xf0, 0x00, 0x70, 0x10,
   0x10, 0x02, 0x00, 0xf0, 0x00, 0x80, 0x27, 0xf8, 0x01, 0x00, 0x60, 0x00,
   0x00, 0xf8, 0x1f, 0x00, 0x00, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x90, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00,
   0x00, 0x00, 0x00, 0x00, 0x08, 0x01, 0x00, 0x00, 0x00, 0x00, 0xc0, 0x07,
   0x82, 0x00, 0x00, 0x00, 0x00, 0x60, 0x04, 0x62, 0x03, 0x00, 0x00, 0x00,
   0x20, 0x02, 0x14, 0x04, 0x00, 0x00, 0x00, 0x30, 0x02, 0x14, 0x04, 0x00,
   0x00, 0x00, 0x10, 0x02, 0x08, 0x08, 0x00, 0x00, 0x00, 0x18, 0x01, 0x18,
   0x04, 0x00, 0x00, 0x00, 0x08, 0x01, 0x10, 0x04, 0x00, 0x00, 0x00, 0x88,
   0x00, 0x70, 0x03, 0x00, 0x00, 0x00, 0x98, 0x00, 0x80, 0x00, 0x00, 0x00,
   0x00, 0x78, 0x00, 0x80, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x03,
   0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x2a, 0x00, 0x00, 0x00,
   0x00, 0x00, 0x00, 0x22, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
   0x00, 0x00};

Pixmap Selected[2];
Pixmap locked[2];
Pixmap icon_pix;
Pixmap menu_pix;

XImage *Selected_image[2];
XImage *locked_image[2];
XImage *menu_image;

/*
 |	Set up translation table for activating the menu.
 */

static XtActionsRec actionsTable [] = {
	{"menu", menu_event},
};

static char defaultTranslations[] = "<Btn3Down>: menu()";

XtTranslations trans_table;

#ifdef PRE_70
/* ---------------------- */
#define NULL 0

char *strstr(s1, s2)
char *s1, *s2;
{
    register char *p, *q, *r;

        if (*s2 == '\0' && *s1 == '\0')
            return(s1);

        for (r = s1; *r != '\0'; ++r)
        {
            p = r;
            q = s2;

            while (*q != '\0' && *p == *q)
                ++p, ++q;

            if (*q == '\0')
                return(r);
        }

        return NULL;
}
#endif

void 
firstPosition(widget)
Widget widget;
{
	Arg arglist[1];

	XtSetArg(arglist[0], XmNcursorPosition, 0);
	XtSetValues(widget, arglist, 1);
}

static XImage *
set_up_image(bits, width, height)
unsigned char *bits;
int width, height;
{
	XImage *image;

	image = (XImage *) XtMalloc (sizeof (XImage));
	image->width = width;
	image->height = height;
	image->data = (char *)bits;
	image->depth = 1;
	image->xoffset = 0;
	image->format = XYBitmap;
	image->byte_order = LSBFirst;
	image->bitmap_unit = 8;
	image->bitmap_bit_order = LSBFirst;
	image->bitmap_pad = 8;
	image->bytes_per_line = (width+7)/8;
	return (image);
}

struct buffers *add_new_buffer(start_of_list)
struct buffers *start_of_list;
{
	struct buffers *new_buffer;

	new_buffer = (struct buffers *) malloc(sizeof(struct buffers));
	new_buffer->paste_buffer = (char *)malloc(1);
	new_buffer->paste_buffer[0] = (char)NULL;
	new_buffer->size_of_buff = 0;
	new_buffer->editing = FALSE;
	new_buffer->locked = FALSE;
	new_buffer->curr_buff = FALSE;
	new_buffer->access_stamp = 0;
	if (start_of_list == NULL)
	{
		new_buffer->next = new_buffer;
		new_buffer->prev = new_buffer;
	}
	else
	{
		new_buffer->next = start_of_list;
		new_buffer->prev = start_of_list->prev;
		start_of_list->prev = new_buffer;
		new_buffer->prev->next = new_buffer;
	}

	return(new_buffer);
}

void 
find_buffer(widg)
Widget widg;
{
	struct buffers *temp;
	int counter, widget_found;

	XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);
/*
 |	find the buffer this widget belongs to
 */
	for (counter = 0, temp = list_of_buffers, widget_found = FALSE;
		(counter < num_of_buffs) && (!widget_found); counter++)
	{
		if ((widg == temp->text_edit) || 
		    (widg == temp->button) || 
		    (widg == temp->select_button))
		{
			if (curr_buffer != temp)
			{
				curr_buffer->curr_buff = FALSE;
				XmTextClearSelection(curr_buffer->text_edit, 0);
				firstPosition(curr_buffer->text_edit);
				curr_buffer = temp;
				curr_buffer->curr_buff = TRUE;
			}
			XmToggleButtonSetState(
			   curr_buffer->select_button, TRUE, FALSE);
			XmTextSetString(text_edit, curr_buffer->paste_buffer);
			changed_text = FALSE;
			curr_buffer->access_stamp = global_counter++;
			XmToggleButtonSetState(lock_button, 
					curr_buffer->locked, FALSE);
			if (update_flag)
			{
				XStoreBytes(disp_ptr, 
					curr_buffer->paste_buffer, 
					curr_buffer->size_of_buff);
				if (curr_buffer->size_of_buff > 0)
				{
					XmTextSetSelection(
					  curr_buffer->text_edit, 0, 
					  curr_buffer->size_of_buff, 0);
				}
				firstPosition(curr_buffer->text_edit);
			}
			widget_found = TRUE;
		}
		else
			temp = temp->next;
	}
}

/*
 |	This buffer keeps track of the last buffer that was modified using the
 |	text edit widget.  If the argument is different than the last modified
 |	widget, then the text is grabbed from the last widget and shoved into 
 |	the current buffer.  The current buffer is then changed to the buffer
 |	that owns the text editor widget passed.
 */

void 
check_for_changes(widg)
Widget widg;
{
	if (setting_buffers)
		return;

	/*
	 |	if contents have changed, but can't write buffers file, 
	 |	then reset buffers content to original values
	 */

	if ((changed_text) && (locked_down))
	{
		set_buffers();
	}

	if ((widg == text_edit) || (widg == lock_button))
		return;

	if (widg == last_edited)
		return;

	if ((changed_text) && (!locked_down))
	{
		free(curr_buffer->paste_buffer);
		curr_buffer->curr_buff = FALSE;
		curr_buffer->paste_buffer = 
				XmTextGetString(curr_buffer->text_edit);
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		if (curr_buffer->locked)
			save_buffers();
	}

	XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

/*
 |	find the buffer this widget belongs to
 */
	find_buffer(widg);

	if (widg == curr_buffer->text_edit)
		last_edited = widg;
	else
		last_edited = 0;
}

void 
pick_callback(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{

/*
 |	find the buffer this widget belongs to
 */
	check_for_changes(widg);

	XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);

	last_edited = 0;
}

void 
lock_callback(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int temp_changed_text;
	int widget_found = FALSE;

	if ((single_buffer_mode) && (widg == lock_button))
	{
		widget_found = TRUE;
		XmToggleButtonSetState(curr_buffer->button, 
						(!curr_buffer->locked), FALSE);
	}

/*
 |	find the buffer this widget belongs to
 */
	if (!widget_found)
	{
		check_for_changes(widg);
		XmToggleButtonSetState(lock_button, !curr_buffer->locked, FALSE);
	}

	curr_buffer->locked = !curr_buffer->locked;

	if (curr_buffer->locked)
	{
		num_of_locked_buffs++;
	}
	else
		num_of_locked_buffs--;

	save_buffers();

	if (num_of_locked_buffs == num_of_buffs)
	{
/*
 |	adding a buffer will mean losing the status of changed_text if 
 |	it's TRUE, so save it and reset it after adding the buffer
 */

		temp_changed_text = changed_text;

		add_buffer(NULL, NULL, NULL);

		changed_text = temp_changed_text;
	}
}

void 
text_changed_callback(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int widget_found = FALSE;

	if (!reset_paste_buffer)
		return;

	if (just_updated)
	{
		just_updated = FALSE;
		return;
	}

	if (!strcmp(client_data, "changed"))
	{
		if (widg != text_edit)
			check_for_changes(widg);

		changed_text = TRUE;
		return;
	}

	if ((single_buffer_mode) && (widg == text_edit) && (changed_text))
	{
		widget_found = TRUE;
		free(curr_buffer->paste_buffer);
		curr_buffer->paste_buffer = XmTextGetString(text_edit);
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		XmTextSetString(curr_buffer->text_edit, 
			curr_buffer->paste_buffer);
		changed_text = FALSE;
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		if (update_flag)
		{
			XStoreBytes(disp_ptr, curr_buffer->paste_buffer, 
						curr_buffer->size_of_buff);
			XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);
			firstPosition(curr_buffer->text_edit);
		}

		if (curr_buffer->locked)
			save_buffers();
	}

/*
 |	find the buffer this widget belongs to
 */
	if ((!widget_found) && (changed_text))
	{
		free(curr_buffer->paste_buffer);
		curr_buffer->curr_buff = FALSE;
		curr_buffer->paste_buffer = 
				XmTextGetString(curr_buffer->text_edit);
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		if (curr_buffer->locked)
			save_buffers();
		find_buffer(widg);
	}
}

void 
buffer_widgets(buffer)
struct buffers *buffer;
{
	int counter;
	Arg arglist[32];
	Dimension width, button_width, edit_width, height;
	Pixel foreground, background;

	counter = 0;
	XtSetArg(arglist[counter], XmNorientation, XmHORIZONTAL);
	counter++;
	XtSetArg(arglist[counter], XmNancestorSensitive, True);
	counter++;
	XtSetArg(arglist[counter], XmNsensitive, True);
	counter++;
	XtSetArg(arglist[counter], XmNallowOverlap, False);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;
	buffer->form = XmCreateForm(pane, "form", arglist, counter);

	counter = 0;
	XtSetArg(arglist[counter], XmNforeground, &foreground);
	counter++;
	XtSetArg(arglist[counter], XmNbackground, &background);
	counter++;
	XtGetValues(pane, arglist, counter);

	Selected[0] = XmGetPixmap(XtScreen(pane), "notChosen", foreground, background);
	Selected[1] = XmGetPixmap(XtScreen(pane), "Chosen", foreground, background);

	locked[0] = XmGetPixmap(XtScreen(pane), "key", foreground, background);
	locked[1] = XmGetPixmap(XtScreen(pane), "padlock", foreground, background);

	counter = 0;
	XtSetArg(arglist[counter], XmNautoShowCursorPosition, True);
	counter++;
	XtSetArg(arglist[counter], XmNlabelType, XmPIXMAP);
	counter++;
	XtSetArg(arglist[counter], XmNselectPixmap, Selected[1]);
	counter++;
	XtSetArg(arglist[counter], XmNselectInsensitivePixmap, Selected[1]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelPixmap, Selected[0]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelInsensitivePixmap, Selected[0]);
	counter++;
	XtSetArg(arglist[counter], XmNset, buffer->curr_buff);
	counter++;
/*	XtSetArg(arglist[counter], XmNwidth, Selected_width);
	counter++;*/
	XtSetArg(arglist[counter], XmNindicatorOn, False);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;
	XtSetArg(arglist[counter], XmNvisibleWhenOff, TRUE);
	counter++;

	buffer->select_button = XmCreateToggleButton(
	   buffer->form, "showbutton", arglist, counter);

	XtManageChild(buffer->select_button);
	XtSetSensitive(buffer->select_button, True);

	XtAddCallback(buffer->select_button, XmNvalueChangedCallback, pick_callback, "pick_buffer");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &button_width);
	counter++;
	XtGetValues(buffer->select_button, arglist, counter);

	width = button_width;

	counter = 0;
	XtSetArg(arglist[counter], XmNlabelType, XmPIXMAP);
	counter++;
	XtSetArg(arglist[counter], XmNselectPixmap, locked[1]);
	counter++;
	XtSetArg(arglist[counter], XmNselectInsensitivePixmap, locked[1]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelPixmap, locked[0]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelInsensitivePixmap, locked[0]);
	counter++;
	XtSetArg(arglist[counter], XmNset, buffer->locked);
	counter++;
	XtSetArg(arglist[counter], XmNindicatorOn, False);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, buffer->select_button);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	buffer->button = XmCreateToggleButton(
	   buffer->form, "toggle_button", arglist, counter);

	XtManageChild(buffer->button);
	XtSetSensitive(buffer->button, True);

	XtAddCallback(buffer->button, XmNvalueChangedCallback, lock_callback, "lockbutton");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &button_width);
	counter++;
	XtGetValues(buffer->button, arglist, counter);

	width += button_width;

	counter = 0;
	if (multi_height > 0)
	{
		XtSetArg(arglist[counter], XmNrows, multi_height);
		counter++;
	}
	if (multi_width > 0)
	{
		XtSetArg(arglist[counter], XmNcolumns, multi_width);
		counter++;
	}
	XtSetArg(arglist[counter], XmNscrollVertical, False);
	counter++;
	XtSetArg(arglist[counter], XmNscrollHorizontal, False);
	counter++;
	XtSetArg(arglist[counter], XmNeditMode, XmMULTI_LINE_EDIT);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, buffer->button);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	buffer->text_edit = XmCreateText(buffer->form, "text", arglist, counter);

	XtManageChild(buffer->text_edit);

	XtSetSensitive(buffer->text_edit, True);

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &edit_width);
	counter++;
	XtSetArg(arglist[counter], XmNheight, &height);
	counter++;
	XtGetValues(buffer->text_edit, arglist, counter);

	XmTextSetString(buffer->text_edit, buffer->paste_buffer);

	changed_text = FALSE;

	XtAddCallback(buffer->text_edit, XmNvalueChangedCallback, 
		text_changed_callback, "changed");

	XtAddCallback(buffer->text_edit, XmNlosingFocusCallback, 
		text_changed_callback, "focus_lost");

	width += edit_width;

	buffer_height = height;
	buffer_width = width;

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, width);
	counter++;
	XtSetArg(arglist[counter], XmNheight, height);
	counter++;
	XtSetValues(buffer->form, arglist, counter);
	XtManageChild(buffer->form);
}

/*
 |	When a fatal error occurs, print the message, save the buffers, 
 |	and exit.
 */

void 
Fatal_error(message)
String message;
{
	printf("%s\n", message);

	if (global_counter > num_of_buffs)
		save_buffers();

	exit(0);
}

void 
save_and_tell(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	char **argv_return;
	int argc_return;

	save_buffers();

	/* 
	 | This basically just updates the WM_COMMAND property.  The session
	 | manager is waiting for this to happen.
	 */

	XGetCommand(XtDisplay(single_buffer), XtWindow(single_buffer), &argv_return, &argc_return);
	XSetCommand(XtDisplay(single_buffer), XtWindow(single_buffer), argv_return, argc_return);

}

void 
save_the_buffers(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	save_buffers();
}

void 
save_and_exit(arg)
int arg;
{
	save_buffers();
	exit(1);
}

void 
main(argc, argv)
int argc;
char *argv[];
{
	int counter;
	int result;
	Arg arglist[10];
	struct buffers *temp;
	char name[128];
	char *temp_string;
	Atom wm_saveself;


	for (global_argc = 0; global_argc < argc; global_argc++)
	{
		global_argv[global_argc] = (char *)malloc(strlen(argv[global_argc]) +1);
		argv_2[global_argc] = (char *)malloc(strlen(argv[global_argc]) +1);
		strcpy(global_argv[global_argc], argv[global_argc]);
		strcpy(argv_2[global_argc], argv[global_argc]);
	}
	argc2 = global_argc;

	if (strchr(argv[0], '/'))
		strcpy(name, (strrchr(argv[0], '/') + 1));
	else
		strcpy(name, argv[0]);

	/*
	 |	set up use of localization
	 */

	XtSetLanguageProc(NULL, NULL, NULL);

	/*
	 |	create the shell widget for the single buffer window
	 */

        single_buffer = XtAppInitialize(&context_id, class_name, options, 
                                        XtNumber(options), &argc, argv,
                                        NULL, NULL, 0);


        disp_ptr = XtDisplay(single_buffer);

	XtGetApplicationResources(single_buffer, &cutview_info, resources, 
                                  XtNumber(resources), NULL, 0);

	/*
	 |	create the shell widget for the multi buffer window
	 */

	multi_buffer = XtAppCreateShell(NULL, class_name, 
		applicationShellWidgetClass, disp_ptr, NULL, 0);


	/*
	 |	Set up translations.
	 */

	XtAppAddActions(context_id, actionsTable, XtNumber(actionsTable));
	trans_table = XtParseTranslationTable(defaultTranslations);

	/*
	 |	set up bitmaps for lock, key, and icon
	 */

	Selected_image[1] = set_up_image(Selected_bits, 
				Selected_width, Selected_height);

	Selected_image[0] = set_up_image(unSelected_bits, 
				unSelected_width, unSelected_height);

	locked_image[0] = set_up_image(big_key_bits, big_key_width, 
							big_key_height);
	locked_image[1] = set_up_image(big_lock_bits, big_lock_width, 
							big_lock_height);
	menu_image = set_up_image(menu_bits, menu_width, menu_height);

	XmInstallImage(Selected_image[0], "notChosen");
	XmInstallImage(Selected_image[1], "Chosen");
	XmInstallImage(locked_image[0], "key");
	XmInstallImage(locked_image[1], "padlock");
	XmInstallImage(menu_image, "menu");

	icon_pix = XCreateBitmapFromData(disp_ptr, DefaultRootWindow(disp_ptr), 
			(char *) cutview_bits, cutview_width, cutview_height);

	XtSetArg(arglist[0], XtNallowShellResize, TRUE);
	XtSetArg(arglist[1], XmNiconPixmap, icon_pix);
	XtSetValues(single_buffer, arglist, 2);
	XtSetValues(multi_buffer, arglist, 2);

	update_options[0] = XmStringCreate(update_strings[0], XmSTRING_DEFAULT_CHARSET);
	update_options[1] = XmStringCreate(update_strings[1], XmSTRING_DEFAULT_CHARSET);

	resize_options[0] = XmStringCreate(resize_strings[0], XmSTRING_DEFAULT_CHARSET);
	resize_options[1] = XmStringCreate(resize_strings[1], XmSTRING_DEFAULT_CHARSET);

	subset_chk_opts[0] = XmStringCreate(subset_chk_strs[0], XmSTRING_DEFAULT_CHARSET);
	subset_chk_opts[1] = XmStringCreate(subset_chk_strs[1], XmSTRING_DEFAULT_CHARSET);

	/*
	 |	set up default values
	 */

/*	XtGetApplicationResources(single_buffer, &cutview_info, resources, XtNumber(resources), NULL, 0); */

	num_of_buffs = cutview_info.buffers;
	small_window = cutview_info.small;
	timer = cutview_info.timer;
	file_read_flag = cutview_info.read;
	update_flag = cutview_info.update;
	subset_check_flag = cutview_info.subset;
	single_menu_flag = cutview_info.single_menu;


	if (cutview_info.help)
	{
		fprintf(stderr, "usage: %s [options]\n", argv[0]);
		fprintf(stderr, "          -buffers number of buffers\n");
		fprintf(stderr, "          -file name of file to read/save buffers contents\n");
		fprintf(stderr, "          -read do not read saved buffers file\n");
		fprintf(stderr, "          -resize resize single buffer window according to contents\n");
		fprintf(stderr, "          -small start with the small window\n");
		fprintf(stderr, "          -smb  turn off menu button on small window\n");
		fprintf(stderr, "          -subset turn on subset checking\n");
		fprintf(stderr, "          -time time between paste buffer checks in seconds\n");
		fprintf(stderr, "          -toggle do not toggle betwen single- and multi-buffers windows\n");
		fprintf(stderr, "          -update do not update buffers\n");
		fprintf(stderr, "          -smallGeometry =geometry\n");
		fprintf(stderr, "          -big =geometry for multi-buffers window\n");
		fprintf(stderr, "          -name name of resources in X defaults to use\n");
		fprintf(stderr, "          -title name of window\n");
		fprintf(stderr, "          -display display name\n");
		fprintf(stderr, "          -rv (reverse video)\n");
		fprintf(stderr, "          -bg background color\n");
		fprintf(stderr, "          -fg foreground color\n");
		fprintf(stderr, "          -font font name\n");
		fprintf(stderr, "          -help print list of options\n");
		exit(-1);
	}

	/*
	 |	if smallGeometry specified, get size info
	 */

	if ((cutview_info.smallGeometry != NULL) && (cutview_info.smallGeometry[0] != (char)NULL))
	{
		result = XParseGeometry(cutview_info.smallGeometry, &single_x, &single_y, &single_width, &single_height);
		if (single_x < 0)
			single_x = -single_x;
		if (single_y < 0)
			single_y = -single_y;
		sprintf(name, "=%c%d%c%d", 
				(result & XNegative) ? '-' : '+', single_x, 
				(result & YNegative) ? '-' : '+', single_y);
		temp_string = (char *) malloc(strlen(name) + 1);
		strcpy(temp_string, name);

		XtSetArg(arglist[0], XtNgeometry, temp_string);
		XtSetValues(single_buffer, arglist, 1);
	}

	if (single_width <= 0)
	{
		single_width = 30;
	}

	if (single_height <= 0)
	{
		single_height = 1;
	}

	/*
	 |	if bigGeometry specified, get information
	 */

	if ((cutview_info.bigGeometry != NULL) && (cutview_info.bigGeometry[0] != (char)NULL))
	{
		result = XParseGeometry(cutview_info.bigGeometry, &multi_x, &multi_y, &multi_width, &multi_height);
		if (multi_x < 0)
			multi_x = -multi_x;
		if (multi_y < 0)
			multi_y = -multi_y;
		sprintf(name, "=%c%d%c%d", 
				(result & XNegative) ? '-' : '+', multi_x, 
				(result & YNegative) ? '-' : '+', multi_y);
		temp_string = (char *) malloc(strlen(name) + 1);
		strcpy(temp_string, name);
	
		XtSetArg(arglist[0], XtNgeometry, temp_string);
		XtSetValues(multi_buffer, arglist, 1);
	}

	if (multi_width <= 0)
	{
		multi_width = 30;
	}

	if (multi_height <= 0)
	{
		multi_height = 1;
	}

	if ((cutview_info.print_command) && (cutview_info.print_command[0] != (char)NULL))
		print_command = cutview_info.print_command;
	if ((cutview_info.edit_command) && (cutview_info.edit_command[0] != (char)NULL))
		edit_command = cutview_info.edit_command;
	if ((cutview_info.file_name) && (cutview_info.file_name[0] != (char)NULL))
		buff_file_name = cutview_info.file_name;
	toggle_windows = cutview_info.toggle;

	error_found = FALSE;
	if (!strstr(print_command, "%s"))
	{
		fprintf(stderr, "invalid print command string\n");
		error_found = TRUE;
	}

	if (!strstr(edit_command, "%s"))
	{
		fprintf(stderr, "invalid edit command string\n");
		error_found = TRUE;
	}

	if (error_found)
		exit(1);

	if (strchr(buff_file_name, '/'))	/* if a slash is in the name, 
						meaning a path		*/
	{
		strcpy(buffers_file, buff_file_name);
	}
	else				/* if no path, relative or absolute,
					   is specified, look in the home
					   directory			*/
	{
		strcpy(buffers_file, (char *)getenv("HOME"));
		strcat(buffers_file, "/");
		strcat(buffers_file, buff_file_name);
	}

	/*
	 |	make sure there is at least one buffer to keep info in
	 */

	if (num_of_buffs < 1)
		num_of_buffs = 1;

	if (timer < 1)
		timer = 1;

	if ((small_window) || (!toggle_windows))
	{
		single_buffer_mode = TRUE;
		multi_buffer_mode = FALSE;
	}

	list_of_buffers = add_new_buffer(NULL);

	for (counter = 1; counter < num_of_buffs; counter++)
	{
		add_new_buffer(list_of_buffers);
	}

	curr_buffer = list_of_buffers->prev;

	/*
	 |	get contents of buffers from previous invocation of cutview 
	 |	(if the buffers file exists)
	 */

	if (file_read_flag)
	{
		read_buffers();
		inspect_buff_file();
	}

	set_up_single(argc, argv);
	set_up_multi(argc, argv);

	XtSetMappedWhenManaged(single_buffer, single_buffer_mode);
	XtRealizeWidget(single_buffer);

	XtSetMappedWhenManaged(multi_buffer, multi_buffer_mode);
	XtRealizeWidget(multi_buffer);

	/*
	 |	Merge program defined translations into those from 
	 |	other sources.
	 */

	XtOverrideTranslations(multi_buffer, trans_table);
	XtOverrideTranslations(single_buffer, trans_table);

	/* 
	 |	This sets the properties so it can be restarted by VUE
	 |	only do one window 
	 */

	XSetCommand(XtDisplay(single_buffer), XtWindow(single_buffer), 
			argv_2, argc2);

	/* 
	 |	this makes a window manager (like mwm/vuewm save the buffers
	 |	on shutdown
	 */
	wm_saveself = XmInternAtom(XtDisplay(single_buffer),
				   "WM_SAVE_YOURSELF", TRUE);
	XmAddWMProtocols(single_buffer, &wm_saveself, 1);
	XmAddWMProtocolCallback(single_buffer, wm_saveself, save_and_tell, (XtPointer) NULL);

	wm_saveself = XmInternAtom(XtDisplay(single_buffer),
				   "WM_DELETE_WINDOW", TRUE);
	XmAddWMProtocols(single_buffer, &wm_saveself, 1);
	XmAddWMProtocolCallback(single_buffer, wm_saveself, quit, (XtPointer) NULL);

	if ((update_flag) && (!locked_down))
		check_buffer();

	signal(SIGINT, save_and_exit);
	signal(SIGABRT, save_and_exit);
	signal(SIGTERM, save_and_exit);

/*
 |	serious kludge time:
 |
 |	It seems the text edit widget will only display text put in it 
 |	*after* it has been realized, or some event occurs within the 
 |	widget, so the following code will set the text up now that the 
 |	widgets have been realized.  This should also be done after a 
 |	resize event.
 */
	for (counter = 0, temp = list_of_buffers; 
		counter < num_of_buffs; counter++, temp = temp->next)
	{
		XmTextSetString(temp->text_edit, temp->paste_buffer);
		changed_text = FALSE;
	}

	XmTextSetString(text_edit, curr_buffer->paste_buffer);
	changed_text = FALSE;

	/*
	 |	check if resize is desired, and if so, set it
	 */

	if (cutview_info.resize)
		resize_set("single");

	reset_paste_buffer = TRUE;

	XtAppSetErrorHandler(context_id, Fatal_error);

	XtAppMainLoop(context_id);
}

void 
time_callback(client_data, call_data)
XtPointer client_data;
XtIntervalId *call_data;
{
	if (*call_data != interval_id)
	{
		XtRemoveTimeOut(interval_id);
	}
	if (!update_flag)
		return;
	if (locked_down)
		return;
	check_buffer();
}

void 
menu_button(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	XButtonEvent *bevent;
	XmAnyCallbackStruct *cb;

	cb = (XmAnyCallbackStruct *) call_data;
	bevent = (XButtonEvent *) cb->event;

	XmMenuPosition(single_menu.menu, bevent);
	XtManageChild(single_menu.menu);
}


void
menu_event(widget, event, params, nparams)
Widget widget;
XEvent *event;
String *params;
Cardinal *nparams;
{

	if (widget == multi_buffer)
	{
		XmMenuPosition(multi_menu.menu, (XButtonEvent *) event);
		XtManageChild(multi_menu.menu);
	}
	else if (widget == single_buffer)
	{
		XmMenuPosition(single_menu.menu, (XButtonEvent *) event);
		XtManageChild(single_menu.menu);
	}
	return;
}

void 
delete_a_buffer(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	if (curr_buffer->locked || curr_buffer->editing || 
		(num_of_buffs == (num_of_locked_buffs + 1)) || locked_down)
		return;

	XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

	XtUnmanageChild(curr_buffer->select_button);
	XtUnmanageChild(curr_buffer->button);
	XtUnmanageChild(curr_buffer->text_edit);
	XtUnmanageChild(curr_buffer->form);

	tmp_buffer = curr_buffer->next;

	if (curr_buffer == list_of_buffers)
		list_of_buffers = tmp_buffer;

	delete_buffer(curr_buffer);
	curr_buffer = tmp_buffer;
	curr_buffer->access_stamp = global_counter++;
	num_of_buffs--;

	XmTextSetString(curr_buffer->text_edit, curr_buffer->paste_buffer);
	XmTextSetString(text_edit, curr_buffer->paste_buffer);

	if (update_flag)
	{
		XStoreBytes(disp_ptr, curr_buffer->paste_buffer, 
						curr_buffer->size_of_buff);
		XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);
		firstPosition(curr_buffer->text_edit);
	}

	changed_text = FALSE;
	XmToggleButtonSetState(lock_button, curr_buffer->locked, FALSE);

	XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);
}

void 
erase_a_buffer(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	if (curr_buffer->locked || curr_buffer->editing || locked_down)
		return;

	if (curr_buffer->paste_buffer != NULL)
		free(curr_buffer->paste_buffer);
	
	curr_buffer->paste_buffer = malloc(1);
	*curr_buffer->paste_buffer = (char)NULL;
	curr_buffer->size_of_buff = 0;

	XmTextSetString(curr_buffer->text_edit, curr_buffer->paste_buffer);
	XmTextSetString(text_edit, curr_buffer->paste_buffer);

	if (update_flag)
	{
		XStoreBytes(disp_ptr, curr_buffer->paste_buffer, 
						curr_buffer->size_of_buff);
/*		XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);*/
		firstPosition(curr_buffer->text_edit);
	}

	changed_text = FALSE;
}

void 
add_buffer(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	struct buffers *new_buffer;

	if (locked_down)
		return;

	if (garbage_list == NULL)
	{
		new_buffer = add_new_buffer(list_of_buffers);
		num_of_buffs++;
		buffer_widgets(new_buffer);
	}
	else
	{
		new_buffer = garbage_list;
		garbage_list = garbage_list->next;
		new_buffer->next = list_of_buffers;
		new_buffer->prev = list_of_buffers->prev;
		list_of_buffers->prev = new_buffer;
		new_buffer->prev->next = new_buffer;
		XtManageChild(new_buffer->form);
		XtManageChild(new_buffer->select_button);
		XtManageChild(new_buffer->button);
		XtManageChild(new_buffer->text_edit);
	}
}

void 
quit(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	save_buffers();
	exit(0);
}

void 
single_to_multi(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	if (toggle_windows)
	{
		single_buffer_mode = FALSE;
		XtUnmapWidget(single_buffer);
	}

	if (multi_buffer_mode)
	{
		wmhints.initial_state = NormalState;
		wmhints.flags = StateHint;
		XSetWMHints(XtDisplay(multi_buffer), XtWindow(multi_buffer), &wmhints);
	}

	multi_buffer_mode = TRUE;
	XMapWindow(XtDisplay(multi_buffer), XtWindow(multi_buffer));
	XRaiseWindow(XtDisplay(multi_buffer), XtWindow(multi_buffer));
}

void 
multi_to_single(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	multi_buffer_mode = FALSE;
	if (toggle_windows)
		XtMapWidget(single_buffer);

	XRaiseWindow(XtDisplay(single_buffer),XtWindow(single_buffer));

	XtUnmapWidget(multi_buffer);
	single_buffer_mode = TRUE;
}

int 
subset_check(string, length)
char *string;
int length;
{
	char *longer, *shorter, *tmp_longer, *tmp_shorter;
	int longer_len, shorter_len, longer_iter, shorter_iter, counter;
	int same = FALSE;

	/*
	 |	Check if the new string is a superset of the old string.
	 */

	if (length > curr_buffer->size_of_buff)
	{
		shorter = curr_buffer->paste_buffer;
		shorter_len = curr_buffer->size_of_buff;
		longer = string;
		longer_len = length;
	}
	else
	{
		longer = curr_buffer->paste_buffer;
		longer_len = curr_buffer->size_of_buff;
		shorter = string;
		shorter_len = length;
	}
	for (longer_iter = 0; 
		(((longer_len - longer_iter) >= (shorter_len)) && (!same)); 
			longer_iter++)
	{
		tmp_longer = longer + longer_iter;
		counter = longer_iter;
		tmp_shorter = shorter;
		for (shorter_iter = 0, same = TRUE; 
			(shorter_iter < shorter_len) && (same); 
				shorter_iter++, counter++)
		{
			if (*tmp_longer == *tmp_shorter)
			{
				tmp_longer++;
				tmp_shorter++;
			}
			else
				same = FALSE;
		}
	}

	if (same)
	{
		if (curr_buffer->paste_buffer != NULL)
			free(curr_buffer->paste_buffer);
		curr_buffer->paste_buffer = (char *) malloc(length + 1);
		memcpy(curr_buffer->paste_buffer, string, length);
		curr_buffer->paste_buffer[length] = (char ) NULL;
		curr_buffer->access_stamp = global_counter++;
		curr_buffer->size_of_buff = length;
		XmTextSetString(curr_buffer->text_edit, 
			curr_buffer->paste_buffer);
		XmTextSetString(text_edit, curr_buffer->paste_buffer);
		XStoreBytes(disp_ptr, 
				curr_buffer->paste_buffer, 
				curr_buffer->size_of_buff);
	}

	return(same);
}

/*
 |	Okay, we got the value of the selection. 
 */

void 
valueCB (w, client_data, selection, type, data, length, format)
Widget w;
XtPointer client_data;
Atom *selection;
Atom *type;
XtPointer data;
unsigned long  *length;
int *format;
{
	int bufferlen;
	time_t curr_time;
	char *selection_buffer_data;
	int   selection_buffer_len;

	selection_buffer_data = data;
	selection_buffer_len  = *length;

	if (selection_buffer_len > 0)
	{
	
		/*
		 |	Should check who selection owner is, if cutview, 
		 |	do nothing.
		 */

		curr_time = time(NULL);

		/*
		 |	Test for subset.  Some text widgets will grab the 
		 |	selection while the user is moving the cursor, not 
		 |	waiting for the end before doing so.  This causes 
		 |	cutview to fill multiple buffers with partial 
		 |	selections.  Check here to see if one string (the new 
		 |	selection or the value stored in the current buffer)
		 |	is a subset of the other.  (It is possible that the 
		 |	new string is the subset, if the user is shortening 
		 |	the selection.)  If one is a subset, substitute the 
		 |	value of the current buffer rather than search for 
		 |	another buffer.
		 |
		 |	To help the code determine that the new string could 
		 |	be a result of a selection in progress, check the 
		 |	time.  Since the timer interval is configurable, 
		 |	check if the time was within a short period of time.
		 |	For values of the timer greater than 15, make sure it 
		 |	was the last time that the selection was checked.
		 */

		if ( (subset_check_flag) && (((timer > 15) && 
		  ((curr_time - curr_buffer->last_accessed) < (2 * timer))) || 
		     ((curr_time - curr_buffer->last_accessed) < (timer + 15)))
		       && (selection_buffer_len != curr_buffer->size_of_buff) )
		{
			if (subset_check(selection_buffer_data, selection_buffer_len))
			{
				curr_buffer->last_accessed = curr_time;
				return;
			}
		}

		if (diff_buffers(selection_buffer_len, selection_buffer_data))
		{
			XStoreBytes(disp_ptr, 
				curr_buffer->paste_buffer, 
				curr_buffer->size_of_buff);

			curr_buffer->last_accessed = curr_time;

			/*
			 |	Since the cut buffer was just set, no sense 
			 |	in checking it, so return.
			 */
			return;
		}
	}

	paste_buffer = NULL;
	paste_buffer = XFetchBytes(disp_ptr, &bufferlen);
	if (diff_buffers(bufferlen, paste_buffer))
	{
		XmTextSetSelection(curr_buffer->text_edit, 0, 
			curr_buffer->size_of_buff, 0);
		firstPosition(curr_buffer->text_edit);
		curr_buffer->last_accessed = curr_time;
	};
	return;
} 


void 
check_buffer()
{
	XtGetSelectionValue(single_buffer, XA_PRIMARY, XA_STRING, valueCB,
				    NULL, CurrentTime);

	interval_id = XtAppAddTimeOut(context_id, 
				(timer * 500), time_callback, NULL);
}

int
diff_buffers(bufferlen, paste_buffer)
int bufferlen;
char *paste_buffer;
{
	int buff_saved;
	int counter;
	struct buffers *lru, *temp;

	new_info = FALSE;

	if ((bufferlen != curr_buffer->size_of_buff) || 
	    ((bufferlen > 0) && (paste_buffer != NULL) && 
	    (memcmp(paste_buffer, curr_buffer->paste_buffer, curr_buffer->size_of_buff))))
	{
		buff_saved = FALSE;
		new_info = TRUE;
		curr_buffer->curr_buff = FALSE;

		XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

/*
 |	pass one, check for a buffer with the same 
 |	contents as the new data
 */

		counter = 0;
		temp = curr_buffer;
		do 
		{
			if ((temp->size_of_buff == bufferlen) && 
			(!memcmp(paste_buffer, temp->paste_buffer, temp->size_of_buff)))
			{
				temp->curr_buff = TRUE;
				temp->access_stamp = global_counter++;
				buff_saved = TRUE;
				curr_buffer = temp;
			}
			else
				temp = temp->next;
			counter++;
		}
		while ((counter < num_of_buffs) && (!buff_saved));

/*
 |	o.k., no buffers with the same contents, so find the next
 |	empty or unlocked buffer
 */

		if (!buff_saved)
		{
/*
 |	pass two, look for a buffer with no data
 */
			counter = 0;
			temp = curr_buffer;
			do 
			{
				if ((temp->size_of_buff == 0) && (temp->locked == FALSE) && (temp->editing == FALSE))
				{
					curr_buffer = temp;
					buff_saved = TRUE;
				}
				else
					temp = temp->next;
				counter++;
			}
			while ((counter < num_of_buffs) && (!buff_saved));

/*
 |	pass three, if no empty buffer found, find least recently used, 
 |	unlocked buffer
 */

			if (!buff_saved)
			{
/*
 |	find first unlocked buffer after current buffer
 */
				lru = curr_buffer;
				for (counter = 0; 
				  ((counter < num_of_buffs) && (lru->locked)); 
				      counter++)
				{
					lru = lru->next;
				}
				counter = 0;
				temp = lru->next;
				do 
				{
					if ((temp->locked == FALSE) && (temp->editing == FALSE) && (temp->access_stamp < lru->access_stamp))
						lru = temp;
					temp = temp->next;
					counter++;
				}
				while (counter < num_of_buffs);

				if ((lru->locked) && 
				(num_of_locked_buffs == (num_of_buffs - 1)) && 
				(edit_in_progress) && (!e_buffer->locked))
					lru = e_buffer;

				curr_buffer = lru;
			}

			if (!curr_buffer->locked)
			{
				curr_buffer->curr_buff = TRUE;
				if (curr_buffer->paste_buffer != NULL)
					free(curr_buffer->paste_buffer);
				curr_buffer->paste_buffer = (char *) malloc(bufferlen + 1);
				memcpy(curr_buffer->paste_buffer, paste_buffer, bufferlen);
				curr_buffer->paste_buffer[bufferlen] = (char ) NULL;
				curr_buffer->access_stamp = global_counter++;
				curr_buffer->size_of_buff = bufferlen;
			}
			else
				curr_buffer->curr_buff = FALSE;
		}
	}

	if (paste_buffer != NULL)
		free(paste_buffer);

	if (new_info)
	{
		XmTextClearSelection(curr_buffer->text_edit, 0);
		just_updated = TRUE;
		XmTextSetString(curr_buffer->text_edit, curr_buffer->paste_buffer);
		changed_text = FALSE;
		XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);

		just_updated = TRUE;
		XmTextSetString(text_edit, curr_buffer->paste_buffer);
		XmToggleButtonSetState(lock_button, curr_buffer->locked, FALSE);
		just_updated = TRUE;
		changed_text = FALSE;
	}

	return(new_info);
}

void 
delete_buffer(buffer_to_delete)
struct buffers *buffer_to_delete;
{
	if (buffer_to_delete->paste_buffer != NULL)
		free(buffer_to_delete->paste_buffer);
	buffer_to_delete->prev->next = buffer_to_delete->next;
	buffer_to_delete->next->prev = buffer_to_delete->prev;
/*	free(buffer_to_delete);
*/
	buffer_to_delete->paste_buffer = (char *)malloc(1);
	buffer_to_delete->paste_buffer[0] = (char ) NULL;
	buffer_to_delete->size_of_buff = 0;
	buffer_to_delete->editing = FALSE;
	buffer_to_delete->locked = FALSE;
	buffer_to_delete->curr_buff = FALSE;
	buffer_to_delete->access_stamp = 0;
	buffer_to_delete = garbage_list;
	garbage_list = buffer_to_delete;
}

void 
clear_child(arg)
int arg;
{
	int value;

	value = wait(0);
	if ((value == child_num) && (edit_in_progress))
	{
		edit_in_progress = FALSE;
		e_buffer->editing = FALSE;

		XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

		curr_buffer->curr_buff = FALSE;
		if (changed_text)
			check_for_changes(e_buffer->text_edit);
		curr_buffer = e_buffer;
		curr_buffer->curr_buff = TRUE;
		curr_buffer->access_stamp = global_counter++;
		child_num = 0;
		read_file();

		XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);
		if (locked_down)
			set_buffers();

	}
	else if (value == print_child_num)
	{
		print_child_num = 0;
		unlink(print_file_name);
	}
}

void 
edit_buffer(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int counter;
	int length_left;
	int length;
	int file_des;
	char temp_string[512];

	signal(SIGCLD, clear_child);
	edit_in_progress = TRUE;
	e_buffer = curr_buffer;
	e_buffer->editing = TRUE;
	sprintf(edit_file_name, "/tmp/E%d", getpid());
	child_num = fork();
	if (!child_num)
	{
		file_des = open(edit_file_name, (O_WRONLY | O_CREAT), 0700);
		length_left = curr_buffer->size_of_buff;
		counter = 0;
		while (length_left > 0)
		{
			if (length_left > 1024)
				length = 1024;
			else
				length = length_left;

			write(file_des, &curr_buffer->paste_buffer[counter], length);
			counter += length;
			length_left -= length;
		}
		sprintf(temp_string, edit_command, edit_file_name);
		close(file_des);
		system(temp_string);
		exit(0);
	}
}

void 
read_file()
{
	int file_des;
	int counter;
	int length;
	int length_left;
	struct stat file_status;

	if (stat(edit_file_name, & file_status) != -1)
	{
		if (file_status.st_size > curr_buffer->size_of_buff)
		{
			if (curr_buffer->paste_buffer != NULL)
				free(curr_buffer->paste_buffer);
			curr_buffer->paste_buffer = (char *) malloc(file_status.st_size + 1);
		}
		curr_buffer->size_of_buff = file_status.st_size;
		file_des = open(edit_file_name, O_RDONLY);
		length_left = file_status.st_size;
		counter = 0;
		while (length_left > 0)
		{
			if (length_left > 1024)
				length = 1024;
			else
				length = length_left;

			read(file_des, &curr_buffer->paste_buffer[counter], length);
			counter += length;
			length_left -= length;
		}
		close(file_des);
		unlink(edit_file_name);
		curr_buffer->access_stamp = global_counter++;
		curr_buffer->paste_buffer[curr_buffer->size_of_buff] = (char) NULL;
		XmTextSetString(curr_buffer->text_edit, 
						curr_buffer->paste_buffer);
		XmTextSetString(text_edit, curr_buffer->paste_buffer);
		changed_text = FALSE;
		if (update_flag)
		{
			XStoreBytes(disp_ptr, curr_buffer->paste_buffer, curr_buffer->size_of_buff);
			XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);
			firstPosition(curr_buffer->text_edit);
		}
		if (curr_buffer->locked)
			save_buffers();
	}
}

void 
print_buffer(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int counter;
	int length_left;
	int length;
	int file_des;
	char temp_string[512];

	signal(SIGCLD, clear_child);
	print_child_num = fork();
	if (!print_child_num)
	{
		sprintf(print_file_name, "/tmp/P%d", getpid());
		file_des = open(print_file_name, (O_WRONLY | O_CREAT), 0700);
		length_left = curr_buffer->size_of_buff;
		counter = 0;
		while (length_left > 0)
		{
			if (length_left > 1024)
				length = 1024;
			else
				length = length_left;

			write(file_des, &curr_buffer->paste_buffer[counter], length);
			counter += length;
			length_left -= length;
		}
		if (curr_buffer->paste_buffer[counter - 1] != '\n')
			write(file_des, "\n", 1);
		sprintf(temp_string, print_command, print_file_name);
		close(file_des);
		system(temp_string);
		exit(0);
	}
	sprintf(print_file_name, "/tmp/P%d", print_child_num);
}

/*
 |	read_buffers will read the contents of the file specified by
 |	buffers_file, overwriting anything currently in the buffers.  
 |	If necessary, more buffers will be added to allow all of the 
 |	buffers in the file to be read.  After the buffers have been 
 |	read from the file, the number of locked buffers is counted
 |	(since it is possible that there were fewer buffers read than
 |	are used in cutview), then the number of buffers (num_of_buffs)
 |	is checked to make sure it is larger than the number of locked 
 |	buffers (num_of_locked_buffs).
 |
 |	Although read_buffers is currently used only at startup, it could 
 |	be used at any time if provision were made to allow for the user 
 |	to invoke it.
 */

void 
read_buffers()
{
	int file_des;
	int counter;
	int length;
	int length_left;
	int buffer_count;
	struct stat file_status;
	char tmp;
	struct buffers *check_locked;

	if (stat(buffers_file, &file_status) != -1)
	{
		file_des = open(buffers_file, O_RDONLY);
/*
 |	read the number of buffers
 */
		buffer_count = get_num(file_des);
		while (buffer_count > num_of_buffs)
		{
			add_new_buffer(list_of_buffers);
			num_of_buffs++;
		}
		curr_buffer = list_of_buffers->prev;
		while (buffer_count > 0)
		{
			curr_buffer = curr_buffer->next;
			curr_buffer->access_stamp = global_counter++;
/*
 |	check whether the buffer to be read is locked or not
 */
			length = read(file_des, &tmp, 1);
			if (length < 1)
				return;
			else if (tmp == 'l')
				curr_buffer->locked = TRUE;
			else if (tmp == 'u')
				curr_buffer->locked = FALSE;
			else
				return;
/*
 |	get the size of the buffer to be read
 */
			length_left = get_num(file_des);
			if ((curr_buffer->paste_buffer != NULL) && (length_left > (curr_buffer->size_of_buff + 1)))
			{
				free(curr_buffer->paste_buffer);
				curr_buffer->paste_buffer = NULL;
			}
			if (curr_buffer->paste_buffer == NULL)
				curr_buffer->paste_buffer = (char *) malloc(length_left + 1);
/*
 |	read the buffer
 */
			curr_buffer->size_of_buff = length_left;
			counter = 0;
			while (length_left > 0)
			{
				if (length_left > 1024)
					length = 1024;
				else
					length = length_left;
	
				read(file_des, &curr_buffer->paste_buffer[counter], length);
				counter += length;
				length_left -= length;
			}
			curr_buffer->paste_buffer[curr_buffer->size_of_buff] = (char) NULL;
			buffer_count--;
			length = read(file_des, &tmp, 1);
		}
		close(file_des);

/*
 |	check the number of locked buffers
 */

		num_of_locked_buffs = 0;
		check_locked = list_of_buffers;
		for (counter = 0; counter < num_of_buffs; counter++)
		{
			if (check_locked->locked)
				num_of_locked_buffs++;
			check_locked = check_locked->next;
		}
/*
 |	make sure there is at least one unlocked buffer
 */
		if (num_of_buffs == num_of_locked_buffs)
		{
			add_new_buffer(list_of_buffers);
			num_of_buffs++;
		}
	}
	curr_buffer->curr_buff = TRUE;
}

/*
 |	Check to see if the buffers file exists.  If it does, but is not 
 |	writable, set locked_down to true.
 */

void 
inspect_buff_file()
{
	int file_des;
	struct stat file_status;

	if (stat(buffers_file, &file_status) != -1)
	{
		if (file_status.st_size > 0)
		{
			file_des = open(buffers_file, O_RDWR);
			if ((file_des == -1) && (errno == EACCES))
				locked_down = TRUE;
			else
				close(file_des);
		}
	}
}

/*
 |	read the buffers file and set the values accordingly
 */

void 
set_buffers()
{
	int counter;
	struct buffers *temp;

	setting_buffers = TRUE;

	read_buffers();

	changed_text = FALSE;

	for (counter = 0, temp = list_of_buffers; 
		counter < num_of_buffs; counter++, temp = temp->next)
	{
		XmTextSetString(temp->text_edit, temp->paste_buffer);
		XmToggleButtonSetState(temp->button, temp->locked, FALSE);
	}

	XmTextSetString(text_edit, curr_buffer->paste_buffer);
	XmToggleButtonSetState(lock_button, curr_buffer->locked, FALSE);

	setting_buffers = FALSE;
}

int 
get_num(file_des)
int file_des;
{
	int accum;
	int length;
	char tmp;

	accum = 0;

	while (((length = read(file_des, &tmp, 1)) > 0) && (tmp != '\n'))
	{
		if ((tmp >= '0') && (tmp <= '9'))
			accum = (accum * 10) + tmp - '0';
		else
		{
			return(-1);
		}
	}
	return(accum);
}

/*
 |	save the contents of the buffers to a file
 */

void 
save_buffers()
{
	int counter;
	int buff_count;
	int length_left;
	int length;
	int file_des;
	char temp_string[512];
	struct buffers *temp;
	struct stat file_status;

	if (locked_down)
		return;

	if (stat(buffers_file, &file_status) != -1)
	{
		sprintf(temp_string, "%s.old", buffers_file);
		unlink(temp_string);
		link(buffers_file, temp_string);
		unlink(buffers_file);
	}
	if ((file_des = open(buffers_file, (O_WRONLY | O_CREAT | O_TRUNC), 0700)) == -1)
		return;
	sprintf(temp_string, "%d\n", num_of_buffs);
	write(file_des, temp_string, strlen(temp_string));
	temp = list_of_buffers;
	buff_count = num_of_buffs;
	while (buff_count > 0)
	{
		sprintf(temp_string, "%c%d\n", temp->locked ? 'l' : 'u', 
			temp->size_of_buff);
		write(file_des, temp_string, strlen(temp_string));
		length_left = temp->size_of_buff;
		counter = 0;
		while (length_left > 0)
		{
			if (length_left > 1024)
				length = 1024;
			else
				length = length_left;
	
			write(file_des, &temp->paste_buffer[counter], length);
			counter += length;
			length_left -= length;
		}
		write(file_des, "\n", 1);
		temp = temp->next;
		buff_count--;
	}
	close(file_des);
}

void 
toggle_update_callback(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int counter;
	Arg arglist[32];

	update_flag = !update_flag;
	counter = 0;
	XtSetArg(arglist[counter], XmNlabelString, (String) update_options[(int) update_flag]);
	counter++;
	XtSetValues(single_menu.buttons[9], arglist, counter);
	XtSetValues(multi_menu.buttons[9], arglist, counter);

	if (update_flag)
		check_buffer();
}

void 
toggle_subset_callback(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	int counter;
	Arg arglist[32];

	subset_check_flag = !subset_check_flag;
	counter = 0;
	XtSetArg(arglist[counter], XmNlabelString, (String) subset_chk_opts[ (int) subset_check_flag]);
	counter++;
	XtSetValues(single_menu.buttons[10], arglist, counter);
	XtSetValues(multi_menu.buttons[10], arglist, counter);

	if (update_flag)
		check_buffer();
}

void 
resize_set(which)
String which;
{
	int counter;
	Arg arglist[32];
	struct buffers *temp;

	counter = 0;
	if (!strcmp(which, "single"))
	{
		single_resize_flag = !single_resize_flag;

		XtSetArg(arglist[counter], XmNlabelString, (String) resize_options[(int) single_resize_flag]);
		XtSetValues(single_menu.buttons[resize_index], arglist, 1);

		XtSetArg(arglist[counter], XmNresizeHeight, single_resize_flag);
		counter++;
		XtSetArg(arglist[counter], XmNresizeWidth, single_resize_flag);
		counter++;
		XtSetValues(single_form, arglist, counter);
		XtSetValues(text_edit, arglist, counter);
	}
	else
	{
		multi_resize_flag = !multi_resize_flag;

		XtSetArg(arglist[counter], XmNlabelString, resize_options[(int) multi_resize_flag]);
		XtSetValues(multi_menu.buttons[resize_index], arglist, 1);

		XtSetArg(arglist[counter], XmNresizeHeight, multi_resize_flag);
		counter++;
		XtSetArg(arglist[counter], XmNresizeWidth, multi_resize_flag);
		counter++;
		for (counter = 0, temp = list_of_buffers; 
				counter < num_of_buffs; counter++)
		{
			XtSetValues(temp->text_edit, arglist, counter);
			XtSetValues(temp->form, arglist, counter);
			temp = temp->next;
		}
	}
}

void 
toggle_resize(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	resize_set((String)client_data);
}

void 
up_button(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

	if (changed_text)
	{
		free(curr_buffer->paste_buffer);
		curr_buffer->paste_buffer = XmTextGetString(text_edit);
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		XmTextSetString(curr_buffer->text_edit, 
						curr_buffer->paste_buffer);
		changed_text = FALSE;
	}

	curr_buffer = curr_buffer->prev;
	curr_buffer->access_stamp = global_counter++;

	XmTextSetString(text_edit, curr_buffer->paste_buffer);
	changed_text = FALSE;

	if (update_flag)
	{
		XStoreBytes(disp_ptr, curr_buffer->paste_buffer, curr_buffer->size_of_buff);
		XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);
		firstPosition(curr_buffer->text_edit);
	}
	XmToggleButtonSetState(lock_button, curr_buffer->locked, FALSE);

	XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);
}

void 
down_button(widg, client_data, call_data)
Widget widg;
XtPointer client_data;
XtPointer call_data;
{
	XmToggleButtonSetState(curr_buffer->select_button, FALSE, FALSE);

	if (changed_text)
	{
		free(curr_buffer->paste_buffer);
		curr_buffer->paste_buffer = XmTextGetString(text_edit);
		curr_buffer->size_of_buff = strlen(curr_buffer->paste_buffer);
		XmTextSetString(curr_buffer->text_edit, 
						curr_buffer->paste_buffer);
		changed_text = FALSE;
	}

	curr_buffer = curr_buffer->next;
	curr_buffer->access_stamp = global_counter++;

	XmTextSetString(text_edit, curr_buffer->paste_buffer);
	changed_text = FALSE;

	if (update_flag)
	{
		XStoreBytes(disp_ptr, curr_buffer->paste_buffer, curr_buffer->size_of_buff);
		XmTextSetSelection(curr_buffer->text_edit, 0, curr_buffer->size_of_buff, 0);
		firstPosition(curr_buffer->text_edit);
	}
	XmToggleButtonSetState(lock_button, curr_buffer->locked, FALSE);

	XmToggleButtonSetState(curr_buffer->select_button, TRUE, FALSE);
}

void 
create_menu(parent, menu, type)
Widget parent;		/* the parent widget		*/
struct menus *menu;	/* the data for the menu 	*/
int type;		/* 0 = single, 1 = multi	*/
{
	int counter;
	Arg arglist[32];
	XmString string;
	int n = 0;

	XtSetArg(arglist[0], XmNmenuAccelerator, "Ctrl <Key> m");
	menu->menu = XmCreatePopupMenu(parent, "cutview menu", arglist, 1);

	string = XmStringCreateLtoR("cutview", XmSTRING_DEFAULT_CHARSET);

	counter = 0;
	XtSetArg(arglist[counter], XmNlabelString, string);
	counter++;
	menu->buttons[n] = XmCreateLabelGadget(menu->menu, "label", 
							arglist, counter);
	XmStringFree(string);

	n++;
	menu->buttons[n] = XmCreateSeparatorGadget(menu->menu, "separator", NULL, 0);

	n++;
	if (type == 0)
	{
		menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Multi buffer", NULL, 0);
		XtAddCallback(menu->buttons[n], XmNactivateCallback, single_to_multi, "toggle");
	}
	else
	{
		menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Single buffer", NULL, 0);
		XtAddCallback(menu->buttons[n], XmNactivateCallback, multi_to_single, "toggle");
	}
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Add buffer", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, add_buffer, "add");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Delete buffer", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, delete_a_buffer, "delete");
	n++;

	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Edit buffer", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, edit_buffer, "edit");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Erase buffer", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, erase_a_buffer, "erase");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Print buffer", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, print_buffer, "print");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Save buffers", NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, save_the_buffers, "save");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, update_strings[(int) update_flag], NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, toggle_update_callback, "update");
	n++;
	menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, subset_chk_strs[(int) subset_check_flag], NULL, 0);
	XtAddCallback(menu->buttons[n], XmNactivateCallback, toggle_subset_callback, "subset");
	n++;

	/*
	 |	In Motif 1.1 on HP-UX 8.0x, dynamically changing resize on the 
	 |	multi buffer view will cause a core dump.  So don't allow the 
	 |	user to do this (although the code in toggle_resize() already 
	 |	allows this).
	 */

	if (type == 1)	/* multi buffer */
	{
		menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Quit", NULL, 0);
	}
	else
	{
		menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, resize_strings[(int) single_resize_flag], NULL, 0);
		XtAddCallback(menu->buttons[n], XmNactivateCallback, toggle_resize, "single");
		resize_index = n;
		n++;
		menu->buttons[n] = XmCreatePushButtonGadget(menu->menu, "Quit", NULL, 0);
	}
	XtAddCallback(menu->buttons[n], XmNactivateCallback, quit, "quit");
	XtManageChildren(menu->buttons, (n + 1));
}

void 
set_up_single(argc, argv)
int argc;
char *argv[];
{
	int counter;
	Dimension width, temp, height;
	Arg arglist[32];
	Pixel foreground, background;

	counter = 0;
	XtSetArg(arglist[counter], XmNorientation, XmHORIZONTAL);
	counter++;
	XtSetArg(arglist[counter], XmNancestorSensitive, True);
	counter++;
	XtSetArg(arglist[counter], XmNsensitive, True);
	counter++;
	XtSetArg(arglist[counter], XmNallowOverlap, False);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;
	single_form = XmCreateForm(single_buffer, "singleForm", arglist, counter);
	XtManageChild(single_form);

/*
 |	set up menu for single buffer (same code as for multi_buffer)
 */

	create_menu(single_buffer, &single_menu, 0);

/*
 |	set up menu button
 */

	counter = 0;
	XtSetArg(arglist[counter], XmNforeground, &foreground);
	counter++;
	XtSetArg(arglist[counter], XmNbackground, &background);
	counter++;
	XtGetValues(single_form, arglist, counter);

	counter = 0;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_FORM);
	counter++;

	if (single_menu_flag)
	{
		XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
		counter++;
		XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
		counter++;
		XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
		counter++;

		menu_pix = XmGetPixmap(XtScreen(single_form), "menu", foreground, background);
	
		XtSetArg(arglist[counter], XmNlabelType, XmPIXMAP);
		counter++;
		XtSetArg(arglist[counter], XmNlabelPixmap, menu_pix);
		counter++;
		XtSetArg(arglist[counter], XmNskipAdjust, False);
		counter++;

		single_menu_button = XmCreatePushButton(
				single_form, "menuButton", arglist, counter);

		XtManageChild(single_menu_button);
		XtSetSensitive(single_menu_button, True);

		XtAddCallback(single_menu_button, XmNactivateCallback, 
						menu_button, NULL);

		counter = 0;
		XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
		counter++;
	}


/*
 |	set up arrow buttons
 */

	XtSetArg(arglist[counter], XmNarrowDirection, XmARROW_UP);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, single_menu_button);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	arrow_buttons[0] = XmCreateArrowButton(
			single_form, "upButton", arglist, counter);

	XtManageChild(arrow_buttons[0]);
	XtSetSensitive(arrow_buttons[0], True);

	XtAddCallback(arrow_buttons[0], XmNactivateCallback, up_button, "up");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &temp);
	counter++;
	XtGetValues(arrow_buttons[0], arglist, counter);

	width = temp;

	counter = 0;
	XtSetArg(arglist[counter], XmNarrowDirection, XmARROW_DOWN);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, arrow_buttons[0]);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	arrow_buttons[1] = XmCreateArrowButton(
			single_form, "downButton", arglist, counter);

	XtManageChild(arrow_buttons[1]);
	XtSetSensitive(arrow_buttons[1], True);

	XtAddCallback(arrow_buttons[1], XmNactivateCallback, down_button, "down");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &temp);
	counter++;
	XtGetValues(arrow_buttons[1], arglist, counter);

	width += temp;

/*
 |	set up lock button
 */

	counter = 0;
	XtSetArg(arglist[counter], XmNforeground, &foreground);
	counter++;
	XtSetArg(arglist[counter], XmNbackground, &background);
	counter++;
	XtGetValues(single_form, arglist, counter);

	locked[0] = XmGetPixmap(XtScreen(single_form), "key", foreground, background);
	locked[1] = XmGetPixmap(XtScreen(single_form), "padlock", foreground, background);

	counter = 0;
	XtSetArg(arglist[counter], XmNlabelType, XmPIXMAP);
	counter++;
	XtSetArg(arglist[counter], XmNselectPixmap, locked[1]);
	counter++;
	XtSetArg(arglist[counter], XmNselectInsensitivePixmap, locked[1]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelPixmap, locked[0]);
	counter++;
	XtSetArg(arglist[counter], XmNlabelInsensitivePixmap, locked[0]);
	counter++;
	XtSetArg(arglist[counter], XmNset, curr_buffer->locked);
	counter++;
	XtSetArg(arglist[counter], XmNindicatorOn, False);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, arrow_buttons[1]);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_NONE);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	lock_button = XmCreateToggleButton(
			single_form, "lockButton", arglist, counter);

	XtManageChild(lock_button);
	XtSetSensitive(lock_button, True);

	XtAddCallback(lock_button, XmNvalueChangedCallback, lock_callback, "lockbutton");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &temp);
	counter++;
	XtGetValues(lock_button, arglist, counter);

	width += temp;

	counter = 0;
	if (single_height > 0)
	{
		XtSetArg(arglist[counter], XmNrows, single_height);
		counter++;
	}
	if (single_width > 0)
	{
		XtSetArg(arglist[counter], XmNcolumns, single_width);
		counter++;
	}
	XtSetArg(arglist[counter], XmNscrollVertical, False);
	counter++;
	XtSetArg(arglist[counter], XmNscrollHorizontal, False);
	counter++;
	XtSetArg(arglist[counter], XmNeditMode, XmMULTI_LINE_EDIT);
	counter++;
	XtSetArg(arglist[counter], XmNrightAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNbottomAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNtopAttachment, XmATTACH_FORM);
	counter++;
	XtSetArg(arglist[counter], XmNleftAttachment, XmATTACH_WIDGET);
	counter++;
	XtSetArg(arglist[counter], XmNleftWidget, lock_button);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, False);
	counter++;

	text_edit = XmCreateText(single_form, "textEdit", arglist, counter);

	XtManageChild(text_edit);

	XtSetSensitive(text_edit, True);

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, &temp);
	counter++;
	XtSetArg(arglist[counter], XmNheight, &height);
	counter++;
	XtGetValues(text_edit, arglist, counter);

	width += temp;

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, width);
	counter++;
	XtSetArg(arglist[counter], XmNheight, height);
	counter++;
	XtSetValues(single_form, arglist, counter);

	XmTextSetString(text_edit, curr_buffer->paste_buffer);
	changed_text = FALSE;

	XtAddCallback(text_edit, XmNvalueChangedCallback, 
		text_changed_callback, "changed");

	XtAddCallback(text_edit, XmNlosingFocusCallback, 
		text_changed_callback, "focus_lost");

	counter = 0;
	XtSetArg(arglist[counter], XmNwidth, width);
	counter++;
	XtSetArg(arglist[counter], XmNheight, height);
	counter++;
	XtSetValues(single_buffer, arglist, counter);


}

void 
set_up_multi(argc, argv)
int argc;
char *argv[];
{
	int counter;
	Arg arglist[32];
	struct buffers *temp;

	counter = 0;
	XtSetArg(arglist[counter], XmNsashHeight, 5);
	counter++;
	XtSetArg(arglist[counter], XmNmarginHeight, 1);
	counter++;
	XtSetArg(arglist[counter], XmNspacing, 1);
	counter++;
	XtSetArg(arglist[counter], XmNallowResize, True);
	counter++;
	XtSetArg(arglist[counter], XmNskipAdjust, True);
	counter++;
	pane = XmCreatePanedWindow(multi_buffer, "pane", arglist, counter);

	XtManageChild(pane);

	create_menu(multi_buffer, &multi_menu, 1);

	for (counter = 0, temp = list_of_buffers; 
				counter < num_of_buffs; counter++)
	{
		buffer_widgets(temp);
		temp = temp->next;
	}

	buffer_height += 2; /* for the sash height */
	buffer_height = counter * buffer_height;
	buffer_width = buffer_width;
}



