#!/bin/sh

#
#	This script will determine the appropriate values for building 
#	cutview on the system and generate a makefile (make.local).
#
# $Header: /home/hugh/sources/cview/RCS/create.make,v 1.1 1998/08/14 15:27:18 hugh Exp $
#

other_cflags=""

# if HP-UX, add other CFLAGS

if [ "`uname`" = "HP-UX" ]
then
	other_cflags="$other_cflags -Wa,-Ns10000 -Aa -D_HPUX_SOURCE"
fi


# check if this is a SunOS system

if [ -d /usr/5include ]
then
	five_include="-I/usr/5include"
else
	five_include=""
fi

if [ -d /usr/5lib ]
then
	five_lib="-L/usr/5lib"
else
	five_lib=""
fi


# check location of X11 headers

X_headers=""

if [ -d /usr/include/X11R5 ]
then
	X_headers="-I/usr/include/X11R5"
fi

if [ -d /usr/include/X11R6 ]
then
	X_headers="-I/usr/include/X11R6"
fi

if [ -d /usr/X11R6/include ]
then
	X_headers="-I/usr/X11R6/include"
fi

if [ -d /usr/openwin/include ]
then
	X_headers="${X_headers} -I/usr/openwin/include"
fi

if [ -d /usr/include/Motif1.2_R6 ]
then
	X_headers="${X_headers} -I/usr/include/Motif1.2_R6"
fi

if [ -d /usr/include/Motif1.2 ]
then
	X_headers="${X_headers} -I/usr/include/Motif1.2"
fi

if [ -d /usr/include/Xm ]
then
	X_headers="${X_headers} -I/usr/include/Xm"
fi

# check location of X11 libraries

X_libpath=""

if [ -d /usr/lib/X11R5 ]
then
	X_libpath="-L/usr/lib/X11R5"
fi

if [ -d /usr/lib/X11R6 ]
then
	X_libpath="-L/usr/lib/X11R6"
fi

if [ -d /usr/X11R6/lib ]
then
	X_libpath="${X_libpath} -L/usr/X11R6/lib"
fi

if [ -d /usr/openwin/lib ]
then
	X_libpath="${X_libpath} -L/usr/openwin/lib"
fi

if [ -d /usr/lib/Motif1.2_R6 ]
then
	X_libpath="${X_libpath} -L/usr/lib/Motif1.2_R6"
fi

if [ -d /usr/lib/Motif1.2 ]
then
	X_libpath="${X_libpath} -L/usr/lib/Motif1.2"
fi

lib_path="`echo $X_libpath | sed -e 's/-L//g'`"

# Check if libXpm.* exists, and if so include it in the libraries to be 
# linked with

xpm=""
string=""

for i in $lib_path
do
	string="`ls $i/libXpm.* 2> /dev/null`"
	if [ "$?" -eq 0 ]
	then
		xpm="-lXpm"
	fi
done

if [ -n "$xpm" ]
then
	X_libs="-lXm -lXt -lXpm -lXext -lX11"
else
	X_libs="-lXm -lXt -lXext -lX11"
fi

if [ -n "$CFLAGS" ]
then
	if [ -z "`echo $CFLAGS | grep '[-]g'`" ]
	then
		other_cflags="${CFLAGS} -O -s"
	else
		other_cflags="${CFLAGS}"
	fi
else
	other_cflags="-O -s"
fi

# time to write the makefile

echo "Generating make.local"

if [ -f make.local ]
then
	mv make.local make.lcl.old
fi

echo "SRCS =		cutview.c" >> make.local
echo "PROGNAME =	cutview" >> make.local
echo "" >> make.local

echo "INCLUDE_PATH =	$five_include $X_headers ">> make.local
echo "LIB_PATH =	$X_libpath $five_lib " >> make.local
echo "LIBS =	$X_libs " >> make.local
echo "CFLAGS =	$other_cflags" >> make.local
echo "" >> make.local
echo "" >> make.local
echo "all :	$TARGET" >> make.local

cat  >> make.local << EOF

OBJS =		\$(SRCS:.c=.o)

.c.o:
	\$(CC) \$(CFLAGS) \$(INCLUDE_PATH) -c \$<

all:	cutview

\$(PROGNAME):	\$(OBJS)
	\$(CC) \$(CFLAGS) -o \$(PROGNAME) \$(INCLUDE_PATH) \$(LIB_PATH) \$(OBJS) \$(LIBS) 

depend:
	makedepend \$(SRCS)

# DO NOT DELETE THIS LINE

cutview.o: cutview.c
# DEPENDENCIES MUST END AT END OF FILE
# IF YOU PUT STUFF HERE IT WILL GO AWAY
# see make depend above

EOF

if [ -f make.lcl.old ]
then
	diffs="`cmp make.lcl.old make.local`"
	if [ -n "${diffs}" ]
	then
		rm -f cutview.o cutview
	fi
	rm -f make.lcl.old
fi

