/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 * main.c: Main program entry point
 */

#include "config.h"

#include <stdio.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include <magick/api.h>
#include <gdk_magick.h>

#include "common.h"
#include "panel.h"
#include "capture.h"
#include "options.h"
#include "save.h"
#include "stringtable.h"
#include "version.h"
#include "main.h"

/*********************************************************************
 *
 * print_usage: Echo brief command-line usage information to stderr
 * and exit the program with error code 1.
 *
 * Parameters:
 *   command - name of command as entered on the command line
 *
 * Return value:
 *   None.
 */

void print_usage (char *command)
{
    fprintf (stderr, "Usage: %s [--version]\n", command);
    exit (1);
}

/*********************************************************************
 *
 * print_version: Echo program version and copyright information to
 * stdout and exit the program.
 *
 * Parameters:
 *   None.
 *
 * Return value:
 *   None.
 */

void print_version ()
{
    printf (VERSION_TEXT);
    printf ("\n");
    exit (0);
}

/*********************************************************************
 *
 * MAIN FUNCTION
 */

int main (int argc, char *argv[], char *envp [])
{
    /* Process command-line arguments. */

    if (argc > 2)
    {
        print_usage (argv [0]);
    }

    if (argc == 2)
    {
        if (!strcmp (argv [1], "--version"))
        {
            print_version ();
        }
        else
        {
            print_usage (argv [0]);
        }
    }
    
    /* Call all toolkit initialization routines. */

    gdk_init (&argc, &argv);
    gtk_init (&argc, &argv);
    gdk_magick_init (&argc, &argv);
    
    /* Initialize capture functionality. */

    save_init ();
    capture_init ();
    panel_init ();
    options_init ((gchar **) envp);

    /* Main GTK event loop */
    
    gtk_main ();

    /* Clean up capture functionality and free all data structures. */

    options_cleanup ();
    panel_cleanup ();
    capture_cleanup ();
    save_cleanup ();
    
    return (0);
}
