/*
 *  This file is part of MagiCapture.
 *  Copyright (C) 1999 Arthur Jerijian
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __MAGICAPTURE_CAPTURE_H__
#define __MAGICAPTURE_CAPTURE_H__

/* Function declarations */

gint capture_window_delete_event
(
    GtkWidget *widget,
    GdkEvent *event,
    gpointer data
);
void capture_window_destroy_event (GtkWidget *widget, gpointer data);

void capture_destroy_pixmap ();
void capture_destroy_window ();

void capture_init ();
void capture_cleanup ();

gboolean capture_do
(
    Image **p_capture_image,
    ImageInfo **p_capture_image_info,
    CaptureType cap_type,
    guint cap_delay
);
gboolean capture_preview (Image *capture_image);

void capture_show ();

#endif /* __MAGICAPTURE_CAPTURE_H__ */
