/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// wxWidgets
#include <wx/tokenzr.h>

// own header
#include "common.h"
#include "svrconf.h"

bool SvrConf::Initialize()
{
	filename = wxString(SERVERS_FILE);
#ifdef _SLACKGRADE_EMBEDDED_
	if(wxFileExists("../util/slackgrade/share/" + filename))
		filename = "../util/slackgrade/share/" + filename;
#else
	if(wxFileExists("../share/" + filename))
		filename = "../share/" + filename;
#endif
	else if(wxFileExists("/usr/local/share/" + wxString(HOST_SHARE) + filename))
		filename = "/usr/local/share/" + wxString(HOST_SHARE) + filename;
	else
		return FALSE;
	file = new wxFile();
	return TRUE;
}

bool SvrConf::CountSvr(int* count)
{
	wxString buffer;
	if(!ReadConf(&buffer))
		return FALSE;
	wxStringTokenizer lin(buffer,"\n");
	count = (int*)lin.CountTokens();
	return TRUE;
}

bool SvrConf::GetNames(wxArrayString* names)
{
	wxString buffer;
	if(!ReadConf(&buffer))
		return FALSE;
	wxStringTokenizer lin(buffer,"\n");
	while(lin.HasMoreTokens())
	{
		buffer = lin.GetNextToken();
		names->Add(buffer.BeforeFirst('\t'));
		names->Shrink();
	}
	return TRUE;
}

bool SvrConf::LoadSvr(int index,SVRINFO* svr)
{
	int counter;
	CountSvr(&counter);
	if(index>counter-1)
		return FALSE;
	counter = 0;
	wxString buffer;
	wxString line;
	if(!ReadConf(&buffer))
		return FALSE;
	wxStringTokenizer lin(buffer,"\n");
	while(lin.HasMoreTokens())
	{
		if(index==counter)
		{
			line = lin.GetNextToken();
			break;
		}
		lin.GetNextToken();
		counter++;
	}
	wxStringTokenizer tok(line,"\t");
	if(tok.CountTokens()!=4)
		return FALSE;
	if(tok.HasMoreTokens())
	{
		svr->Name = tok.GetNextToken();
		if(tok.HasMoreTokens())
		{
			svr->Proto = tok.GetNextToken();
			if(tok.HasMoreTokens())
			{
				svr->Host = tok.GetNextToken();
				if(tok.HasMoreTokens())
				{
					svr->Init = tok.GetNextToken();
				}
			}
		}
	}
	return TRUE;
}

bool SvrConf::SaveSvr(SVRINFO* svr)
{
	wxString line;
	wxString buffer;
	if(!ReadConf(&buffer))
		return FALSE;
	line = "\n" + svr->Name + "\t" + svr->Proto + "\t" + svr->Host + "\t" + svr->Init;
	buffer.Append(line);
	wxRemoveFile(filename);
	file->Open(filename,wxFile::write);
	file->Write(buffer.c_str(),buffer.Length());
	file->Close();
	return TRUE;
}

bool SvrConf::ReadConf(wxString* contents)
{
	if(!::wxFileExists(filename))
		return FALSE;
	if(file->Open(filename,wxFile::read))
	{
		file->Read(contents->GetWriteBuf(file->Length()),file->Length());
		file->Close();
	}
	else
		return FALSE;
	return TRUE;
}
