/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// wxWidgets
#include <wx/wx.h>
#include <wx/dialup.h>
#include <wx/listctrl.h>

#include "sgblist.h"
#include "sgproxy.h"

#define SLGR_EXIT_CLOSE		0
#define SLGR_EXIT_CANCEL	1
#define SLGR_EXIT_FINISH	2

class SlackGradeDlg: public wxDialog
{
public:
	SlackGradeDlg();
protected:
	bool CheckNew();
	bool DownloadFile(wxString,wxString);
	void InstallPackage(wxString);
	void OnAbout();
	void OnBlacklist();
	void OnCancel();
	void OnClose();
	void OnListSelect();
	void OnListDeselect();
	void OnNext();
	void OnOption1();
	void OnOption2();
	void OnProxy();
	void Quit(int);
	void RemoveTemp();
	void SetFinish(wxString);
	DECLARE_EVENT_TABLE()
private:
	SGPROXY		prx;		// proxy config struct
	SGProxy		*proxy;		// proxy config class
	
	wxArrayString	bl;		// the blacklist itself
	SGBlacklist	*blist;		// blacklist class
	
	bool		cancel;		// cancel flag
	unsigned int	step;		// wizard step
	
	wxArrayString	paths;
	wxString	newpack;
	wxGauge		*m_prg1;	// download progress
	wxButton	*m_btn1;	// Next button
	wxButton	*m_btn2;	// Cancel button
	wxButton	*m_btn3;	// About button
	wxButton	*m_btn4;	// SetProxy button
	wxButton	*m_btn5;	// Blacklist button
	wxComboBox	*m_cbo1;	// server selection
	wxListCtrl	*m_lst1;	// packages list
	wxRadioButton	*m_opt1;
	wxRadioButton	*m_opt2;
	wxTextCtrl	*m_txt1;	// title
	wxTextCtrl	*m_txt2;	// step info
	wxTextCtrl	*m_txt3;	// download info
	wxTextCtrl	*m_txt4;	// download counter
	wxTextCtrl	*m_txt5;	// version info
	wxStaticBitmap	*m_bmp1;
	wxDialUpManager *dialup;
};
