/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// wxWidgets
#include <wx/dir.h>
#include <wx/file.h>
#include <wx/tokenzr.h>
#include <wx/process.h>
#include <wx/timer.h>
#include <wx/txtstrm.h>
#include <wx/utils.h>
#include <wx/xrc/xmlres.h>

// own headers
#include "common.h"
#include "sgabout.h"
#ifdef _XPKGTOOL_HOST_
#include "../../../src/pkginfo.h"	// for XPKGTOOL build only
#else
#include "pkginfo.h"
#endif
#include "svrconf.h"
#include "slackgrade.h"
#include "xpm/slack120x240.xpm"
#include "xpm/slackgrade32.xpm"

// package scan mode
enum MODE
{
	UPGRADE_OLD = 0,
	INSTALL_NEW,
};

// wizard steps
enum WZD_STEP
{
	WZD_STEP_MODE = 1,
	WZD_STEP_SERVER,
	WZD_STEP_GETLIST,
	WZD_STEP_WILLFIND,
	WZD_STEP_FINDING,
	WZD_STEP_LIST,
	WZD_STEP_DOWNLOAD,
	WZD_STEP_READY,
	WZD_STEP_INSTALL,
	WZD_STEP_DONE,
};

// event map
BEGIN_EVENT_TABLE(SlackGradeDlg,wxDialog)
	EVT_BUTTON(XRCID("IDC_BUTTON1"),SlackGradeDlg::OnNext)
	EVT_BUTTON(XRCID("IDC_BUTTON2"),SlackGradeDlg::OnCancel)
	EVT_BUTTON(XRCID("IDC_BUTTON3"),SlackGradeDlg::OnAbout)
	EVT_BUTTON(XRCID("IDC_BUTTON4"),SlackGradeDlg::OnProxy)
	EVT_BUTTON(XRCID("IDC_BUTTON5"),SlackGradeDlg::OnBlacklist)
	EVT_RADIOBUTTON(XRCID("IDC_OPTION1"),SlackGradeDlg::OnOption1)
	EVT_RADIOBUTTON(XRCID("IDC_OPTION2"),SlackGradeDlg::OnOption2)
	EVT_LIST_ITEM_SELECTED(XRCID("IDC_LIST1"),SlackGradeDlg::OnListSelect)
	EVT_LIST_ITEM_DESELECTED(XRCID("IDC_LIST1"),SlackGradeDlg::OnListDeselect)
	EVT_CLOSE(SlackGradeDlg::OnClose)
END_EVENT_TABLE()

SvrConf svr;
SVRINFO svrinfo;
int mode;

// constructor
SlackGradeDlg::SlackGradeDlg()
{
	wxString resfile(RESOURCE_FILE);
#ifdef _SLACKGRADE_EMBEDDED_
	if(wxFileExists("../util/slackgrade/share/" + resfile))
		resfile = "../util/slackgrade/share/" + resfile;
#else
	if(wxFileExists("../share/" + resfile))
		resfile = "../share/" + resfile;
#endif
	else if(wxFileExists("/usr/local/share/" + wxString(HOST_SHARE) + resfile))
		resfile = "/usr/local/share/" + wxString(HOST_SHARE) + resfile;
	else
		wxMessageBox("Cannot find resource file",APP_NAME,wxICON_ERROR);
	wxXmlResource::Get()->Load(resfile);
	wxXmlResource::Get()->LoadDialog(this,NULL,"DLG_SLACKGRADE");
	SetTitle(APP_NAME);
	SetIcon(wxIcon(slackgrade32));
	// controls initialization (from resource)
	m_bmp1 = XRCCTRL(*this,"IDC_BITMAP1",wxStaticBitmap);
	m_btn1 = XRCCTRL(*this,"IDC_BUTTON1",wxButton);
	m_btn2 = XRCCTRL(*this,"IDC_BUTTON2",wxButton);
	m_btn3 = XRCCTRL(*this,"IDC_BUTTON3",wxButton);
	m_btn4 = XRCCTRL(*this,"IDC_BUTTON4",wxButton);
	m_btn5 = XRCCTRL(*this,"IDC_BUTTON5",wxButton);
	m_cbo1 = XRCCTRL(*this,"IDC_COMBO1",wxComboBox);
	m_lst1 = XRCCTRL(*this,"IDC_LIST1",wxListCtrl);
	m_opt1 = XRCCTRL(*this,"IDC_OPTION1",wxRadioButton);
	m_opt2 = XRCCTRL(*this,"IDC_OPTION2",wxRadioButton);
	m_prg1 = XRCCTRL(*this,"IDC_PROGRESS1",wxGauge);
	m_txt1 = XRCCTRL(*this,"IDC_STATIC1",wxTextCtrl);
	m_txt2 = XRCCTRL(*this,"IDC_STATIC2",wxTextCtrl);
	m_txt3 = XRCCTRL(*this,"IDC_STATIC3",wxTextCtrl);
	m_txt4 = XRCCTRL(*this,"IDC_STATIC4",wxTextCtrl);
	m_txt5 = XRCCTRL(*this,"IDC_STATIC5",wxTextCtrl);
	m_bmp1->SetBitmap(wxImage(slack120x240));
	m_lst1->InsertColumn(0,"New package",wxLIST_FORMAT_LEFT,185);
	m_lst1->InsertColumn(1,"Old package",wxLIST_FORMAT_LEFT,180);
	m_lst1->InsertColumn(2,"Size",wxLIST_FORMAT_LEFT,60);
	m_lst1->InsertColumn(3,"Base",wxLIST_FORMAT_LEFT,45);
	m_txt3->Show(FALSE); m_txt4->Show(FALSE); m_cbo1->Show(FALSE);
	m_btn4->Show(FALSE); m_btn5->Show(FALSE); m_lst1->Show(FALSE);
	m_prg1->Show(FALSE); m_opt1->Show(FALSE); m_opt2->Show(FALSE);
	m_txt5->SetLabel("version: " + wxString(APP_VERSION));
	Centre();
	step=0;
	cancel = FALSE;
	if(::wxGetUserId()!="root")
	{
		SetFinish("Wizard must run in superuser mode (root).");
		return;
	}
	if(!svr.Initialize())
	{
		SetFinish("Servers list was not found.");
		return;
	}
	
	// initialize proxy configurations
	proxy = new SGProxy();
	// initialize the blacklist
	blist = new SGBlacklist();
	
	m_txt2->SetLabel("This wizard will guide you through the Slackware update process.\nClick 'Next' button to begin, or 'Cancel' to exit.");
	return;
}

// ::CheckNew( ) - find for new packages in the packages list file
bool SlackGradeDlg::CheckNew()
{
	PKGINFO pkg;
	wxString contents;
	wxFile *file = new wxFile();
	wxListItem column;
	wxString filename = DOWNLOAD_PATH;
	filename.Append(PACKAGE_LIST_FILE);
	m_lst1->GetColumn(1,column);
	switch(mode)
	{
		case INSTALL_NEW:
			column.m_text = "Description";
			break;
		case UPGRADE_OLD:
			column.m_text = "Old Package";
			break;
	}
	m_lst1->SetColumn(1,column);
	if(file->Open(filename))
	{
		long int counter = 0;
		off_t pos;
		PKGNAME newpkg, oldpkg;
		wxString curpkg, inspkg;
		wxString pack,version,arch,build;
		wxString *buffer = new wxString();
		file->Read(buffer->GetWriteBuf(file->Length()),file->Length());
		file->Close();
		contents = buffer->Right(buffer->Length() - buffer->First("PACKAGE NAME"));
		paths.Clear();
		for( ; ; )
		{
			if(contents.Length()<10)
				break;
			pos = contents.First("\n\n");
			curpkg = contents.Left(pos);
			contents.Remove(0,pos + 2);
			if(GetPackageInfo(curpkg,&pkg,NO_FULL_DESCRIPTION,FROM_UPDATE))
			{
				::wxYield();	// force gui update
				// strip the package name into its components: name, version, arch and build
				curpkg = *pkg.Name;
				StripPackageName(curpkg,&newpkg);
				// check if a previous version is installed on the system
				inspkg = LOCAL_PACKAGE_PATH + newpkg.Name + "*";
				inspkg = ::wxFindFirstFile(inspkg);
				switch(mode)
				{
					case INSTALL_NEW:
						if(inspkg.IsEmpty())
						{
							//StripPackageName(inspkg.AfterLast('/'),&oldpkg);
							// find if some blacklist entry matches the package
							if(blist->IsInBlacklist(newpkg.Full,bl))
								break;
							m_lst1->InsertItem(counter,0);
							m_lst1->SetItem(counter,0,newpkg.Full);
							m_lst1->SetItem(counter,1,*pkg.ShortDescription);
							m_lst1->SetItem(counter,2,*pkg.CompressedSize);
							m_lst1->SetItem(counter,3,(*pkg.Location).AfterLast('/'));
							paths.Add(*pkg.Location);
							counter++;
						}
						break;
					case UPGRADE_OLD:
						if(!inspkg.IsEmpty())
						{
							StripPackageName(inspkg.AfterLast('/'),&oldpkg);
							// find if some blacklist entry matches the package
							if(blist->IsInBlacklist(newpkg.Full,bl))
								break;
							// checks if is exactly the same package name.
							// this prevents against a wrong package scan, when
							// 2 or more packages haves the same name prefix.
							// example: 'at' and 'at-spi'
							if(newpkg.Name!=oldpkg.Name)
							{
								continue;
								/*	(reserved)
								inspkg = ::wxFindNextFile();
								while(!inspkg.IsEmpty())
								{
									StripPackageName(inspkg.AfterLast('/'),&oldpkg);
									if(newpkg.Name.Length()==oldpkg.Name.Length())
										break;
									inspkg = ::wxFindNextFile();
								}
								*/
							}
							// compare version, arch and build of new and current package
							if(oldpkg.Version.CompareTo(newpkg.Version)!=0 ||
								oldpkg.Arch.CompareTo(newpkg.Arch)!=0 ||
								oldpkg.Build.CompareTo(newpkg.Build)!=0)
							{
								m_lst1->InsertItem(counter,0);
								m_lst1->SetItem(counter,0,newpkg.Full);
								m_lst1->SetItem(counter,1,oldpkg.Full);
								m_lst1->SetItem(counter,2,*pkg.CompressedSize);
								m_lst1->SetItem(counter,3,(*pkg.Location).AfterLast('/'));
								paths.Add(*pkg.Location);
								counter++;
							}
						}
						break;
				}
			}
		}
	}
	if(m_lst1->GetItemCount()>0)
		return TRUE;
	return FALSE;
}

// ::DownloadFile( ) - gets the specified file from remote server
bool SlackGradeDlg::DownloadFile(wxString path,wxString filename)
{
	wxFile file;
	wxString data;
	wxString buffer;
	
	// checks if is connected
	dialup = wxDialUpManager::Create();
	if(dialup->IsOk())
	{
		if(!dialup->IsOnline())
		{
			SetFinish("Computer is not connected to the internet.\nMake sure you're online and try again.");
			return FALSE;
		}
	}
	
	m_btn1->Enable(FALSE); m_btn3->Enable(FALSE);
	m_txt4->Show(TRUE); m_prg1->Show(TRUE);
	m_txt3->SetLabel("Connecting " + svrinfo.Host);
	::wxYield();
	// open a remote query for the file and download it
	wxURL url(svrinfo.Proto + "://" + svrinfo.Host + "/" + svrinfo.Init + path + filename);
	if(prx.UseProxy && svrinfo.Proto=="http")
		url.SetProxy(prx.ProxySvr + ":" + prx.ProxyPort);
	switch(url.GetError())
	{
		case wxURL_NOERR:
			m_txt3->SetLabel("Connected, requesting file...");
			break;
		case wxURL_SNTXERR:
			SetFinish("Connection error: Malformed URL.");
			return FALSE;
		case wxURL_NOPROTO:
			SetFinish("Connection error: Wrong protocol specified.");
			return FALSE;
		case wxURL_NOHOST:
			SetFinish("Connection error: No host name given.");
			return FALSE;
		case wxURL_NOPATH:
			SetFinish("Connection error: Wrong path to URL.");
			return FALSE;
		case wxURL_CONNERR:
			SetFinish("Connection error: Unable to connect remote server.");
			return FALSE;
		case wxURL_PROTOERR:
			SetFinish("Connection error: Cannot negotiate data transfer.");
			return FALSE;
		default:
			SetFinish("Connection error: Unknown.");
			return FALSE;
	}
	wxInputStream *in = url.GetInputStream();
	if(in)
	{
		double dlrate;				// download rate
		wxStopWatch timer;			// gets the time for each data read
		size_t rSize = 0;			// ammount of data bytes read
		size_t tSize = in->StreamSize();	// total download size
		m_prg1->SetRange((int)tSize/1000);
		m_prg1->SetValue(0);
		m_txt3->SetLabel("Downloading: " + filename);
		// the download itself
		do
		{
			timer.Start();
			in->Read(data.GetWriteBuf(BUFFER_SIZE),BUFFER_SIZE);
			timer.Pause();
			if(in->LastRead()==0)
				break;
			rSize += in->LastRead();
			in->SeekI(rSize+1);
			buffer.Append(data.Left(in->LastRead()));
			dlrate = (double)in->LastRead() / timer.Time();	// calculates the download rate
			m_prg1->SetValue((int)rSize/1000);
			m_txt4->SetLabel(wxString::Format("%.2f of %.2f kbytes  (%.1f kb/s)",(double)rSize/1024,(double)tSize/1024,dlrate));
			::wxYield();	// force gui update
			data.Clear();
			if(cancel==TRUE)
			{
				delete in;
				return FALSE;
			}
		} while(in->LastRead());
	
		// create local download directory, if does not exist
		if(!wxDir::Exists(DOWNLOAD_PATH))
		::wxMkdir(DOWNLOAD_PATH);
		// remove any previous reference to the downloaded file, if exist
		::wxRemoveFile(DOWNLOAD_PATH + filename);
		
		// save downloaded data into a local file
		if(!file.Exists(DOWNLOAD_PATH + filename))
			file.Create(DOWNLOAD_PATH + filename,TRUE);
		if(file.Open(DOWNLOAD_PATH + filename,wxFile::write))
		{
			file.Write(buffer,tSize);
			file.Close();
		}
		else
		{
			SetFinish(filename + "\ncannot write file.");
			delete in;
			return FALSE;
		}
	
	}
	else
	{
		// file was (probably) not found - just skip it
		delete in;
		return TRUE;
		//SetFinish("Unexpected error downloading " + filename);
		//delete in;
		//return FALSE;
	}
	delete in;
	return TRUE;
}

// ::InstallPackage( ) - install/upgrade a package 
void SlackGradeDlg::InstallPackage(wxString pkg)
{
	wxString cmd;
	wxString str;
	switch(mode)
	{
		case INSTALL_NEW:
			cmd.Append("installpkg ");
			break;		
		case UPGRADE_OLD:
			cmd.Append("upgradepkg ");
			break;
	}
	cmd.Append(pkg);
	wxProcess *pid = new wxProcess(wxPROCESS_REDIRECT);
	::wxExecute((const wxString&)cmd,wxEXEC_ASYNC,pid);
	wxTextInputStream tis(*pid->GetInputStream());
	tis.SetStringSeparators("\n");
	for( ; ; )
	{
		str = tis.ReadWord();
		if(str!=wxEmptyString)
			printf("%s\n",str.c_str());
		else
			break;
	}
}

// ::OnAbout( ) - shows the about dialog
void SlackGradeDlg::OnAbout()
{
	SGAboutDlg *about = new SGAboutDlg();
	about->ShowModal();
	delete about;
}

// ::OnBlacklist( ) - shows the blacklist config dialog
void SlackGradeDlg::OnBlacklist()
{
	SGBlacklistDlg *blistdlg = new SGBlacklistDlg();
	blistdlg->ShowModal();
	delete blistdlg;	
}

// ::OnCancel - Cancel button pressed (exit status 1)
void SlackGradeDlg::OnCancel()
{
	Quit(SLGR_EXIT_CANCEL);
	return;
}

// ::OnClose - user closed dialog (exit status 0)
void SlackGradeDlg::OnClose()
{
	Quit(SLGR_EXIT_CLOSE);
	return;
}

// ::OnListDeselect( ) - user deselects an item in the list
void SlackGradeDlg::OnListDeselect()
{
	if(m_lst1->GetSelectedItemCount()==0)
		m_btn1->Enable(FALSE);
	return;
}

// ::OnListSelect( ) - user selects an item in the list
void SlackGradeDlg::OnListSelect()
{
	m_btn1->Enable(TRUE);
	return;
}

// ::OnNext( ) - calls the next wizard step
void SlackGradeDlg::OnNext()
{
	static bool hasnew = FALSE;
	step++;
	long item = -1;
	wxArrayString servers;
	switch(step)
	{
		case WZD_STEP_MODE:
			m_txt2->SetLabel("Which kind of update do you want to do at this time?");
			m_opt1->Show(TRUE); m_opt2->Show(TRUE);
			mode = INSTALL_NEW;
			//OnNext();
			break;
		case WZD_STEP_SERVER: // choose server
			m_opt1->Show(FALSE); m_opt2->Show(FALSE); m_btn4->Show(TRUE);
			if(svr.GetNames(&servers))
			{
				for(size_t i=0;i<servers.Count();i++)
				{
					m_cbo1->Append(servers.Item(i));
				}
			}
			m_cbo1->SetSelection(3);
			m_txt2->SetLabel("Choose below the remote server from where you want to find\nfor new packages, then click Next.");
			m_cbo1->Show(TRUE);
			break;
		case WZD_STEP_GETLIST:	// get latest package list from server
			if(!svr.LoadSvr(m_cbo1->GetSelection(),&svrinfo))
			{
				SetFinish("Unable to load server settings.");
				return;
			}
			m_btn4->Show(FALSE);
			m_txt2->SetLabel("Getting latest packages list from server, please wait...");
			m_txt3->Show(TRUE); m_cbo1->Show(FALSE); m_lst1->Show(FALSE);
			::wxYield();	// force gui update
			proxy->LoadProxy(&prx);
			if(!DownloadFile("slackware-current/",PACKAGE_LIST_FILE))
				return;
			m_btn1->Enable(TRUE);
			OnNext();
			break;
		case WZD_STEP_WILLFIND:	// inform user about the next step
			m_txt2->SetLabel("Wizard will now determine wich new packages are currently available.\n\nIf has some package(s) you don't want to list, add it(s) to the blacklist:");
			m_txt3->Show(FALSE); m_txt4->Show(FALSE); m_prg1->Show(FALSE);
			m_btn5->Show(TRUE); m_btn3->Enable(TRUE);
			m_prg1->SetValue(0);
			break;
		case WZD_STEP_FINDING:	// find for new packages in the listing file
			m_txt2->SetLabel("Finding for new packages... Please wait.");
			m_btn5->Show(FALSE);
			::wxBeginBusyCursor();
			blist->LoadBlacklist(&bl);
			hasnew = CheckNew();
			::wxEndBusyCursor();
			OnNext();
			break;
		case WZD_STEP_LIST:	// show the new packages (if any)
			if(hasnew==TRUE)
			{
				m_txt2->SetLabel(wxString::Format("%d new package(s) found.\n",m_lst1->GetItemCount()) +
						"Select in the list below those you want to update.");
				m_lst1->Show(TRUE);
				m_btn3->Enable(TRUE);
				m_btn1->Enable(FALSE);
			}
			else
				SetFinish("No new packages found at this time.");
			break;
		case WZD_STEP_DOWNLOAD:	// download and upgrade selected new packages
			m_txt2->SetLabel("Downloading new package(s), please wait...");
			m_txt3->Show(TRUE); m_lst1->Show(FALSE);
			//Refresh();
			// download selected packages
			for( ; ; )
			{
				item = m_lst1->GetNextItem(item,wxLIST_NEXT_BELOW,wxLIST_STATE_SELECTED);
				Refresh();
				if(item!=-1)
				{
					m_prg1->SetValue(0);
					m_txt4->SetLabel("");
					newpack = m_lst1->GetItemText(item);
					if(!DownloadFile("slackware-current/slackware/" + paths.Item(item).AfterLast('/') + "/",
							newpack + ".tgz"))
						return;
				}
				else
					break;
			}
			m_btn1->Enable(TRUE);
			OnNext();
			break;
		case WZD_STEP_READY: // ready to find for new packages
			m_txt3->Show(FALSE); m_txt4->Show(FALSE); m_prg1->Show(FALSE);
			m_btn3->Enable(TRUE);
			switch(mode)
			{
				case INSTALL_NEW:
					m_txt2->SetLabel("Wizard is now ready to install the new package(s).\nClick Next to start the installation process.");
					break;		
				case UPGRADE_OLD:
					m_txt2->SetLabel("Wizard is now ready to upgrade old packages with the newest.\nClick Next to start the upgrade process.");
					break;
			}
			break;
		case WZD_STEP_INSTALL:	// upgrade packages
			m_btn1->Enable(FALSE); m_btn2->Enable(FALSE); m_btn3->Enable(FALSE);
			::wxBeginBusyCursor();
			for( ; ; )
			{
				newpack = ::wxFindFirstFile(wxString(DOWNLOAD_PATH).Append("*.tgz"));
				switch(mode)
				{
					case INSTALL_NEW:
						m_txt2->SetLabel("Installing " + newpack.AfterLast('/').BeforeLast('.') + "...");
						break;		
					case UPGRADE_OLD:
						m_txt2->SetLabel("Upgrading to " + newpack.AfterLast('/').BeforeLast('.') + "...");
						break;
				}
				::wxYield();	// force gui update
				if(newpack==wxEmptyString)
					break;
				InstallPackage(newpack);
				::wxRemoveFile(newpack);
			}
			::wxEndBusyCursor();
			OnNext();
			break;
		case WZD_STEP_DONE:	// self descriptive :)
			SetFinish("Update process completed.");
			break;
		default: // occurs after a ::SetFinish( ) call
			if(m_btn1->GetLabel()=="Finish")
				Quit(SLGR_EXIT_FINISH);	// exit status 2
			break;
	}
}

// ::OnOption1( ) - user selected option 1 (install new packages)
void SlackGradeDlg::OnOption1()
{
	mode = INSTALL_NEW;
	return;
}

// ::OnOption2( ) - user selected option 2 (upgrade installed packages)
void SlackGradeDlg::OnOption2()
{
	mode = UPGRADE_OLD;
	return;
}

// ::OnProxy( ) - shows the proxy config dialog
void SlackGradeDlg::OnProxy()
{
	SGProxyDlg *proxydlg = new SGProxyDlg();
	int result = proxydlg->ShowModal();
	delete proxydlg;
	if(result==wxID_OK)
	{
		proxy->LoadProxy(&prx);
	}	
}

// ::Quit - ends application with proper exit status
void SlackGradeDlg::Quit(int exitcode)
{
	cancel = TRUE;
	RemoveTemp();
#ifdef _SLACKGRADE_EMBEDDED_
	EndModal(exitcode);
#else
	exit(exitcode);
#endif
	return;
}

// ::RemoveTemp( ) - removes all downloaded files
void SlackGradeDlg::RemoveTemp()
{
	if(::wxDirExists(DOWNLOAD_PATH))
	{
		wxString file;
		m_cbo1->Show(FALSE); m_txt3->Show(FALSE); m_txt4->Show(FALSE);
		m_prg1->Show(FALSE); m_btn2->Show(FALSE); m_lst1->Show(FALSE);
		m_txt2->SetLabel("Removing temporary files...");
		::wxYield();	// force gui update
		for( ; ; )
		{
			file = ::wxFindFirstFile(wxString(DOWNLOAD_PATH).Append("*.*"));
			if(file!=wxEmptyString)
				::wxRemoveFile(file);
			else
				break;
		}
	}
	return;
}

// ::SetFinish( ) - change wizard state to the last step
void SlackGradeDlg::SetFinish(wxString message)
{
	m_txt2->SetLabel(message);
	m_cbo1->Show(FALSE); m_txt3->Show(FALSE); m_txt4->Show(FALSE);
	m_prg1->Show(FALSE); m_btn2->Show(FALSE); m_btn3->Show(FALSE);
	m_btn4->Show(FALSE); m_btn5->Show(FALSE); m_btn1->Enable(TRUE);
	m_btn1->SetLabel("Finish");
	step = WZD_STEP_DONE + 1;
	return;
}
