/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// pkginfo.cpp:	this file was extracted from XPKGTOOL source tree.
// 		the purpose of this file in SlackGrade source is
//		to build it as stand-alone utility or as embedded
//		component in other tool than XPKGTOOL.
//		if you're modifying XPKGTOOL, changes in this file
//		will not reflect in XPKGTOOL build.

#include <wx/ffile.h>
#include <wx/tokenzr.h>
#include "common.h"
#include "pkginfo.h"

// LoadPackageInfoFile - gets package information from a log file
// args:
//	wxString Package - log file containing package data
//	PKGINFO* pkginfo - structure that will receive the info
//	bool withFullDesc - if TRUE, gets the full description and file list
//			if FALSE, full description and file list will back empty
//			this is useful to speed up packages list reading when
//			full description is not necessary. e.g.: refreshing the list
bool LoadPackageInfoFile(wxString Package,PKGINFO* pkginfo,bool withFullDesc)
{
	wxString *buffer = new wxString();
	wxFFile *file = new wxFFile();
	Package.Prepend(LOCAL_PACKAGE_PATH);
	if(file->Open((const char*)Package)) 
	{
		if(file->Read(buffer->GetWriteBuf(file->Length()),file->Length()))
		{
			file->Close();
			GetPackageInfo(*buffer,pkginfo,withFullDesc);
		}
		else
		{
			file->Close();
			return(FALSE);
		}
	}
	else
	{
		return(FALSE);
	}
	return(TRUE);	
}

// GetPackageInfo - gets package information
// args:
//	wxString pkgdata - data associated with the package
//	PKGINFO* pkginfo - structure that will receive the info
//	bool withFullDesc - if TRUE, gets the full description and file list
//			if FALSE, full description and file list will back empty
//			this is useful to speed up packages list reading when
//			full description is not necessary. e.g.: refreshing the list
//	bool local - if TRUE, gets info in the local package format
//		  if FALSE, gets info in the remote package list format
bool GetPackageInfo(wxString pkgdata,PKGINFO* pkginfo,bool withFullDesc,bool local)
{
	wxStringTokenizer tokens;
	wxArrayString array;
	wxString temp;
	pkginfo->Name = new wxString();
	pkginfo->CompressedSize = new wxString();
	pkginfo->UncompressedSize = new wxString();
	pkginfo->Location = new wxString();
	pkginfo->ShortDescription = new wxString();
	pkginfo->FullDescription = new wxString();
	pkginfo->FileList = new wxString();
	tokens.SetString(pkgdata,"\n");
	if(withFullDesc==TRUE)
	{
		while(tokens.HasMoreTokens())
		{
			array.Add(tokens.GetNextToken());
		}
	}
	else
	{
		for(unsigned int i=0;i<=5;i++)
		{
			array.Add(tokens.GetNextToken());
		}
	}
	*pkginfo->Name = (wxString)array.Item(0).AfterFirst(':').Trim(FALSE);
	if(local)	// local installed package info
	{
		*pkginfo->CompressedSize = (wxString)array.Item(1).AfterFirst(':').Trim(FALSE);
		*pkginfo->UncompressedSize = (wxString)array.Item(2).AfterFirst(':').Trim(FALSE);
		*pkginfo->Location = (wxString)array.Item(3).AfterFirst(':').Trim(FALSE);
	}
	else		// remote package info, i.e.: from update info file
	{
		*pkginfo->CompressedSize = (wxString)array.Item(2).AfterFirst(':').Trim(FALSE);
		*pkginfo->UncompressedSize = (wxString)array.Item(3).AfterFirst(':').Trim(FALSE);
		*pkginfo->Location = (wxString)array.Item(1).AfterFirst(':').Trim(FALSE);
	}
	*pkginfo->ShortDescription = (wxString)array.Item(5).AfterFirst(':').Trim(FALSE);
	if(*pkginfo->ShortDescription!="")
	{
		if(withFullDesc == TRUE)
		{
			for(unsigned int index=5;index<array.GetCount();index++)
			{
				if(array.Item(index).Find("FILE LIST")<0)
				{
					*pkginfo->FullDescription->Append((wxString)array.Item(index).AfterFirst(':').Trim(FALSE).Append(" "));
				}
				else
				{
					for(index=index++;index<array.GetCount()-1;index++)
					{
						*pkginfo->FileList->Append((wxString)array.Item(index) + "\n");
					}
					break;
				}
			}
		}
		if(*pkginfo->FullDescription=="")
		{
			*pkginfo->FullDescription = "(no description)";
		}
	}
	else
	{
		*pkginfo->ShortDescription = "(no description)";
		*pkginfo->FullDescription = "(no description)";
		*pkginfo->FileList = "(not given)";
	}
	return(TRUE);
}

// StripPackageName - separate a package name into its components
// args:
//	wxString pkgname - the package name
//	PKGNAME* pack - structure that will receive the info
void StripPackageName(wxString pkgname,PKGNAME* pack)
{
	wxArrayString parray;
	wxStringTokenizer *tokens = new wxStringTokenizer();
	if(pkgname.Right(4)==".tgz")
		pkgname = pkgname.BeforeLast('.');	// remove .tgz extension
	tokens->SetString(pkgname,"-");
	parray.Clear();
	pack->Name.Clear();
	while(tokens->HasMoreTokens())
	{
		parray.Add(tokens->GetNextToken());
	}
	pack->Full = pkgname;
	pack->Build = (wxString)parray.Item(parray.Count()-1);
	pack->Arch = (wxString)parray.Item(parray.Count()-2);
	pack->Version = (wxString)parray.Item(parray.Count()-3);
	for(size_t i=0;i<parray.Count()-3;i++)
	{
		pack->Name += (wxString)parray.Item(i) + "-";
	}
	return;
}
