/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// ABOUT_FILE: file that contains about info
// APP_NAME: the app name
// APP_VERSION: the app version (the .[emb] suffix denotes an embedded build)
// BLIST_FILE: file that contains the user's blacklist
// BUFFER_BASE: base size, in bytes, of the download buffer
// DOWNLOAD_PATH: temporary path where downloaded packages are saved into
// HOST_SHARE: shared subfolder of the application hosting an embedded build
// LOCAL_PACKAGE_PATH: path where information about installed packages are in
// PACKAGE_LIST_FILE: file that contains a list of current Slackware packages
// PROXY_FILE: file that contains the proxy configurations
// RESOURCE_FILE: dialog resource file
// SERVERS_FILE: server info list file
//

// core
#define CORE_VERSION		"0.0.2exp"
#define CORE_NAME		"SlackGrade"

// build dependent
#ifdef _SLACKGRADE_EMBEDDED_
#define ABOUT_FILE		"slackgrade/about/indexe.html"
#define APP_NAME		CORE_NAME" [embedded]"
#define APP_VERSION		CORE_VERSION".[emb]"
#define HOST_SHARE		"xpkgtool/"
#else
#define ABOUT_FILE		"slackgrade/about/index.html"
#define APP_NAME		CORE_NAME
#define APP_VERSION		CORE_VERSION
#define HOST_SHARE
#endif

// common
#define BUFFER_SIZE		16255
#define BLIST_FILE		"slackgrade/blacklist"
#define DOWNLOAD_PATH		"/tmp/slackgrade/"
#define LOCAL_PACKAGE_PATH	"/var/log/packages/"
#define PACKAGE_LIST_FILE	"PACKAGES.TXT"
#define PROXY_FILE		"slackgrade/proxy"
#define RESOURCE_FILE		"slackgrade/slackgrade.wxr"
#define SERVERS_FILE		"slackgrade/servers"
