/*
xpkgtool is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// declares
#include "pkgprop.h"
#include "pkginfo.h"

BEGIN_EVENT_TABLE(PropDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),PropDlg::OnOK)
	EVT_CLOSE(PropDlg::OnClose)
END_EVENT_TABLE()

// The Properties Dialog
PropDlg::PropDlg(wxString Package)
{
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_PKGPROPS");
	Centre();
	// controls initialization (from resource)
	m_btnok = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_txtname = XRCCTRL(*this, "IDC_EDIT_NAME", wxTextCtrl);
	m_txtcsize = XRCCTRL(*this, "IDC_EDIT_CSIZE", wxTextCtrl);
	m_txtusize = XRCCTRL(*this, "IDC_EDIT_USIZE", wxTextCtrl);
	m_txtlocation = XRCCTRL(*this, "IDC_EDIT_LOCATION", wxTextCtrl);
	m_txtdesc = XRCCTRL(*this, "IDC_EDIT_DESC", wxTextCtrl);
	m_txtflist = XRCCTRL(*this, "IDC_EDIT_FLIST", wxTextCtrl);
	PKGINFO pkg;
	LoadPackageInfoFile(Package,&pkg);
	m_txtname->SetValue(*pkg.Name);
	m_txtcsize->SetValue(*pkg.CompressedSize);
	m_txtusize->SetValue(*pkg.UncompressedSize);
	m_txtlocation->SetValue(*pkg.Location);
	m_txtdesc->SetValue(*pkg.FullDescription);
	m_txtflist->SetValue(*pkg.FileList);
}

void PropDlg::OnOK()
{
	Close(TRUE);
}

void PropDlg::OnClose()
{
	delete this;
}
