/*
xpkgtool is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <wx/xrc/xmlres.h>
#include "common.h"
#include "main.h"
#include "maindlg.h"

// ::OnInit - loads and shows the main dialog
bool XpkgtoolApp::OnInit()
{
	wxString ResourceFile;
	wxHandleFatalExceptions(TRUE);
	wxXmlResource::Get()->InitAllHandlers();
	if(wxFileExists("../share/xpkgtool/xpkgtool.wxr"))
		ResourceFile = "../share/xpkgtool/xpkgtool.wxr";
	else if(wxFileExists("/usr/local/share/xpkgtool/xpkgtool.wxr"))
		ResourceFile = "/usr/local/share/xpkgtool/xpkgtool.wxr";
	else
	{
		wxMessageBox("Resource file was not found.",APP_NAME,wxICON_ERROR);
		exit(-1);
	}
	
	// if not running as superuser (root), shows a message warning
	if(wxGetUserId()!="root")
	{
		wxMessageBox("While not in superuser mode (root)\nyou are not able to perform\npackage admin operations.",
			APP_NAME,wxICON_INFORMATION);
	}
	
	wxXmlResource::Get()->Load(ResourceFile);
	MainDlg *m_main = new MainDlg();
	m_main->Centre();
	m_main->Show(TRUE);
	return(TRUE);
}

// ::OnFatalException - alert user if a segfault occurs
void XpkgtoolApp::OnFatalException()
{
	wxMessageBox("Segmentation fault!!!",APP_NAME,wxOK | wxICON_ERROR);
	return;
}
