/*
xpkgtool is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <wx/tokenzr.h>
#include <wx/xrc/xmlres.h>
#include "intcheck.h"
#include "pkginfo.h"

BEGIN_EVENT_TABLE(IntCheckDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),IntCheckDlg::OnClose)
	EVT_CLOSE(IntCheckDlg::OnClose)
END_EVENT_TABLE()

IntCheckDlg::IntCheckDlg()
{
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_INTCHECK");
	Centre();
	// controls initialization (from resource)
	m_btnok = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_flist = XRCCTRL(*this, "IDC_EDIT_FLIST", wxTextCtrl);
	m_text = XRCCTRL(*this, "IDC_STATIC_INFO", wxTextCtrl);
	m_flist->Show(FALSE);
}

void IntCheckDlg::OnYes()
{
	Close(TRUE);
}

void IntCheckDlg::OnClose()
{
	delete this;
}

void IntCheckDlg::IntegrityCheck(wxString package)
{
	PKGINFO pkg;
	wxString file;
	wxArrayString notfound;
	wxStringTokenizer files;
	m_btnok->Enable(FALSE);
	m_text->SetLabel(package + "\nChecking package integrity, please wait...");
	::wxYield();
	::wxBeginBusyCursor();
	LoadPackageInfoFile(package,&pkg,TRUE);		// get package info
	files.SetString(*pkg.FileList,"\n");		// strip file list
	while(files.HasMoreTokens())
	{
		::wxYield();
		file = files.GetNextToken();
		//printf("%s\n",file.c_str());
		if(file.Left(8)!="install/" && file.Left(2)!="./")
		{
			if(file.Last()=='/')
			{
				if(!::wxDirExists("/" + file))
					notfound.Add(file);
			}
			else
			{
				if(!::wxFileExists("/" + file))
					notfound.Add(file);
			}
		}
	}
	if(notfound.Count()>0)
	{
		for(size_t i=0;i<notfound.Count();i++)
			m_flist->AppendText("/" + notfound.Item(i) + "\n");
		m_text->SetLabel(package + "\nPackage seems to be corrupted.\nThis doesn't means it's not working, but if you're experiencing\nproblems with this package, is recommendable to reinstall it.\n\n" + 
				wxString::Format("%d",notfound.Count()) + " file(s) were not found:");
		m_flist->Show(TRUE);
	}
	else
	{
		m_text->SetLabel(package + "\nPackage integrity seems to be OK.");
	}
	::wxEndBusyCursor();
	m_btnok->Enable(TRUE);
	return;
}
