/*
xpkgtool is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

// declares
#include <wx/xrc/xmlres.h>
#include "about.h"

BEGIN_EVENT_TABLE(AboutDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),AboutDlg::OnOK)
	EVT_CLOSE(AboutDlg::OnClose)
END_EVENT_TABLE()

AboutDlg::AboutDlg()
{
	wxString page;
	::wxInitAllImageHandlers();
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_ABOUTBOX");
	Centre();
	// controls initialization (from resource)
	m_btnok = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_html = XRCCTRL(*this, "IDC_HTML_CTRL", wxHtmlWindow);
	if(wxFileExists("../share/xpkgtool/about.htm"))
		page = "../share/xpkgtool/about.htm";
	else if(wxFileExists("/usr/local/share/xpkgtool/about.htm"))
		page = "/usr/local/share/xpkgtool/about.htm";
	m_html->LoadPage(page);
}

void AboutDlg::OnOK()
{
	Close(TRUE);
}

void AboutDlg::OnClose()
{
	delete this;
}
