/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/
 
#include <wx/wx.h>

typedef struct tagSGPROXY
{
	bool UseProxy;		// user want to use a proxy server?
	wxString ProxySvr;	// proxy server
	wxString ProxyPort;	// proxy port
}SGPROXY;

//--------------------------------------------------------------
//	SGProxy: a class to handle the proxy file
//--------------------------------------------------------------

class SGProxy
{
public:
	SGProxy();
	bool LoadProxy(SGPROXY*);
	bool SaveProxy(SGPROXY*);
private:
	wxString	pfile;	// proxy file
};

//--------------------------------------------------------------
//	SGProxyDlg: the proxy dialog class
//--------------------------------------------------------------

class SGProxyDlg: public wxDialog
{
public:
	SGProxyDlg();
	void OnOK();
	void OnCancel();
	void OnClose();
	void OnProxy();
protected:
	DECLARE_EVENT_TABLE()
private:
	SGPROXY		prx;
	SGProxy		*proxy;
	wxButton	*m_button1;	// OK button
	wxButton	*m_button2;	// Cancel button
	wxCheckBox	*m_check1;	// Use Proxy
	wxTextCtrl	*m_edit1;	// Proxy Server
	wxTextCtrl	*m_edit2;	// Proxy Port
};
