/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/
 
// wxWidgets
#include <wx/file.h>
#include <wx/xrc/xmlres.h>

// own
#include "common.h"
#include "sgproxy.h"

//--------------------------------------------------------------
//	SGProxyDlg: the configurations dialog class
//--------------------------------------------------------------

BEGIN_EVENT_TABLE(SGProxyDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),SGProxyDlg::OnOK)
	EVT_BUTTON(XRCID("IDC_BUTTON_CANCEL"),SGProxyDlg::OnClose)
	EVT_CHECKBOX(XRCID("IDC_CHECK1"),SGProxyDlg::OnProxy)
	EVT_CLOSE(SGProxyDlg::OnClose)
END_EVENT_TABLE()

SGProxyDlg::SGProxyDlg()
{
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_PROXY");
	Centre();
	// controls initialization (from resource)
	m_button1 = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_button2 = XRCCTRL(*this, "IDC_BUTTON_CANCEL", wxButton);
	m_check1 = XRCCTRL(*this, "IDC_CHECK1", wxCheckBox);
	m_edit1 = XRCCTRL(*this, "IDC_EDIT1", wxTextCtrl);
	m_edit2 = XRCCTRL(*this, "IDC_EDIT2", wxTextCtrl);
	// load configurations
	proxy = new SGProxy();
	if(proxy->LoadProxy(&prx))
	{
		m_check1->SetValue(prx.UseProxy);
		m_edit1->Enable(prx.UseProxy);
		m_edit2->Enable(prx.UseProxy);
		m_edit1->SetValue(prx.ProxySvr);
		m_edit2->SetValue(prx.ProxyPort);
	}
	else
	{
		m_edit1->Enable(FALSE);
		m_edit2->Enable(FALSE);	
	}
	return;
}

void SGProxyDlg::OnOK()
{
	prx.UseProxy = m_check1->GetValue();
	prx.ProxySvr = m_edit1->GetValue();
	if(m_edit2->GetValue().IsNumber())
		prx.ProxyPort = m_edit2->GetValue();
	else
	{
		wxMessageBox("Proxy port must be numeric.",APP_NAME,wxICON_ERROR);
		m_edit2->SetSelection(-1,-1);
		return;
	}
	proxy->SaveProxy(&prx);
	EndModal(wxID_OK);
	return;
}

void SGProxyDlg::OnClose()
{
	delete proxy;
	EndModal(wxID_CANCEL);
	return;
}

void SGProxyDlg::OnProxy()
{
	m_edit1->Enable(m_check1->GetValue());
	m_edit2->Enable(m_check1->GetValue());
	return;
}

//--------------------------------------------------------------
//	SGProxy: a class to handle the config file
//--------------------------------------------------------------

SGProxy::SGProxy()
{
#ifdef _SLACKGRADE_EMBEDDED_
	if(wxFileExists("../util/slackgrade/share/" + wxString(PROXY_FILE)))
		pfile = "../util/slackgrade/share/" + wxString(PROXY_FILE);
#else
	if(wxFileExists("../share/" + wxString(HOST_SHARE) + wxString(PROXY_FILE)))
		pfile = "../share/" + wxString(HOST_SHARE) + wxString(PROXY_FILE);
#endif
	else if(wxFileExists("/usr/local/share/" + wxString(HOST_SHARE) + wxString(PROXY_FILE)))
		pfile = "/usr/local/share/" + wxString(HOST_SHARE) + wxString(PROXY_FILE);
	return;
}

bool SGProxy::LoadProxy(SGPROXY* proxy)
{
	wxFile file;
	wxString contents;
	wxString buffer;
	if(!::wxFileExists(pfile))
		return FALSE;
	if(file.Open(pfile,wxFile::read))
	{
		file.Read(buffer.GetWriteBuf(file.Length()),file.Length());
		file.Close();
	}
	else
		return FALSE;
	proxy->UseProxy = (bool)atoi(buffer.BeforeFirst('\n'));
	proxy->ProxySvr = buffer.AfterFirst('\n').BeforeLast('\n');
	proxy->ProxyPort = buffer.AfterLast('\n');
	return TRUE;
}

bool SGProxy::SaveProxy(SGPROXY* proxy)
{
	wxFile file;
	wxString buffer;
	::wxRemoveFile(pfile);
	if(file.Open(pfile,wxFile::write))
	{
		buffer = wxString::Format("%d",proxy->UseProxy) + "\n" +
				proxy->ProxySvr + "\n" + proxy->ProxyPort;
		file.Write(buffer.c_str(),buffer.Length());
		file.Close();
		return TRUE;
	}
	else
		return FALSE;	
}
