/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/
 
// wxWidgets
#include <wx/file.h>
#include <wx/tokenzr.h>
#include <wx/xrc/xmlres.h>

// own
#include "common.h"
#include "sgblist.h"

//--------------------------------------------------------------
//	SGBlacklistDlg: the configurations dialog class
//--------------------------------------------------------------

BEGIN_EVENT_TABLE(SGBlacklistDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),SGBlacklistDlg::OnOK)
	EVT_BUTTON(XRCID("IDC_BUTTON_CANCEL"),SGBlacklistDlg::OnClose)
	EVT_BUTTON(XRCID("IDC_BUTTON_ADD"),SGBlacklistDlg::OnAdd)
	EVT_BUTTON(XRCID("IDC_BUTTON_RMV"),SGBlacklistDlg::OnRemove)
	EVT_BUTTON(XRCID("IDC_BUTTON_CLR"),SGBlacklistDlg::OnClear)
	EVT_CLOSE(SGBlacklistDlg::OnClose)
END_EVENT_TABLE()

SGBlacklistDlg::SGBlacklistDlg()
{
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_BLACKLIST");
	Centre();
	// controls initialization (from resource)
	m_button1 = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_button2 = XRCCTRL(*this, "IDC_BUTTON_CANCEL", wxButton);
	m_button3 = XRCCTRL(*this, "IDC_BUTTON_ADD", wxButton);
	m_button4 = XRCCTRL(*this, "IDC_BUTTON_RMV", wxButton);
	m_button5 = XRCCTRL(*this, "IDC_BUTTON_CLR", wxButton);
	m_list1   = XRCCTRL(*this, "IDC_LIST1", wxListBox);
	m_edit1 = XRCCTRL(*this, "IDC_EDIT1", wxTextCtrl);
	// load configurations
	blist = new SGBlacklist();
	blist->LoadBlacklist(&bl);
	
	if(blist->LoadBlacklist(&bl))
		m_list1->Set(bl);
	return;
}

void SGBlacklistDlg::OnAdd()
{
	m_list1->Append(m_edit1->GetValue());
	m_edit1->SetValue("");
	return;
}

void SGBlacklistDlg::OnRemove()
{
	m_list1->Delete(m_list1->GetSelection());
	return;
}

void SGBlacklistDlg::OnOK()
{
	blist->SaveBlacklist(m_list1);
	EndModal(wxID_OK);
	return;
}

void SGBlacklistDlg::OnClear()
{
	m_list1->Clear();
	return;
}

void SGBlacklistDlg::OnClose()
{
	delete blist;
	EndModal(wxID_CANCEL);
	return;
}

//--------------------------------------------------------------
//	SGBlacklist: a class to handle the config file
//--------------------------------------------------------------

SGBlacklist::SGBlacklist()
{
#ifdef _SLACKGRADE_EMBEDDED_
	if(wxFileExists("../util/slackgrade/share/" + wxString(BLIST_FILE)))
		bfile = "../util/slackgrade/share/" + wxString(BLIST_FILE);
#else
	if(wxFileExists("../share/" + wxString(HOST_SHARE) + wxString(BLIST_FILE)))
		bfile = "../share/" + wxString(HOST_SHARE) + wxString(BLIST_FILE);
#endif
	else if(wxFileExists("/usr/local/share/" + wxString(HOST_SHARE) + wxString(BLIST_FILE)))
		bfile = "/usr/local/share/" + wxString(HOST_SHARE) + wxString(BLIST_FILE);
	LoadBlacklist(&bl);
	return;
}

bool SGBlacklist::LoadBlacklist(wxArrayString* list)
{
	wxFile file;
	wxString buffer;
	if(!::wxFileExists(bfile))
		return FALSE;
	if(file.Open(bfile,wxFile::read))
	{
		file.Read(buffer.GetWriteBuf(file.Length()),file.Length());
		file.Close();
		if(buffer=="")
			return FALSE;
		list->Clear();
		
		/*
		// for some unknown reason, the following code causes
		// strange things when the function returns.
		// notice that this is the same code than in
		// SvrConf::GetNames() - see svrconf.cpp
		// the difference is that it works!
		wxStringTokenizer tokens(buffer,"\n");
		while(tokens.HasMoreTokens())
		{
			buffer = tokens.GetNextToken();
			list->Add(buffer);
		}
		// this way, the following solution was implemented:
		*/
		
		for( ; ; )
		{
			list->Add(buffer.BeforeFirst('\n'));
			if(!buffer.Contains("\n"))
				break;
			buffer = buffer.AfterFirst('\n');
		}
		
		return TRUE;
	}
	else
		return FALSE;
}

bool SGBlacklist::SaveBlacklist(wxListBox* blacklist)
{
	wxFile file;
	wxString buffer;
	::wxRemoveFile(bfile);
	file.Create(bfile);
	if(file.Open(bfile,wxFile::write))
	{
		if(blacklist->GetCount()>0)
		{
			for(int i=0;i<blacklist->GetCount();i++)
				buffer += blacklist->GetString(i) + "\n";
			buffer = buffer.BeforeLast('\n');
		}
		else
		{
			buffer = "";
		}
		file.Write(buffer.c_str(),buffer.Length());
		file.Close();
		LoadBlacklist(&bl);
		return TRUE;
	}
	else
		return FALSE;	
}

bool SGBlacklist::IsInBlacklist(wxString name,wxArrayString list)
{
	if(list.Count()>0)
	{
		for(unsigned int i=0;i<list.Count();i++)
		{
			if(name.Contains(list.Item(i)))
				return TRUE;
		}
	}
	return FALSE;
}
