/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

// declares
#include <wx/xrc/xmlres.h>
#include "common.h"
#include "sgabout.h"

BEGIN_EVENT_TABLE(SGAboutDlg,wxDialog)
	// event maps
	EVT_BUTTON(XRCID("IDC_BUTTON_OK"),SGAboutDlg::OnOK)
	EVT_CLOSE(SGAboutDlg::OnClose)
END_EVENT_TABLE()

SGAboutDlg::SGAboutDlg()
{
	wxString page;
	::wxInitAllImageHandlers();
	wxXmlResource::Get()->LoadDialog(this, NULL, "DLG_ABOUTBOX");
	Centre();
	// controls initialization (from resource)
	m_btnok = XRCCTRL(*this, "IDC_BUTTON_OK", wxButton);
	m_html = XRCCTRL(*this, "IDC_HTML_CTRL", wxHtmlWindow);
#ifdef _SLACKGRADE_EMBEDDED_
	if(wxFileExists("../util/slackgrade/share/" + wxString(ABOUT_FILE)))
		page = "../util/slackgrade/share/" + wxString(ABOUT_FILE);
#else
	if(wxFileExists("../share/" + wxString(HOST_SHARE) + wxString(ABOUT_FILE)))
		page = "../share/" + wxString(HOST_SHARE) + wxString(ABOUT_FILE);
#endif
	else if(wxFileExists("/usr/local/share/" + wxString(HOST_SHARE) + wxString(ABOUT_FILE)))
		page = "/usr/local/share/" + wxString(HOST_SHARE) + wxString(ABOUT_FILE);
	m_html->LoadPage(page);
	return;
}

void SGAboutDlg::OnOK()
{
	EndModal(0);
	return;
}

void SGAboutDlg::OnClose()
{
	delete this;
	return;
}
