/****************************************************************************
 *									    *
 *   Copyright (C) 2004 by Marcelo A. B. Slomp				    *
 *   mslomp@linuxmail.org						    *
 *									    *
 *   SlackGrade is free software; you can redistribute it and/or modify	    *
 *   it under the terms of the GNU General Public License as published by   *
 *   the Free Software Foundation; either version 2 of the License, or	    *
 *   (at your option) any later version.				    *
 * 									    *
 *   This program is distributed in the hope that it will be useful,	    *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of	    *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	    *
 *   GNU General Public License for more details.			    *
 *									    *
 *   You should have received a copy of the GNU General Public License	    *
 *   along with this program; if not, write to the			    *
 *   Free Software Foundation, Inc.,					    *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.		    *
 *									    *
 *   SlackGrade is a member of XPKGTOOL project			    *
 *    XPKGTOOL: A Slackware Package Manager for X			    *
 *   distributed under GPL license and available at			    *
 *   http://xpkgtool.sourceforge.net					    *
 *									    *
 ****************************************************************************/

#include <wx/xrc/xmlres.h>
#include "common.h"
#include "main.h"
#include "slackgrade.h"

// ::OnInit - loads and shows the main dialog
bool SlackGradeApp::OnInit()
{
	wxString ResourceFile;
	wxHandleFatalExceptions(TRUE);
	wxXmlResource::Get()->InitAllHandlers();

	SlackGradeDlg *m_main = new SlackGradeDlg();
	m_main->Centre();
	m_main->Show(TRUE);
	return(TRUE);
}

// ::OnFatalException - alert user if a segfault occurs
void SlackGradeApp::OnFatalException()
{
	wxMessageBox("Segmentation fault!!!",APP_NAME,wxOK | wxICON_ERROR);
	return;
}
