/* $Id: GCUshell.c,v 1.1 1997/09/30 07:56:14 imil Exp imil $
 */

/*****************************************************************************/
/*                                                                           */
/*    GCUshell, some pretty functions based on ncurses                       */
/*    Copyright (C) 1997  iMil                                               */
/*                                                                           */
/*    This program is free software; you can redistribute it and/or modify   */
/*    it under the terms of the GNU General Public License as published by   */
/*    the Free Software Foundation; either version 2 of the License, or      */
/*    (at your option) any later version.                                    */
/*                                                                           */
/*    This program is distributed in the hope that it will be useful,        */
/*    but WITHOUT ANY WARRANTY; without even the implied warranty of         */
/*    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the          */
/*    GNU General Public License for more details.                           */
/*                                                                           */
/*    You should have received a copy of the GNU General Public License      */
/*    along with this program; if not, write to the Free Software            */
/*    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.              */
/*                                                                           */
/*    You can reach me at :                                                  */
/*                          emile.heitor@inforoute.cgs.fr                    */
/*                          imil@chez.com                                    */
/*                                                                           */
/*    Or visit my Web site at :                                              */
/*                              http://www.chez.com/imil                     */
/*                                                                           */
/*****************************************************************************/


#include "GCUshell.h"

/* ------------------------------------------------------------------------- */
/* - Look'n'Feel ----------------------------------------------------------- */
/* ------------------------------------------------------------------------- */

void gotoxy(int x, int y)
{
  printf("\033[%d;%dH",y,x);
}

void clrscr()
{
  printf("\033[2J");
}

char *space(int nbspc)
{
  int i;
  char *spc;
  
  spc=(char *)malloc(sizeof(char)*(nbspc+1));

  for (i=0; i<nbspc; i++)
    spc[i]=' ';

  spc[i]='\0';

  return(spc);
}

char *repstr( char str, int nb )
{
  char *ret;
  int i;

  ret=(char *)malloc(sizeof(char)*(nb+1));
  
  for (i=0; i<nb; i++)
    ret[i]=str;
  
  ret[nb]='\0';

  return(ret);
}

void textcolor( int mode, int fore, int back )
{
  printf("\033[%d;%d;%dm", mode, fore, back);
}

void conio()
{
  initscr(); cbreak(); noecho();
  nonl();
  intrflush(stdscr, FALSE);
  keypad(stdscr, TRUE);
}

int selbar( int fgsel, 
	    int bgsel,
	    int xpos,
	    int ypos,
	    char *align,    /* Alignement left, center ou right */
	    char *prop,
	    int nbitems,
	    char **items)

{
  int selitem;
  int i, key, idx=0, size=0 , middle, offset=0, tmpsize;
  char select[80];

  if (prop[0]=='a') size=80;
  else
    {
      for ( i=0 ; i<nbitems ; i++ )
	{
	  tmpsize=strlen(items[i]);
	  if ( size < tmpsize ) size=tmpsize;
	}
    }

  while (1)
    {      
      for ( i=0 ; i<nbitems ; i++ ) 
	{
	  if ( i == idx ) 
	    textcolor( 0, fgsel, bgsel );
	  else
	    textcolor( 0, 37, 40 );
	  gotoxy(xpos, ypos+(i*2));

	  switch (align[0])
	    {
	    case 'l':
	      strcpy(select, items[i]);
	      if ((i==idx) && (prop[0]=='a')) {
		offset=3;
		strcat(select, " <-");
	      }
	      strcat(select, space(size - strlen(items[i])-offset));
	      offset=0;
	      printf("%s", select); 
	      break;
	    case 'r':
	      if ((i==idx) && (prop[0]=='a')) {
		strcpy(select, space(size - strlen(items[i])-3));
		strcat(select, "-> ");
	      }
	      else strcpy(select, space(size - strlen(items[i])));
	      strcat(select, items[i]);
	      printf("%s", select);
	      break;
	    case 'c':
	      middle=((size-(strlen(items[i])))/2);
	      if ((i==idx) && (prop[0]=='a')) {
		strcpy(select, space(middle-3));
		strcat(select, "-> ");
		strcat(select, items[i]);
		strcat(select, " <-");
		strcat(select, space(middle-3));
	      }
	      else {
		strcpy(select, space(middle));
		strcat(select, items[i]);
		strcat(select, space(middle));
	      }

	      printf("%s", select);

	      break;
	    }
	}
      gotoxy(80, 25);
      conio();
      key=getch();

      switch (key) 
	{
	case KEY_DOWN:
	  if ( idx < (nbitems-1) ) idx++;
	  else idx=0;
	  break;
	case KEY_UP:
	  if ( idx == 0 ) idx=(nbitems-1) ;
	  else idx--;
	  break;
	case 13:
	  endwin();
	  textcolor(0, B_BLACK, F_WHITE);
	  return(idx);
	case 27:
	  endwin();
	  textcolor(0, B_BLACK, F_WHITE);
	  return(-1);
	}
      endwin();
    }
}

int align( char *item, char *pos )
{
  int middle, size=80;

  switch(pos[0])
    {
    case 'l': printf("%s%s", item,
		     space(size - strlen(item)));
    break;
    
    case 'r': printf("%s%s", space(size - strlen(item)),
		     item);
    break;
    
    case 'c': 
      middle=(size-(strlen(item)))/2;
      printf("%s%s%s", space(middle), item, space(middle));
     break;
    }
}

int menubar( int fg, int bg, char *pos, int nb, char **items)

{
  int i, key, allsize=0;

  textcolor( 0, fg, bg);
  
  switch (pos[0])
    {
    case 't' :
      gotoxy(1,1);
      printf("%s", space(80));
      gotoxy(1,1); break;
    case 'b' :
      gotoxy(1,25);
      printf("%s", space(80));
      gotoxy(1,25); break;
    }

  for (i=0; (i<nb) && (i<MENUMAX); i++)
    {
      printf(" F%d %s |", i, items[i]);
      allsize+=strlen(items[i]);
    }

  textcolor( 0, F_WHITE, B_BLACK);
  gotoxy(80,25);

  while(key!=F10)
    {
      if (key!=F10) {
	if ((key >= 265) && ( key <= 273 ))
			     return(key-F1);
	return (key);
      }
    }
}

/* ------------------------------------------------------------------------ */
/* - File Manipulation ---------------------------------------------------- */
/* ------------------------------------------------------------------------ */

int freadline(FILE *fp, char **line)
{
  char tmp,name[80];
  int nb, i=0;

  *line=NULL;

  while(!*line)
    {
      nb=fread(&tmp, 1, 1, fp);
      if (!nb) return(0);
      
      if (tmp != '\n') {
	name[i]=tmp;
	i++;
      }
      else {
	if ((name[0]!='#') && (i>0) && (name[0]!=' ')) {
	  name[i]='\0';
	  *line=strdup(name);
	}
	else i=0;
      }
    }
}
