// ----------------------------------------------------------------------------
// Filename:    MainWidget.h
// $Date: 2000/09/22 15:00:38 $
// $Revision: 1.12 $
// ----------------------------------------------------------------------------

#ifndef MAINWIDGET_H
#define MAINWIDGET_H

#include <ktmainwindow.h>
#include <qlabel.h>

#include "KTimeclock.h"

// ----------------------------------------------------------------------------
// Version information.
// ----------------------------------------------------------------------------
#define KTIMECLOCK_VERSION "KTimeclock v0.0.6"

// ----------------------------------------------------------------------------
// Toolbar and menu item definitions.
// ----------------------------------------------------------------------------
const int MENU_NEWPROJECT    = 10;
const int MENU_NEWSUBPROJECT = 11;
const int MENU_NEWTASK       = 12;
const int MENU_QUIT          = 13;
const int MENU_EDIT          = 20;
const int MENU_DELETE        = 21;
const int MENU_CLEAR         = 22;
const int MENU_CLEAR_ALL     = 23;
const int MENU_PREFERENCES   = 24;
const int MENU_STARTTIMER    = 30;
const int MENU_STOPTIMER     = 31;
const int MENU_CONTENTS      = 40;
const int MENU_ABOUT         = 41;

/**
 * Main display widget for the KTimeclock application.  This widget will create
 * the top level window and initialize the menus/toolbars/statusbars that are
 * required.
 */
class KTimeclockMainWidget : public KTMainWindow
{
    Q_OBJECT
public:
    /**
     * Constructor.
     *
     * @param   parent  Handle to parent widget.
     * @param   name    Name of this widget.
     */
    KTimeclockMainWidget (QWidget* parent=NULL, const char* name=NULL);

    /**
     * Destructor.
     */
    ~KTimeclockMainWidget ();

private:
void _read_geometry ();
void _write_geometry ();
    /**
     * Handle to the KTimeclock widget; it'll hold the tree view and provide
     * most of the core functionality we're going to use.
     */
    KTimeclock* ktimeclock;

    /**
     * Handle to our menu bar.
     */
    KMenuBar* menu;

    /**
     * Handle to our toolbar.
     */
    KToolBar* toolbar;

    /**
     * Handle to our statusbar.
     */
    KStatusBar* statusbar;

    /**
     * Handle to the "timer state" field in the statusbar.
     */
    QLabel* status_state;

    /**
     * Handle to the "selected task" field in the statusbar.
     */
    QLabel* status_selected;

protected:
    /**
     * @internal
     * Initializes the menu with all of the menu items, sets up their keyboard
     * accelerators, and connects all of the menu items to their appropriate
     * slots.
     */
    void initMenu ();

    /**
     * @internal
     * Initializes the toolbar with all of the toolbar items and connects them
     * to their appropriate slots.
     */
    void initToolbar ();

    /**
     * @internal
     * Initializes the status bar, sets its size, and connects it to the
     * appropriate signals which it will display the status of.
     */
    void initStatusbar ();

signals:

public slots:
    /**
     * Displays the About box for the application.
     */
    void about ();

    /**
     * Displays the on-line help for the application.
     */
    void help ();

    /**
     * En/disables menu and toolbar items whenever the timer is started.
     */
    void startTimer ();

    /**
     * En/disables menu and toolbar items whenever the timer is stopped.
     */
    void stopTimer ();

    /**
     * Sets the current state into the status bar whenever it changes.
     */
    void timerState (QString&);
    
    /**
     * Sets the currently selected item into the status bar whenever it
     * changes.
     */
    void itemSelected (QString&);

    /**
     * Quits the application, making sure to properly save out the data file.
     */
    void quit ();
};

#endif
