// ----------------------------------------------------------------------------
// Filename:    ItemDialogData.cpp
// $Date: 2000/02/08 00:50:52 $
// $Revision: 1.2 $
// ----------------------------------------------------------------------------

#include "ItemDialogData.h"

#define Inherited QDialog

#include <qlabel.h>
#include <qpushbt.h>
#include <qlined.h>

// ----------------------------------------------------------------------------
// Function:    ItemDialogData (QWidget* parent, const char* name)
// Parameters:  parent  - Handle to the parent widget
//              name    - Name of the widget
// ----------------------------------------------------------------------------
// Constructor.
// ----------------------------------------------------------------------------
ItemDialogData::ItemDialogData( QWidget* parent, const char* name )
	: Inherited( parent, name, TRUE, 0 )
{
	QLabel* lblName;
	lblName = new QLabel( this, "lblName" );
	lblName->setGeometry( 10, 10, 100, 30 );
	lblName->setMinimumSize( 10, 10 );
	lblName->setMaximumSize( 32767, 32767 );
	lblName->setText( "Name:" );
	lblName->setAlignment( 289 );
	lblName->setMargin( -1 );

	txtName = new QLineEdit( this, "txtName" );
	txtName->setGeometry( 120, 10, 310, 30 );
	txtName->setMinimumSize( 10, 10 );
	txtName->setMaximumSize( 32767, 32767 );
	txtName->setText( "" );
	txtName->setMaxLength( 128 );
	txtName->setEchoMode( QLineEdit::Normal );
	txtName->setFrame( TRUE );
    txtName->setFocus();

	QLabel* lblTimeSpent;
	lblTimeSpent = new QLabel( this, "lblTimeSpent" );
	lblTimeSpent->setGeometry( 10, 50, 100, 30 );
	lblTimeSpent->setMinimumSize( 10, 10 );
	lblTimeSpent->setMaximumSize( 32767, 32767 );
	lblTimeSpent->setText( "Total time spent:" );
	lblTimeSpent->setAlignment( 289 );
	lblTimeSpent->setMargin( -1 );

    spinHours = new QSpinBox( this, "spinHours" );
    spinHours->setGeometry( 120, 50, 50, 30 );
    spinHours->setFixedSize( 50, 30 );
    spinHours->setRange( 0, 999 );

    spinMinutes = new QSpinBox( this, "spinMinutes" );
    spinMinutes->setGeometry( 180, 50, 50, 30 );
    spinMinutes->setFixedSize( 50, 30 );
    spinMinutes->setRange( 0, 59 );

    spinSeconds = new QSpinBox( this, "spinSeconds" );
    spinSeconds->setGeometry( 240, 50, 50, 30 );
    spinSeconds->setFixedSize( 50, 30 );
    spinSeconds->setRange( 0, 59 );

	QPushButton* pbOk;
	pbOk = new QPushButton( this, "pbOk" );
	pbOk->setGeometry( 120, 90, 100, 30 );
	pbOk->setMinimumSize( 10, 10 );
	pbOk->setMaximumSize( 32767, 32767 );
	pbOk->setText( "Ok" );
	pbOk->setAutoRepeat( FALSE );
	pbOk->setAutoResize( FALSE );
	pbOk->setDefault( TRUE );
    connect( pbOk, SIGNAL(clicked()), this, SLOT(accept()) );

	QPushButton* pbCancel;
	pbCancel = new QPushButton( this, "pbCancel" );
	pbCancel->setGeometry( 240, 90, 100, 30 );
	pbCancel->setMinimumSize( 10, 10 );
	pbCancel->setMaximumSize( 32767, 32767 );
	pbCancel->setText( "Cancel" );
	pbCancel->setAutoRepeat( FALSE );
	pbCancel->setAutoResize( FALSE );
    connect( pbCancel, SIGNAL(clicked()), this, SLOT(reject()) );

	this->resize( 450,140 );
    this->setFixedSize( 450, 140 );
}


// ----------------------------------------------------------------------------
// Function:    ~ItemDialogData()
// ----------------------------------------------------------------------------
// Destructor.
// ----------------------------------------------------------------------------
ItemDialogData::~ItemDialogData()
{
}

// ----------------------------------------------------------------------------
// Function:    enableTimeSpent (bool enabled)
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void ItemDialogData::enableTimeSpent( bool )
{
}

// ----------------------------------------------------------------------------
// Function:    setName (const char* name)
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void ItemDialogData::setName( const char* )
{
}

// ----------------------------------------------------------------------------
// Function:    setTimeSpent (int seconds)
// ----------------------------------------------------------------------------
// Stub function.
// ----------------------------------------------------------------------------
void ItemDialogData::setTimeSpent( int )
{
}

// ----------------------------------------------------------------------------
// Function:    name ()
// Returns:     const char*
// ----------------------------------------------------------------------------
// Stub function.  Always returns NULL.
// ----------------------------------------------------------------------------
const char* ItemDialogData::name()
{
    return NULL;
}

// ----------------------------------------------------------------------------
// Function:    timeSpent ()
// Returns:     int
// ----------------------------------------------------------------------------
// Stub function.  Always returns zero.
// ----------------------------------------------------------------------------
int ItemDialogData::timeSpent()
{
    return 0;
}
