// ----------------------------------------------------------------------------
// Filename:    ItemDialog.h
// $Date: 1998/11/16 07:28:48 $
// $Revision: 1.1 $
// ----------------------------------------------------------------------------

#ifndef ItemDialog_included
#define ItemDialog_included

#include "ItemDialogData.h"

/**
 * New/Edit project/sub-project/task implementation class.
 *
 * This class implements all of the functionality provided by the new/edit
 * dialogs.  Refer to the @ref ItemDialogData class for a description of the
 * member functions that this class implements.
 *
 * @author  Graham TerMarsch (gtermars@home.com)
 * @version $Revision: 1.1 $
 * @see     ItemDialogData
 */
class ItemDialog : public ItemDialogData
{
    Q_OBJECT

public:
    /**
     * Constructor
     *
     * @param   parent  Handle to parent widget
     * @param   name    Name of this widget
     */
    ItemDialog( QWidget* parent = NULL, const char* name = NULL );

    /**
     * Destructor
     */
    virtual ~ItemDialog();
    virtual void setName( const char* name );
    virtual void setTimeSpent( int seconds );
    virtual const char* name();
    virtual int timeSpent();
    virtual void enableTimeSpent( bool enabled );

};
#endif // ItemDialog_included
