#include <stdlib.h>
#include <kapp.h>

#include "kcli.moc"
#include "kprocesswidget.moc"



//
// Create and display our Kcli.
//

KApplication* app;

int main( int argc, char **argv )
{
    app = new KApplication( argc, argv, "kcli" );

    KConfig* config = app->getConfig();
    config->setGroup("General");
    int len = config->readNumEntry("HistoryLength");
    if (len == 0) {
        config->writeEntry("HistoryLength", 10);
	config->sync();
	len = 10;
    }

    int x = config->readNumEntry("XPosition");
    int y = config->readNumEntry("YPosition");

    Kcli* w = new Kcli(0,0,len);
    w->setGeometry(x, y, 475, 68);

    // Don't allow it to be maximized
    w->setMaximumSize(475, 68);
    w->setMinimumSize(475, 68);
    
    app->setMainWidget(w );
    w->show();

    return app->exec();
}

