// Kcli 0.9 based on Acli by Brian Cooper
// (c) Andrew Lagodzinski, 1997
//
// Acli / AssSh  0.6
//
// (c) Brian Cooper, 1996
// for the KDE project
//

#include <kprocess.h>

#include <qdialog.h>
#include <qevent.h>

// Standard Qt widgets

#include <qcombo.h>
#include <qframe.h>
#include <qlabel.h>
#include <qlined.h>
#include <qpushbt.h>
#include "kprocesswidget.hpp"

// For key Accelerator id's

#define UPKEY                  13
#define DOWNKEY                15
#define HISTORYLENGTH          10

class Kcli : public QDialog
{
    Q_OBJECT
public:
    Kcli( QWidget *parent=0, const char *name=0, int histlen = 10 );

public slots:
    void	details();
    void	lineEditTextChanged();
    void        lineEditCommandEntered( );
    void        help();
    void        about();
    void        browse();
    void        cmdHistory( int );
    void	slotQuit();

protected:
    void closeEvent(QCloseEvent *re);

private:

    void execute(const char* cmd);

    KProcess proc;
    QLineEdit* le;
    KProcessWidget* m_verboseOutput;
    QLabel*    msg;
    QString*   history; 	
    QPushButton* verboseButton;
    int  	m_histlen;	
    int        h;
    int        m_verbose;
};
