// Kcli 0.9 based on Acli by Brian Cooper
// (c) Andrew Lagodzinski, 1997
//
// Acli / AssSh  0.6
//
// (c) Brian Cooper, 1996
// for the KDE project
//


#include <stdlib.h>

// Standard Qt widgets
#include <qmsgbox.h>
#include <qaccel.h>
#include <qfiledlg.h>

// Standard KDE widgets
#include <kapp.h>
#include <kprocess.h>
#include <kdebug.h>
#include <kseparator.h>
#include <kmsgbox.h>

#include "kcli.hpp"

extern KApplication* app;



Kcli::Kcli( QWidget *parent, const char *name, int histlen )
    : QDialog( parent, name ),
      m_histlen(histlen),
      m_verbose(0)
{
    // Set the window caption/title
    setCaption( "Kcli 0.9" );

    // Make the browse button, fer when you don't know the
    // exact name of that killer KDE app...
  
    QPushButton *browseButton = new QPushButton( this, "browseButton" );
    browseButton->setText( "Browse" );
    browseButton->setGeometry( 405, 6, 60,22 );
    connect( browseButton, SIGNAL(clicked()), SLOT(browse()) );
    
    // Make a help button to launch kdehelp.
  
    QPushButton *helpButton = new QPushButton( this, "helpButton" );
    helpButton->setText( "Help" );
    helpButton->setGeometry( 405, 40, 60,22 );
    connect( helpButton, SIGNAL(clicked()), SLOT(help()) );

    verboseButton = new QPushButton( this, "verboseButton" );
    verboseButton->setText( "Verbose" );
    verboseButton->setGeometry( 10, 40, 70,22 );
    connect( verboseButton, SIGNAL(clicked()), SLOT(details()) );

    //
    // Create a line edit
    //
    le = new QLineEdit( this, "lineEdit" );
    le->setGeometry( 10, 6, 385, 22 );
    connect( le, SIGNAL(textChanged(const char *)),
	         SLOT(lineEditTextChanged()) );
    connect( le, SIGNAL(returnPressed()),
                 SLOT(lineEditCommandEntered()) );
    
    // Create a message label
    // The message is updated when buttons are clicked etc.

    msg = new QLabel( this, "message" );
    msg->setFrameStyle( QFrame::Panel | QFrame::Sunken );
    msg->setAlignment( AlignCenter );
    msg->setGeometry( 96,40, 299,22 );
    msg->setFont( QFont("times",12,QFont::Bold) );
    msg->setText( "Kcli 0.9 Ready!" );

    // Create a horizontal line above the message area
    KSeparator* separator = new KSeparator(this, "seperatorLine");
    separator->setGeometry( 5, 32, 465, 4 );

    m_verboseOutput = new KProcessWidget( this, "multiLineEdit" );
    m_verboseOutput->setGeometry( 5,70, 465, 90 );


    // Install up/down accelerator for command history
   
     QAccel *a = new QAccel( this );       
     a->insertItem(Key_Up, UPKEY);
     a->insertItem(Key_Down, DOWNKEY);
     a->connectItem( a->insertItem(ALT + Key_H), this, SLOT(about()) );   
     a->connectItem( a->insertItem(ALT + Key_Q), this, SLOT(slotQuit()) );   
     connect( a, SIGNAL(activated(int)), SLOT(cmdHistory(int)) );

     // Create the history array.
     history = new QString[histlen];
     h=0;
     

     // 
     //  Give the line edit the focus
     //
     le->setFocus();

}

Kcli::~Kcli()
{
  ;
}

void Kcli::details()
{
  QSize mySize = size();
  int height = mySize.height();
  if (m_verbose) {
    height -= 100;
    verboseButton->setText( "Verbose" );
    m_verbose = 0;
  }  else {
    height += 100;
    verboseButton->setText( "Terse" );
    m_verbose = 1;
  }
  mySize.setHeight(height);
  setMaximumSize(mySize);
  setMinimumSize(mySize);
  resize(mySize);

  //   msg->setText( "Verbose not completely implemented" );

}


void Kcli::lineEditTextChanged()
{
    msg->setText( "" );
}


void Kcli::lineEditCommandEntered()
{
    history[0] = le->text();
    for(int i= m_histlen-1; i>0 ;i-- ){
      history[i] = history[i-1];
    }
    h=0;
    
    QString cmd(le->text());

    execute(cmd.data());

    le->setText("");
    msg->setText( "Ready!" );
}

void Kcli::about()
{
    QString str;
    str += "\nSupport KDE\n";
    str +="http://www.kde.org\n";
    str += "\nKcli 0.9\n";
    str += "by Andrew Lagodzinski\nandrew@lago.com\n";
    KMsgBox::message(this, "About Kcli", str, 0 );
}


void Kcli::help()
{
    KApplication::getKApplication()->invokeHTMLHelp("kcli/kcli.html", "");
}



void Kcli::browse()
{
	QString s( QFileDialog::getOpenFileName() );
	if ( s.isNull() )
		return;
	le->setText(s);
}

void Kcli::cmdHistory( int updown )
{

    if( (updown==UPKEY) && (h<(HISTORYLENGTH - 1)) ){
      h++;
      le->setText( history[h] );
      msg->setText( "History Up" );
      return;
    }
    if( (updown==DOWNKEY) && (h>0) ){
      h--;
      le->setText( history[h] );
      msg->setText( "History Down");
      return;
    }
}

void Kcli::slotQuit( )
{

    // Save the window position
    KConfig* config = app->getConfig();
    config->setGroup("General");
    config->writeEntry("XPosition", x());
    config->writeEntry("YPosition", y());
    config->sync();

    app->quit();
}

void Kcli::closeEvent(QCloseEvent*)
{
    slotQuit();
}

void Kcli::execute(const char* cmd){
  KProcess* myProc = new KProcess;

  char* shell = NULL;
  if (!shell){
    if (getenv("SHELL"))
      shell = qstrdup(getenv("SHELL"));
    else
      shell = "/bin/sh";
  }

  QObject::connect( myProc, SIGNAL(receivedStdout(KProcess *, char *, int)),
	         m_verboseOutput, SLOT(receivedStdout(KProcess *, char *, int)));

  m_verboseOutput->connect( myProc, SIGNAL(receivedStderr(KProcess *, char *, int)),
         SLOT(receivedStderr(KProcess*, char *, int)));


  myProc->clearArguments();
  myProc->setExecutable(shell);
  *myProc << "-c" << cmd;
  myProc->start(KProcess::DontCare, KProcess::AllOutput);

}


void KProcessWidget::receivedStdout(KProcess *proc, char *buffer, int buflen)
{
  append(buffer);
}

void KProcessWidget::receivedStderr(KProcess *proc, char *buffer, int buflen)
{
  append(buffer);
}

