#!/usr/bin/perl -w
require ("flush.pl");

$homedirectory = $ENV{HOME};
printflush (STDOUT,"Starting with installation\n");

#open file "entries" for reading the parameters from kAppWizard and put it in a hash
open (PROCESSLIST,$homedirectory . "/.kdevelop/entries") || die "kann Datei nicht ffnen: $!";
while ( defined ($name = <PROCESSLIST> )) {
    chomp ($name);
    $process = <PROCESSLIST>;
    chomp ($process);
    $processes{$name} = $process;
}
close (PROCESSLIST);

$nameLittle = $processes{NAME};
$nameLittle =~ tr/A-Z/a-z/;
$nameBig = $processes{NAME};
$nameBig =~ tr/a-z/A-Z/;
$name =  $processes{NAME};

$overDirectory = $processes{DIRECTORY} . $nameLittle;
$underDirectory = $processes{DIRECTORY} . $nameLittle . "/" . $nameLittle;

#create the projectdirectory 
printflush (STDOUT, "change directory...\n");
chdir ($processes{DIRECTORY});
printflush (STDOUT,"make projectdirectory...\n"); 
mkdir("$nameLittle",0777);
$kdedirectory = $ENV{KDEDIR};
$date = `date`;
@time = localtime();
$year = 1900 + $time[5];
printflush (STDOUT,"chance directory...\n");
chdir ($overDirectory);

#copy the file in the projectdirectory and unpacked it
if ($processes{APPLICATION} eq "standard") {
  
  printflush (STDOUT,"copy standardapp to projectdirectory...\n");
  chdir ($kdedirectory);
  system ("cp share/apps/kdevelop/templates/normal.tar.gz $overDirectory");
  chdir ($overDirectory);
  printflush (STDOUT,"unzip file...\n");
  system ("gunzip normal.tar.gz");
  printflush (STDOUT,"untar file...\n");
  system ("tar xf normal.tar");
  unlink "normal.tar";
}
elsif ($processes{APPLICATION} eq "mini") {
    printflush (STDOUT,"copy miniapp to projectdirectory...\n");
    chdir ($kdedirectory);
  system ("cp share/apps/kdevelop/templates/mini.tar.gz $overDirectory");
  chdir ($overDirectory);
  printflush (STDOUT,"unzip file...\n");
  system ("gunzip mini.tar.gz");
  printflush (STDOUT,"untar file...\n");
  system ("tar xf mini.tar");
  unlink "mini.tar";
}

#renamed the directory
printflush (STDOUT,"change files...\n");
chdir ($overDirectory);
rename ("skel", $nameLittle);

#create the templatedirectory
chdir ($underDirectory);
mkdir ("templates",0777);

#copying the templates in the templatedirectoy
if ($processes{CPP} eq "no" and $processes{HEADER} eq "no") {}
else {
  if ($processes{HEADER} eq "yes") {
    $directory = $homedirectory . "/.kdevelop/header";
    $targetdirectory = $underDirectory . "/templates";
    system ("cp $directory $targetdirectory");
    chdir ($targetdirectory);
    rename ("header","header_template");
  }
  
  if ($processes{CPP} eq "yes") {
    $directory = $homedirectory . "/.kdevelop/cpp";
    $targetdirectory = $underDirectory . "/templates";
    system ("cp $directory $targetdirectory");
    chdir ($targetdirectory);
    rename ("cpp","cpp_template");
  }
}

#replaced skel with the projectname in different files
chdir ($overDirectory);
$word = "skel";
$oldfile = "Makefile.am";
$replace = $nameLittle;
replaceOldFile($word,$replace,$oldfile);
$oldfile = "configure.in";
replaceOldFile($word,$replace,$oldfile);
$word = "VERSION";
$replace = $processes{VERSION};
replaceOldFile($word,$replace,$oldfile);

chdir ($underDirectory);
$word = "skel";
$oldfile = "Makefile.am";
$replace = $nameLittle;
replaceOldFile($word,$replace,$oldfile);
$oldfile = "main.cpp";
replaceOldFile($word,$replace,$oldfile);
$oldfile = "skel.cpp";
replaceOldFile($word,$replace,$oldfile);

#replaced Skel with the projectname in different files
$word = "Skel";
$oldfile = "main.cpp";
$replace = $name;
replaceOldFile($word,$replace,$oldfile);
$oldfile = "skel.cpp";
replaceOldFile($word,$replace,$oldfile);
$oldfile = "skel.h";
replaceOldFile($word,$replace,$oldfile);

#replaced AUTHOR with the authorname in skel.cpp
$word = "AUTHOR";
$oldfile = "skel.cpp";
$replace = $processes{AUTHOR};
replaceOldFile($word,$replace,$oldfile);

#replaced SKEL with the projectname in skel.h
$word = "SKEL";
$oldfile = "skel.h";
$replace = $nameBig;
replaceOldFile($word,$replace,$oldfile);

#renamed skel with the projectname
rename ("skel.cpp", $nameLittle . ".cpp");
rename ("skel.h", $nameLittle . ".h");

chdir ($underDirectory . "/docs/en");
$word = "skel";
$oldfile = "Makefile.am";
$replace = $nameLittle;
replaceOldFile($word,$replace,$oldfile);

#if GNU-Files was chosen in kAppWizard
if ($processes{GNU} eq "yes") {
  
  #copying the GNU-Files and renamed these
  chdir ($kdedirectory);
  system ("cp share/apps/kdevelop/templates/AUTHORS_template $overDirectory");
  system ("cp share/apps/kdevelop/templates/COPYING_template $overDirectory");
  system ("cp share/apps/kdevelop/templates/ChangeLog_template $overDirectory");
  system ("cp share/apps/kdevelop/templates/INSTALL_template $overDirectory");
  system ("cp share/apps/kdevelop/templates/README_template $overDirectory");
  system ("cp share/apps/kdevelop/templates/TODO_template $overDirectory");
  chdir ($overDirectory);
  rename ("AUTHORS_template", "AUTHORS");
  rename ("COPYING_template", "COPYING");
  rename ("ChangeLog_template", "ChangeLog");
  rename ("INSTALL_template", "INSTALL");
  rename ("README_template", "README");
  rename ("TODO_template", "TODO");
  
  # replaced AUTHOR and EMAIL
  $word = "AUTHOR";
  $replace = $processes{AUTHOR};
  $oldfile = "AUTHORS";
  replaceOldFile($word,$replace,$oldfile);
  $word = "EMAIL";
  $replace = $processes{EMAIL};
  $oldfile = "AUTHORS";
  replaceOldFile($word,$replace,$oldfile);
}
#if LSM-Files was chosen in kAppWizard
if ($processes{LSM} eq "yes") {
  
  #copying, rename and replace in the lsm-template
  chdir ($kdedirectory);
  system ("cp share/apps/kdevelop/templates/lsm_template $overDirectory");
  chdir ($overDirectory);
  rename ("lsm_template", $nameLittle . ".lsm");
  $oldfile = $nameLittle . ".lsm";
  $word = "PROJECT_NAME";
  $replace = $name;
  replaceOldFile($word,$replace,$oldfile);
  $word = "AUTHOR";
  $replace = $processes{AUTHOR};
  replaceOldFile($word,$replace,$oldfile);
  $word = "EMAIL";
  $replace = $processes{EMAIL};
  replaceOldFile($word,$replace,$oldfile);
  $word = "VERSION";
  $replace = $processes{VERSION};
  replaceOldFile($word,$replace,$oldfile);
  
}

#if USER-Docs was chosen in kAppWizard
if ($processes{USER} eq "yes") {
  
  #copying, rename and replace in the handbook-en-template
  chdir ($kdedirectory);
  $targetdirectory = $underDirectory . "/docs/en";
  system ("cp share/apps/kdevelop/templates/handbook_en_template $targetdirectory");
  chdir ($targetdirectory);
  rename ("handbook_en_template", "index.sgml");
  $oldfile = "index.sgml";
  $word = "PROJECT_NAME";
  $replace = $name;
  replaceOldFile($word,$replace,$oldfile);
  $word = "AUTHOR";
  $replace = $processes{AUTHOR};
  replaceOldFile($word,$replace,$oldfile);
  $word = "EMAIL";
  $replace = $processes{EMAIL};
  replaceOldFile($word,$replace,$oldfile);
  $word = "VERSION";
  $replace = $processes{VERSION};
  replaceOldFile($word,$replace,$oldfile);
  $word = "DATE";
  $replace = $date;
  replaceOldFile($word,$replace,$oldfile);
  $word = "YEAR";
  $replace = $year;
  replaceOldFile($word,$replace,$oldfile);

}

#if USER-Docs was not chosen in kAppWizard
if ($processes{USER} eq "no") {
  chdir ($underDirectory);
  $word = "SUBDIRS = docs";
  $replace = ""; 
  $oldfile = "Makefile.am";
  replaceOldFile($word,$replace,$oldfile);
  chdir ($overDirectory);
  $word = $nameLittle . "/docs/Makefile \\";
  $replace = ""; 
  $oldfile = "configure.in";
  replaceOldFile(  $word,$replace,$oldfile);
  $word = $nameLittle . "/docs/en/Makefile \\";
  replaceOldFile($word,$replace ,$oldfile);
}

#if cpp-template was chosen in kAppWizard
if ($processes{CPP} eq "yes") {
  
  #copying, rename and replace in the cpp-file
  chdir ($homedirectory);
  system ("cp .kdevelop/cpp $underDirectory");
  chdir ($underDirectory);
  $oldfile = "cpp";
  $word = "FILENAME";
  $replace = $nameLittle . ".cpp";
  replaceOldFile($word,$replace,$oldfile);
  $word = "AUTHOR";
  $replace = $processes{AUTHOR};
  replaceOldFile($word,$replace,$oldfile);
  $word = "EMAIL";
  $replace = $processes{EMAIL};
  replaceOldFile($word,$replace,$oldfile);
  $word = "DATE";
  $replace = $date;
  replaceOldFile($word,$replace,$oldfile);
  $word = "YEAR";
  $replace = $year;
  replaceOldFile($word,$replace,$oldfile);
   
  # summarized the files cpp and project.cpp
  $file = $nameLittle . ".cpp";
  open (INPUT,"$file") || die "kann Datei nicht ffnen: $!";
  open (OUTPUT,">>cpp");
  while ( defined ($line = <INPUT> )) {
    print OUTPUT $line;
  }
  close (INPUT);
  close (OUTPUT);
  rename ("cpp" , $file);
  unlink ("cpp");
}

#if header-template was chosen in kAppWizard
if ($processes{HEADER} eq "yes") {
  
  #copying, rename and replace in the header-file
  chdir ($homedirectory);
  system ("cp .kdevelop/header $underDirectory");
  chdir ($underDirectory);
  $oldfile = "header";
  $word = "FILENAME";
  $replace = $nameLittle . ".h";
  replaceOldFile($word,$replace,$oldfile);
  $word = "AUTHOR";
  $replace = $processes{AUTHOR};
  replaceOldFile($word,$replace,$oldfile);
  $word = "EMAIL";
  $replace = $processes{EMAIL};
  replaceOldFile($word,$replace,$oldfile);
  $word = "DATE";
  $replace = $date;
  replaceOldFile($word,$replace,$oldfile);
  $word = "YEAR";
  $replace = $year;
  replaceOldFile($word,$replace,$oldfile);
    
  # summarized the files header and project.h
  $file = $nameLittle . ".h";
  open (INPUT,"$file") || die "kann Datei nicht ffnen: $!";
  open (OUTPUT,">>header");
  while ( defined ($line = <INPUT> )) {
    print OUTPUT $line;
  }
  close (INPUT);
  close (OUTPUT);
  rename ("header" , $file);
  unlink ("header");
}

#if .kdelnk-file was chosen in kAppWizard
if ($processes{KDELNK} eq "yes") {

  #copying, rename and replace in the kdelnk-file
  chdir ($kdedirectory);
  system ("cp share/apps/kdevelop/templates/kdelnk_template $underDirectory");
  chdir ($underDirectory);
  rename ("kdelnk_template", $nameLittle . ".kdelnk");
  $word = PROJECT_NAME;
  $oldfile = $nameLittle . ".kdelnk";
  $replace = $nameLittle;
  replaceOldFile($word,$replace,$oldfile);
}

#if no ProgIcon was chosen in kAppWizard
if ($processes{PROGICON} eq "no") {} 

#if the default ProgIcon was chosen in kAppWizard
elsif ($processes{PROGICON} eq "(null)") {
  chdir ($kdedirectory);
  system  ("cp share/icons/edit.xpm $underDirectory");
  chdir ($underDirectory);
  chmod (0666,"edit.xpm");
  rename ("edit.xpm", $nameLittle . ".xpm");
}

#if a new ProgIcon was chosen in kAppWizard
else {
  $icon = $kdedirectory . "/share/icons/" . $processes{PROGICON};
  $copying = system ("cp $icon  $underDirectory");
  if ($copying)  {
    $icon = $homedirectory . "/.kde/share/icons/" . $processes{PROGICON};
    system ("cp $icon  $underDirectory");
  }
  chmod (0666,$processes{PROGICON});
  rename ($processes{PROGICON}, $nameLittle . ".xpm");
}

#if no MiniIcon was chosen in kAppWizard
if ($processes{MINIICON} eq "no") {}

#if the default MiniIcon was chosen in kAppWizard
elsif ($processes{MINIICON} eq "(null)") {
  chdir ($kdedirectory);
  system ("cp share/icons/mini/application_settings.xpm $underDirectory");
  chdir ($underDirectory);
  chmod (0666,"application_settings.xpm");
  rename ("application_settings.xpm","mini-" . $nameLittle . ".xpm");
}

#if a new MiniIcon was chosen in kAppWizard
else {
  $icon = $kdedirectory . "/share/icons/mini/" . $processes{MINIICON};
  $copying = system ("cp $icon  $underDirectory");
  if ($copying)  {
    $icon = $homedirectory . "/.kde/share/icons/mini/" . $processes{MINIICON};
    system ("cp $icon  $underDirectory");
}
  chmod (0666,$processes{MINIICON});
  rename ($processes{MINIICON}, "mini-" . $nameLittle . ".xpm");
}

#if API-Files was chosen in kAppWizard
if ($processes{API} eq "yes") {
  
  #create the API-documentation
  chdir ($underDirectory);
  mkdir ("api",0777);
  system ("kdoc -d ./api/ $name *.h");
}

#start make -f Makefile.dist
printflush (STDOUT,"create configurationfiles...\n");
chdir ($overDirectory);
system ("make -f Makefile.dist");

#start configure
printflush (STDOUT,"make configure...\n");
chdir ($overDirectory);
system ("configure");

#if User-Documentation was chosen in kAppWizard
if ($processes{USER} eq "yes") {
  
  #create the html-files
  printflush (STDOUT,"configure files...\n");
  chdir ($underDirectory . "/docs/en");
  system ("sgml2html index.sgml");
}

chdir ($overDirectory);
$projectFile = $nameLittle . ".kdevprj";
open (PROJECTFILE, ">$projectFile");
print PROJECTFILE "KDevelop Project File 0.3 #DO NOT EDIT# \n";
print PROJECTFILE "#AUTHOR\n";
print PROJECTFILE $processes{AUTHOR} . "\n";
print PROJECTFILE "#EMAIL\n";
print PROJECTFILE $processes{EMAIL} . "\n";
print PROJECTFILE "#PROJECT_NAME\n";
print PROJECTFILE $name . "\n";
print PROJECTFILE "#PROJECT_DIR\n";
print PROJECTFILE $overDirectory . "/\n";
print PROJECTFILE "#PROJECT_SUB_DIR\n";
print PROJECTFILE $nameLittle . "/\n";
print PROJECTFILE "#VERSION\n";
print PROJECTFILE $processes{VERSION} . "\n";
print PROJECTFILE "#SGML_FILE\n";
if ($processes{USER} eq "yes") {
print PROJECTFILE "index.sgml\n";
}
print PROJECTFILE "\n";
print PROJECTFILE "#BEGIN_HEADERS\n";
print PROJECTFILE $nameLittle . ".h\n";
print PROJECTFILE "#END_HEADERS\n\n";
print PROJECTFILE "#BEGIN_SOURCES\n";
print PROJECTFILE "main.cpp\n";
print PROJECTFILE $nameLittle . ".cpp\n";
print PROJECTFILE "#END_SOURCES\n\n";
print PROJECTFILE "#BEGIN_GNU\n";
if ($processes{GNU} eq "yes") {
print PROJECTFILE "ChangeLog\n";
print PROJECTFILE "COPYING\n";
print PROJECTFILE "README\n";
print PROJECTFILE "TODO\n";
print PROJECTFILE "AUTHORS\n";
}
print PROJECTFILE "#END_GNU\n\n";
print PROJECTFILE "#BEGIN_LINUX\n";
if ($processes{LSM} eq "yes") {
    print PROJECTFILE $nameLittle . ".lsm\n";
}
print PROJECTFILE "#END_LINUX\n\n";
print PROJECTFILE "#BEGIN_KDE\n";
if ($processes{USER} eq "yes") {
    print PROJECTFILE "index.sgml\n";
}
if ($processes{KDELNK} eq "yes") {
    print PROJECTFILE $nameLittle . ".kdelnk\n";
}
print PROJECTFILE "#END_KDE\n\n";
print PROJECTFILE "#BEGIN_OTHER\n";
if (!$processes{PROGICON}) {}
else { 
print PROJECTFILE $nameLittle . ".xpm\n";
}
if (!$processes{MINIICON}) {}
else {
print PROJECTFILE "mini-" . $nameLittle . ".xpm\n";
}
print PROJECTFILE "#END_OTHER";
close (PROJECTFILE);

chdir ($underDirectory);
system ("make");

printflush (STDOUT,"READY\n");

exit;

#the subroutine for replacing words in files
sub replaceOldFile {
  $where = 0;
  $counter = 0;
  $wordlength = length($word);
  $newfile = "newfile.txt";
  open (INPUT,$oldfile) || die "kann Datei nicht ffnen: $!";
  open (OUTPUT,">$newfile");
  while ( defined ($line = <INPUT> )) {
    while ($where != -1) {
      $where = index($line,$word,$where);
      if ($where == -1) {
	++$counter;
	print OUTPUT $line;
      }
      else {
	substr($line,$where,$wordlength) = $replace;
	++$where;
      }
    }
    $where = 0;
  }
  close (INPUT);
  close (OUTPUT);
  unlink ($oldfile);
  rename ("newfile.txt",$oldfile);
  unlink ("newfile.txt");
}
