/***************************************************************************
            project.cpp - the projectmanagment specific part of KDevelop
                             -------------------                                         

    version              :                                   
    begin                : 28 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "kdevelop.h"
#include <iostream.h>
#include "prjoptionsdlg.h"

void KDevelop::slotProjectAddNewFile(){
  newFile(true);
  
}

void KDevelop::slotProjectAddExistingFile(){
  QString name = KFileDialog::getOpenFileName(prj.dir + prj.sub_dir,"*",this);
  QString source_file = name;
  QString dest_file = name; // destination
  QFileInfo file_info(name);
  if (!file_info.exists()) return;
  QString section;
  name = file_info.fileName();

  section = "other";
  if (name.right(2) == ".h"){
    section = "headers";
  }
  if (getTabLocation(name) == CPP){
    section = "sources";
  }
  if (name.right(4) == ".lsm"){
    section = "linux";
  }
  if (name.right(5) == ".sgml" || name.right(7) == ".kdelnk") {
    section = "kde";
  }
  if (name == "INSTALL" || name == "README" || name == "TODO" || name == "AUTHORS" 
      || name == "ChangeLog" || name == "COPYING"){
    section = "gnu";
  }
 
  // copy the file to the correct Location, into the project-tre
  // get the destfile;
  if (section == "headers" || section == "sources" || section == "other" 
      || name.right(7) == ".kdelnk"){
    dest_file = prj.dir + prj.sub_dir + name;
  }
  if (section == "gnu" || section == "linux" ){
    dest_file = prj.dir + name;
  }
  if (name.right(5) == ".sgml"){
    dest_file = prj.dir + prj.sub_dir + "/docs/en/" + name;
  }
  
  // copy the file to the correct Location, into the project-tree
  process.clearArguments();
  process << "cp";
  process << source_file;
  process << dest_file;
  process.start(KProcess::Block,KProcess::AllOutput); // blocked because it is important

  addFileToProject(section,name);
  switchToFile(dest_file);
}

void KDevelop::slotProjectRemoveFile(){
  QString name = log_file_tree->getCurrentItem()->getText();
  QString section;
  section = "other";
  if (name.right(2) == ".h"){
    section = "headers";
  }
  if (getTabLocation(name) == CPP){
    section = "sources";
  }
  if (name.right(4) == ".lsm"){
    section = "linux";
  }
  if (name.right(5) == ".sgml" || name.right(7) == ".kdelnk") {
    section = "kde";
  }
  if (name == "INSTALL" || name == "README" || name == "TODO" || name == "AUTHORS" 
      || name == "ChangeLog" || name == "COPYING"){
    section = "gnu";
  }
  delFileFromProject(section,name);
 
}

void KDevelop::slotProjectOptions(){
  new PrjOptionsDlg(this,"optdialog",this,&prj);
}

void KDevelop::newFile(bool add_to_project){
  CNewFileDlg dlg(this,"test",true);
  dlg.setUseTemplate();
  if (add_to_project){
    dlg.setAddToProject();
  }
  if(!dlg.exec()) return; // cancel

  QString filename = dlg.fileName();
  QString complete_filename;
  QString section;
  QString filetype = dlg.fileType();
  
  output_widget->clear();
  QDir::setCurrent(prj.dir); 
  process.clearArguments();
  if (filetype == "HEADER"){
     filetype = "header";
  }
  if (filetype == "CPP"){
    filetype = "cpp";
  }
  if (filetype == "TEXTFILE"){
    filetype = "textfile";
  }
  if (filetype == "LSM"){
    filetype = "lsm";
  }
  if (filetype == "KDELNK"){
    filetype = "kdelnk";
  }
  if (filetype == "SGML"){
    filetype = "handbook_en";
  }
  if (filetype == "INSTALL" || filetype == "TODO" || filetype == "README"
      || filetype == "AUTHORS" || filetype == "ChangeLog" || filetype == "COPYING") {
    filename = filetype;
    filetype = "gnu";
  }
  // contruct the complete_filename
  if (filetype == "lsm" || filetype == "gnu"){
    complete_filename = prj.dir + filename;
  }
  if (filetype == "header" || filetype == "cpp" || filetype == "kdelnk" || filetype == "textfile"){
    complete_filename = prj.dir + prj.sub_dir + filename;
  }
  if (filetype == "handbook_en"){
    complete_filename = prj.dir + prj.sub_dir + "docs/en/" + filename;
  }

  // check if generate a empty file or generate one
  if (dlg.useTemplate() && (filetype != "textfile")){ // generate one,textfile always empty
    QString path = kapp->kde_datadir()+"/kdevelop/tools/";
    process << "perl" << path + "gennewfile";
    process << prj.prjfile;
    process << filetype;
    process << filename;
    process.start(KProcess::Block,KProcess::AllOutput); // its blocked because correct files
    //are important
  }
  else { // no template, -> empty file
    QFile file(complete_filename);
    file.open(IO_ReadWrite);
    file.close();
  }
  
  // load into the widget
  switchToFile(complete_filename);
  
  // add the file to the project if necessary
  if (dlg.addToProject() == true){
    
    if (filetype == "header") section = "headers";
    if (filetype == "lsm") section = "linux";
    if (filetype == "gnu")  section = "gnu";
    if (filetype == "kdelnk" || filetype == "handbook_en")  section = "kde";
    if (filetype == "cpp") section = "sources";
    if (filetype == "textfile") section = "other";
    addFileToProject(section,filename);
  }
}
void KDevelop::addFileToProject(QString section,QString filename){
  
  if (section == "headers") prj.header_files.append(filename);
  if (section == "linux")  prj.linux_files.append(filename);
  if (section == "gnu")  prj.gnu_files.append(filename);
  if (section == "kde")  prj.kde_files.append(filename);
  if (section == "other") prj.other_files.append(filename);
  
  if (section == "sources"){
    prj.cpp_files.append(filename);

    // manipulate the makefiles
    QString makefile = prj.dir + prj.sub_dir + "Makefile.am";
    QString str;
    QFile f(makefile);
    f.open(IO_ReadOnly);
    QTextStream stream(&f);
    QStrList list;
    if (!f.exists()){
      cerr << "read error Makefile.am";
      return;
    }
    while(!stream.eof()){ // read the whole Makefile
      list.append(stream.readLine());
    }
    f.close();
    f.open(IO_WriteOnly);
    for(str = list.first();str != 0;str = list.next()){
      if (str.contains("SOURCES") == 0){
	stream << str << endl;
      }
      else{
	stream << str + " " + filename << endl;
      }
    }
    f.close();
  }
  
  prj.writeProject();
  refreshTrees();
}
void KDevelop::delFileFromProject(QString section,QString filename){

  if (section == "headers") prj.header_files.remove(filename);
  if (section == "linux")  prj.linux_files.remove(filename);
  if (section == "gnu")  prj.gnu_files.remove(filename);
  if (section == "kde")  prj.kde_files.remove(filename);
  if (section == "other") prj.other_files.remove(filename);
  
  if (section == "sources"){
    prj.cpp_files.remove(filename);
    output_widget->clear();
    QDir::setCurrent(prj.dir); 
    process.clearArguments();
    QString path = kapp->kde_datadir()+"/kdevelop/tools/";
    process << "perl" << path + "delsourcefromprj";
    process << prj.prjfile;
    process << filename;
    process.start(KProcess::Block,KProcess::AllOutput); // blocked because it is important
  }
  prj.writeProject();
  slotFileClose();
  refreshTrees();
}
void KDevelop::readProjectFile(QString file){
  QString str;
  prj.readProject(file);
  
  str = prj.dir + prj.sub_dir + prj.name.lower() + ".cpp";
  if(QFile::exists(str)){
    switchToFile(str);
  }
  str = prj.dir + prj.sub_dir + prj.name.lower() + ".h";
  if(QFile::exists(str)){
    switchToFile(str);
  }
  // set the menus enable
  int id;
  // file menu

  id = file_menu->idAt(0);
  file_menu->setItemEnabled(id,true);
  // doc menu
  id = documentation_menu->idAt(11);
  documentation_menu->setItemEnabled(id,true);
  id = documentation_menu->idAt(12);
  documentation_menu->setItemEnabled(id,true);
  // build menu
  setToolMenuProcess(true);  
  // prj menu
  id = project_menu->idAt(0);
  project_menu->setItemEnabled(id,true);
  id = project_menu->idAt(1);
  project_menu->setItemEnabled(id,true);
  id = project_menu->idAt(2);
  project_menu->setItemEnabled(id,true);
  id = project_menu->idAt(3);
  project_menu->setItemEnabled(id,true);

  project=true;
  slotOptionsRefresh();
}

