/***************************************************************************
                     kdevelop.h - the mainclass in kdevelop   
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#ifndef KDEVELOP_H
#define KDEVELOP_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

class KDevelop;
#include <keditcl.h>
#include <kapp.h>
#include <ktmainwindow.h>
#include <ktreelist.h>

#include <qstring.h>
#include <kprocess.h>
#include <htmlview.h>
#include <kfm.h>
#include <kiconloader.h>
#include <qlist.h>
#include <qstrlist.h>
#include <knewpanner.h>
#include <kfiledialog.h>

#include "cbrowser.h"
#include "structdef.h"
#include "ceditwidget.h"
#include "cnewfiledlg.h"
#include "coutputwidget.h"
#include "ctabctl.h"
#include "kprjdirtreelist.h"
#include "clogfileview.h"
#include "cprojectinfo.h"
#include "cclassview.h"

// for the setCurrentTab(int);

#define HEADER 0
#define CPP 1
#define BROWSER 2

/** the mainclass in kdevelop
  *@author Sandy Meier
  */
class KDevelop : public KTMainWindow {
  Q_OBJECT
public:
  /**constructor*/
  KDevelop();
  /**destructor*/
  ~KDevelop(){};
  void init();
  void initConnections();
  void initMenu();
  void initToolbar();
  void initStatusBar();
  void initProject();
  void refreshTrees();

  void newFile(bool add_to_project);
  /** read the projectfile from the disk*/
  void readProjectFile(QString file);
  
  void addFileToProject(QString section,QString filename);
  void delFileFromProject(QString section,QString filename);
  /**@param filename the absolute filename*/
  void switchToFile(QString filename); // filename = abs
  int getTabLocation(QString filename);
  
  

  /** set the correct toolbar and menubar,if a process is running
    * @param enable if true than enable,otherwise disable
    */
  void setToolMenuProcess(bool enable);
  
 public slots:
 /** generate a new project*/
 void slotFileNewAppl();
  /** generate a new file*/
  void slotFileNewFile();
  /**open a file*/
  void slotFileOpenFile();
  /** open a projectfile and close the old one*/
  void slotFileOpenPrj();
  
  /** save the current file,if Untitled a dialog ask for a valid name*/
  void slotFileSave();
  /** save the current file under a different filename*/
  void slotFileSaveAs();
  /** close the cuurent file*/
  void slotFileClose();
  /** quit kdevelop*/
  void slotFileQuit();

  void slotEditCut();
  void slotEditCopy();
  void slotEditPaste();
  void slotEditSelectAll();
  void slotEditInsertFile();
  void slotEditSearch();
  void slotEditRepeatSearch();
  void slotEditReplace();
  void slotEditGotoLine();

  void slotOptionsTStdToolbar();
  void slotOptionsTBrowserToolbar();
  void slotOptionsTStatusbar();
  /** refresh all trees and other widgets*/
  void slotOptionsRefresh();
  /** show a configure-dialog for kdevelop*/
  void slotOptionsConfKDevelop();

  void slotDocBack();
  void slotDocForward();
  void slotDocSClass();
  void slotDocQtLib();
  void slotDocKDECoreLib();
  void slotDocKDEGUILib();
  void slotDocKDEKFileLib();
  void slotDocKDEHTMLLib();
  void slotDocAPI();
  void slotDocManual();


  void slotBuildRun();
  void slotBuildMake();
  void slotBuildRebuildAll();
  void slotBuildCleanRebuildAll();
  void slotBuildStop();
  void slotBuildAPI();
  void slotBuildManual();

  void slotProjectAddNewFile();
  void slotProjectAddExistingFile();
  void slotProjectRemoveFile();

  void slotProjectOptions();
  void slotBookmarksAdd();
  void slotBookmarksEdit();

  void slotToolbarClicked(int);
  void slotURLSelected(KHTMLView* widget,const char* url,int,const char*);
  void slotReceivedStdout(KProcess* proc,char* buffer,int buflen);
  void slotReceivedStderr(KProcess* proc,char* buffer,int buflen);
  void slotProcessExited(KProcess* proc);

  void slotLogFileTreeSelected(int);
  
  void slotRealFileTreeSelected(int);

  void slotSTabSelected(int item);
  void slotMenuBuffersSelected(int id);
  void slotClickedOnOutputWidget();

  void slotClassChoiceCombo(int index);
  void slotMethodChoiceCombo(int index);
  void slotClassTreeSelected(int);
// return the position of the classdeclaration begin
  int CVGotoClassDecl(QString classname);
  void CVGotoClassVarDecl(QString classname,QString var_name);
  void CVGotoMethodeImpl(QString classname,QString name);
  void refreshClassCombos();
protected:
  virtual void closeEvent(QCloseEvent* e);
private:
  //the menus
  QPopupMenu* file_menu;
  QPopupMenu* edit_menu;
  QPopupMenu* documentation_menu;
  QPopupMenu* build_menu;
  QPopupMenu* project_menu;
  QPopupMenu* options_menu;
  QPopupMenu* menu_buffers;

   KNewPanner* view;
   KNewPanner* top_panner;
  

  KIconLoader icon_loader;
  KProcess process;
  KShellProcess shell_process;
  CProjectInfo prj; // at the moment only one project at the same time

  KConfig* config;
  int act_outbuffer_len;
  //  int s_tab_current; // actual Tab in the s_tab_view 

  // for the browser
  QStrList history_list;

  
  QList<TEditInfo> edit_infos;
  //some widgets for the mainview

  CTabCtl* s_tab_view; // the tabbar for the sourcescode und browser 
  CTabCtl* t_tab_view; // the tabbar for the trees
  CEditWidget* edit_widget; // a pointer to the actual editwidget
 
  CEditWidget* header_widget; // the editwidget for the headers/resources

  CEditWidget* cpp_widget;    //  the editwidget for cpp files
  CBrowser* browser_widget;
 
  CClassView* class_tree; // the classview
  CLogFileView* log_file_tree; // the logical filetree
  KProjectDirTreeList* real_file_tree; // the real filetree
 
  QString version;
  bool project;

  COutputWidget* output_widget; // output for the compiler ...

  // for more then one job in proc;checked in slotProcessExited(KProcess* proc);
  // values are "run","make" "refresh";
  QString next_job;
  enum {TOOLBAR_NEW, TOOLBAR_OPEN,TOOLBAR_SAVE, TOOLBAR_COPY,
	TOOLBAR_PASTE, TOOLBAR_CUT ,TOOLBAR_REFRESH ,TOOLBAR_MAKE,TOOLBAR_RUN,
	TOOLBAR_STOP,TOOLBAR_SCLASS, TOOLBAR_BACK, TOOLBAR_FORWARD,TOOLBAR_CLASS_CHOICE,
	TOOLBAR_METHOD_CHOICE};
};

#endif
