/***************************************************************************
      init.cpp - the init specific part of KDevelop (construtor ...)
                             -------------------                                         

    version              :                                   
    begin                : 20 Jul 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "kdevelop.h"
#include <iostream.h>

KDevelop::KDevelop(){  
  QString filename;
  version = VERSION;
  project=false;// no project
  init();
  initConnections();
  initProject(); 
    
  // read the three last files
   filename = config->readEntry("cpp_file");
   if (QFile::exists(filename)){
     switchToFile(filename);
   }
   filename = config->readEntry("header_file");
   if (QFile::exists(filename)){
     switchToFile(filename);
  }
   filename = config->readEntry("browser_file");
   if(filename != ""){
     slotURLSelected(browser_widget,filename,1,"test");
   }
}

// all the init-stuff
void KDevelop::initConnections(){
  // connections for the proc -processes
  connect(&process,SIGNAL(receivedStdout(KProcess*,char*,int)),
  	  this,SLOT(slotReceivedStdout(KProcess*,char*,int)) );

  connect(&process,SIGNAL(receivedStderr(KProcess*,char*,int)),
	  this,SLOT(slotReceivedStderr(KProcess*,char*,int)) );

  connect(&process,SIGNAL(processExited(KProcess*)),
	  this,SLOT(slotProcessExited(KProcess*) )) ;
  
  connect(&shell_process,SIGNAL(receivedStdout(KProcess*,char*,int)),
	  this,SLOT(slotReceivedStdout(KProcess*,char*,int)) );
  connect(&shell_process,SIGNAL(processExited(KProcess*)),
	  this,SLOT(slotProcessExited(KProcess*) )) ;
  
  // connect the windowsmenu with a method
  connect(menu_buffers,SIGNAL(activated(int)),this,SLOT(slotMenuBuffersSelected(int)));
  
}
void KDevelop::init(){
  
  act_outbuffer_len=0;

  QFont font("Fixed",10);
  KApplication *app=KApplication::getKApplication();
  config = app->getConfig();
  config->setGroup("General Options");
  int w = config->readNumEntry("width");
  int h = config->readNumEntry("height");
  resize(w,h);
 
  view = new KNewPanner(this,"view",KNewPanner::Horizontal,KNewPanner::Absolute,
			config->readNumEntry("view_panner_pos"));  
  
  output_widget = new COutputWidget(kapp,view);
  output_widget->setText("Welcome to KDevelop! Version "+ version);
  output_widget->setFillColumnMode(80,true);
  output_widget->setWordWrap(true);
  output_widget->setAutoIndentMode(true);
  output_widget->setFocusPolicy(QWidget::ClickFocus);
  connect(output_widget,SIGNAL(clicked()),this,SLOT(slotClickedOnOutputWidget()));

  
  //  s_tab_current = 0;
  top_panner = new KNewPanner(view,"top_panner",KNewPanner::Vertical,KNewPanner::Absolute,
			      config->readNumEntry("top_panner_pos"));

  t_tab_view = new CTabCtl(top_panner);

  log_file_tree = new CLogFileView(t_tab_view,"lfv");
  log_file_tree->setIndentSpacing(15);
  log_file_tree->setFocusPolicy(QWidget::ClickFocus);
  
  class_tree = new CClassView(t_tab_view,"cv");
  class_tree->setIndentSpacing(15);
  class_tree->setFocusPolicy(QWidget::ClickFocus);

  real_file_tree = new KProjectDirTreeList(t_tab_view,"RFV");
  real_file_tree->setFocusPolicy(QWidget::ClickFocus);
  class_tree->setIndentSpacing(15);

  t_tab_view->addTab(class_tree,"CV");
  t_tab_view->addTab(log_file_tree,"LFV");
  t_tab_view->addTab(real_file_tree,"RFV");

  connect(class_tree, SIGNAL(singleSelected(int)),this, SLOT(slotClassTreeSelected(int)));
  connect(log_file_tree, SIGNAL(singleSelected(int)), SLOT(slotLogFileTreeSelected(int)));
  connect(real_file_tree, SIGNAL(singleSelected(int)), SLOT(slotRealFileTreeSelected(int)));

  // the tabbar + tabwidgets for edit and browser
  s_tab_view = new CTabCtl(top_panner);
  connect(s_tab_view,SIGNAL(tabSelected(int)),this,SLOT(slotSTabSelected(int)));

  header_widget = new CEditWidget(kapp,s_tab_view,"header");
  header_widget->setFont(font);
  header_widget->setName("Untitled.h");
  edit_widget=header_widget;
  cpp_widget = new CEditWidget(kapp,s_tab_view,"cpp");
  cpp_widget->setFont(font);
  cpp_widget->setName("Untitled.cpp");
  // init the 2 first kedits
  TEditInfo* edit1 = new TEditInfo;
  TEditInfo* edit2 = new TEditInfo;
  edit1->filename = header_widget->getName();
  edit2->filename = cpp_widget->getName();
  
  
  browser_widget = new CBrowser(s_tab_view,"browser");  

  //init

  connect(browser_widget,SIGNAL(URLSelected(KHTMLView*,const char*,int,const char*)),
	  this,SLOT(slotURLSelected(KHTMLView*,const char*,int,const char*)));
  
  s_tab_view->addTab(header_widget,"Header/Resource Files");
  s_tab_view->addTab(cpp_widget,"C/C++ Files");
  s_tab_view->addTab(browser_widget,"Documentation-Browser");
 
  top_panner->activate(t_tab_view,s_tab_view);// activate the top_panner
  
  view->activate(top_panner,output_widget); 


  // set the mainwidget
  setView(view);
  initMenu();
  initToolbar();
  initStatusBar();

  // the rest of the init for the kedits
  edit1->id = menu_buffers->insertItem(edit1->filename,-2,0);
  edit1->modified=false;
  edit2->id = menu_buffers->insertItem(edit2->filename,-2,0);
  edit2->modified=false;
  edit_infos.append(edit1);
  edit_infos.append(edit2);
 
}
void KDevelop::initMenu(){
  int id;
  // build a menubar
  QPixmap pix;
  // a menubar consists of popup menus
  file_menu = new QPopupMenu;
 
  id=file_menu->insertItem(Icon("filenew.xpm"),i18n("&New File..."), this, SLOT(slotFileNewFile()),
			   CTRL+Key_N);
  file_menu->setItemEnabled(id,false);
  file_menu->insertItem(i18n("N&ew Project..."), this, SLOT(slotFileNewAppl()));
  file_menu->insertSeparator();
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/open.xpm");
  file_menu->insertItem(pix,i18n("&Open File..."), this, SLOT(slotFileOpenFile()),CTRL+Key_O);
  file_menu->insertItem(i18n("Open &Project..."), this, SLOT(slotFileOpenPrj()));
  file_menu->insertSeparator();
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/save.xpm");
  file_menu->insertItem(pix,i18n("&Save"), this, SLOT(slotFileSave()), CTRL+Key_S);
  file_menu->insertItem(i18n("Save &As..."), this, SLOT(slotFileSaveAs())); 
  file_menu->insertItem(i18n("&Close"), this, SLOT(slotFileClose()), CTRL+Key_W);

  file_menu->insertSeparator();
  file_menu->insertItem(i18n("&Quit"),this, SLOT(slotFileQuit()), CTRL+Key_Q);

  // put the popupmenu as File-menu into the menu bar
  menuBar()->insertItem(i18n("&File"), file_menu);
  menuBar()->insertSeparator();

  // edit menu
  
  edit_menu = new QPopupMenu;
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/cut.xpm");
  edit_menu->insertItem(pix,i18n("C&ut"), this, SLOT(slotEditCut()), CTRL+Key_X);
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/copy.xpm");
  edit_menu->insertItem(pix,i18n("&Copy"), this, SLOT(slotEditCopy()), CTRL+Key_C);
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/paste.xpm");
  edit_menu->insertItem(pix,i18n("&Paste"), this, SLOT(slotEditPaste()), CTRL+Key_V);
  edit_menu->insertItem(i18n("Select &All"), this, SLOT(slotEditSelectAll()));
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("&Insert File..."),this, SLOT(slotEditInsertFile()));
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("&Search..."), this, SLOT(slotEditSearch()));
  edit_menu->insertItem(i18n("&Repeat Search..."), this, SLOT(slotEditRepeatSearch()));
  edit_menu->insertItem(i18n("&Replace..."), this, SLOT(slotEditReplace()));
  edit_menu->insertSeparator();
  edit_menu->insertItem(i18n("&Goto Line..."), this, SLOT(slotEditGotoLine()));
  
  menuBar()->insertItem(i18n("&Edit"), edit_menu);
  menuBar()->insertSeparator();
  
  // documentation menu
  documentation_menu = new QPopupMenu;

  id = documentation_menu->insertItem(i18n("Back"),this, SLOT(slotDocBack()));
  documentation_menu->setItemEnabled(id,false);
  id = documentation_menu->insertItem(i18n("Forward"),this, SLOT(slotDocForward()));
  documentation_menu->setItemEnabled(id,false);
  documentation_menu->insertSeparator();
  documentation_menu->insertItem(i18n("&Search Marked Class"),this, SLOT(slotDocSClass()));
  documentation_menu->insertSeparator();
  documentation_menu->insertItem(i18n("&Qt-Library"),this, SLOT(slotDocQtLib()));
  documentation_menu->insertItem(i18n("KDE-&Core-Library"),this, SLOT(slotDocKDECoreLib()));
  documentation_menu->insertItem(i18n("KDE-&GUI-Library"),this, SLOT(slotDocKDEGUILib()));
  documentation_menu->insertItem(i18n("KDE-&KFile-Library"),this, SLOT(slotDocKDEKFileLib()));
  documentation_menu->insertItem(i18n("KDE-&HTML-Library"),this, SLOT(slotDocKDEHTMLLib()));
  documentation_menu->insertSeparator();
  id = documentation_menu->insertItem(i18n("Project &API-Doc"),this, SLOT(slotDocAPI()));
  documentation_menu->setItemEnabled(id,false);
  id = documentation_menu->insertItem(i18n("Project &User-Manual"),this, SLOT(slotDocManual()));
  documentation_menu->setItemEnabled(id,false);

  menuBar()->insertItem(i18n("&Documentation"), documentation_menu);
  menuBar()->insertSeparator();
  


  // build menu
  
  build_menu = new QPopupMenu;

  id=build_menu->insertItem(Icon("run.xpm"),i18n("&Run"), this, SLOT(slotBuildRun()));
  build_menu->setItemEnabled(id,false);
  id=  build_menu->insertItem(Icon("make.xpm"),i18n("&Make"), this, SLOT(slotBuildMake()));
  build_menu->setItemEnabled(id,false);
  id=  build_menu->insertItem(i18n("&Rebuild all"), this, SLOT(slotBuildRebuildAll()));
  build_menu->setItemEnabled(id,false);
  id= build_menu->insertItem(i18n("&Clean/Rebuild all"), this, SLOT(slotBuildCleanRebuildAll()));
  build_menu->setItemEnabled(id,false);
  id= build_menu->insertItem(Icon("stop.xpm"),i18n("&Stop"), this, SLOT(slotBuildStop()));
  build_menu->setItemEnabled(id,false);
  build_menu->insertSeparator();
  id=  build_menu->insertItem(i18n("Make &API-Doc"), this, SLOT(slotBuildAPI()));
  build_menu->setItemEnabled(id,false);
  id=  build_menu->insertItem(i18n("Make &User-Manual"), this, SLOT(slotBuildManual()));
  build_menu->setItemEnabled(id,false);
  
  menuBar()->insertItem(i18n("&Build"), build_menu);

  // project Menu
  // first the submenu for adding projectfiles
  QPopupMenu* p2 = new QPopupMenu;
  p2->insertItem(i18n("&New File..."), this, SLOT(slotProjectAddNewFile()));
  p2->insertItem(i18n("&Existing File..."), this, SLOT(slotProjectAddExistingFile()));

  project_menu = new QPopupMenu;
  id=project_menu->insertItem("&Add File to Project",p2); 
  project_menu->setItemEnabled(id,false);
  id= project_menu->insertItem(i18n("&Remove File from Project"), this, SLOT(slotProjectRemoveFile()));
  project_menu->setItemEnabled(id,false);
  project_menu->insertSeparator();
  id=project_menu->insertItem(i18n("&Options..."), this, SLOT(slotProjectOptions()));
  project_menu->setItemEnabled(id,false);

  menuBar()->insertItem(i18n("&Project"), project_menu);
  
  
  // the bookmarks menu
  // p = new QPopupMenu;
//   p->insertItem(i18n("&Add Bookmark"), this, SLOT(slotBookmarksAdd()));
//   p->insertItem(i18n("&Edit Bookmarks..."), this, SLOT(slotBookmarksEdit()));
//   p->insertSeparator();
//   menuBar()->insertItem(i18n("&Bookmarks"),p);

  
  // options menu
  options_menu = new QPopupMenu;
 
  options_menu->insertItem(Icon("reload.xpm"),i18n("&Refresh"),this, SLOT(slotOptionsRefresh()));
  options_menu->insertSeparator();
  options_menu->insertItem(i18n("Toogle &Std-Toolbar"),this, SLOT(slotOptionsTStdToolbar()));
  options_menu->insertItem(i18n("Toogle &Browser-Toolbar"),this, SLOT(slotOptionsTBrowserToolbar()));
  options_menu->insertItem(i18n("Toogle Status&bar"),this, SLOT(slotOptionsTStatusbar()),CTRL+Key_B);
  options_menu->insertSeparator();
  options_menu->insertItem(i18n("&Configure KDevelop..."),this, SLOT(slotOptionsConfKDevelop()));
  

  menuBar()->insertItem(i18n("&Options"), options_menu);
  menuBar()->insertSeparator();

  // the buffers menu

  menu_buffers = new QPopupMenu;
  menuBar()->insertItem(i18n("&Buffers"), menu_buffers);
    

  // the helpmenu
  menuBar()->insertSeparator();
  // generate the help menu
  QPopupMenu* p = new QPopupMenu();
  p = kapp->getHelpMenu(true, 
			i18n("\t\tKDevelop Version "+version+" (Alpha) \n\n\t(c) 1998 KDevelop Team \n
Sandy Meier <smeier@rz.uni-potsdam.de
Stefan Heidrich <sheidric@rz.uni-potsdam.de
Stefan Bartel <bartel@rz.uni-potsdam.de"));

  menuBar()->insertItem(i18n("&Help"), p);

}

void KDevelop::initToolbar(){
  QPixmap pix;
  QString  path;
  // build the first toolbar

  // insert some buttons 
  
  toolBar()->insertButton(Icon("filenew.xpm"),TOOLBAR_NEW, true,i18n("New"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/open.xpm");
  toolBar()->insertButton(pix,TOOLBAR_OPEN, true,i18n("Open File"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/save.xpm");
  toolBar()->insertButton(pix,TOOLBAR_SAVE,true,i18n("Save File"));

  toolBar()->insertSeparator();
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/copy.xpm");
  toolBar()->insertButton(pix,TOOLBAR_COPY, true,i18n("Copy"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/paste.xpm");
  toolBar()->insertButton(pix,TOOLBAR_PASTE, true,i18n("Paste"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/cut.xpm");
  toolBar()->insertButton(pix,TOOLBAR_CUT,true,i18n("Cut"));
  
  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("reload.xpm"),TOOLBAR_REFRESH, true,i18n("Refresh"));

  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/make.xpm");
  toolBar()->insertSeparator();
  toolBar()->insertButton(pix,TOOLBAR_MAKE, false,i18n("Make"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/run.xpm");
  toolBar()->insertButton(pix,TOOLBAR_RUN, false,i18n("Run"));
  pix.load(KApplication::kde_datadir() + "/kdevelop/toolbar/stop.xpm");
  toolBar()->insertButton(pix,TOOLBAR_STOP, false,i18n("Stop"));

  connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));

  // the second toolbar
  toolBar(1)->insertCombo("Classes",TOOLBAR_CLASS_CHOICE,true,SIGNAL(activated(int))
			  ,this,SLOT(slotClassChoiceCombo(int)),true,i18n("choice the class"),140 );
  KCombo* class_combo = toolBar(1)->getCombo(TOOLBAR_CLASS_CHOICE);
  class_combo->setFocusPolicy(QWidget::NoFocus);
  toolBar(1)->insertCombo("Methods",TOOLBAR_METHOD_CHOICE,true,SIGNAL(activated(int))
			  ,this,SLOT(slotMethodChoiceCombo(int)),true,i18n("choice the methods"),240 );
  KCombo* choice_combo = toolBar(1)->getCombo(TOOLBAR_METHOD_CHOICE);
  choice_combo->setFocusPolicy(QWidget::NoFocus);
  toolBar(1)->insertSeparator();
  toolBar(1)->insertButton(Icon("back.xpm"),TOOLBAR_BACK, false,i18n("Back"));
  toolBar(1)->insertButton(Icon("forward.xpm"),TOOLBAR_FORWARD, false,i18n("Forward"));
    
  toolBar(1)->insertButton(Icon("contents.xpm"),TOOLBAR_SCLASS, true,i18n("Search Class in Documenation"));
  
  connect(toolBar(1), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
}

void KDevelop::initStatusBar(){
  statusBar()->insertItem(i18n("ready"),1);
}
void KDevelop::initProject(){
  config->setGroup("Files");
  QString filename = config->readEntry("project_file");
  QFile file(filename);
  // cerr << "INITPROJECT: " << filename << endl;
  if (file.exists()){
    readProjectFile(filename);
    // cerr << endl << "READPROJECT";
    
  }  
}
