/***************************************************************************
                     cnewfiledlg.cpp - the new file dialog
                             -------------------                                         

    version              :                                   
    begin                : 17 Aug 1998                                        
    copyright            : (C) 1998 by Sandy Meier                         
    email                : smeier@rz.uni-potsdam.de                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/
#include "cnewfiledlg.h"
#include <kmsgbox.h>
#include <iostream.h>

CNewFileDlg::CNewFileDlg(QWidget* parent,const char* name,bool modal,WFlags f) 
  : QDialog(parent,name,modal,f){

    setCaption("New File...");    
    button_group = new QButtonGroup( this, "button_goup" );
    button_group->setGeometry(350, 140, 140, 90  ); 
    button_group->setFrameStyle( 49 );
    button_group->setTitle( "Options" );
    button_group->setAlignment( 1 );
    
    check_use_template = new QCheckBox( this, "check_use_template" );
    check_use_template->setGeometry(370, 160, 100, 30 );
    check_use_template->setText( "use Template" );
    check_use_template->setAutoRepeat( FALSE );
    check_use_template->setAutoResize( FALSE );
    
    check_add_to_project = new QCheckBox( this, "check_add_project" );
    check_add_to_project->setGeometry(  370, 190, 100, 30  );
    check_add_to_project->setText( "add to Project" );
    check_add_to_project->setAutoRepeat( FALSE );
    check_add_to_project->setAutoResize( FALSE );
    
    ok = new QPushButton( this, "ok" );
    ok->setGeometry(130, 300, 100, 30 );
    ok->setText( "OK" );
    ok->setAutoRepeat( FALSE );
    ok->setAutoResize( FALSE );

    edit = new QLineEdit( this, "edit" );
    edit->setGeometry(   350, 60, 140, 30 );
    edit->setText( "" );
    edit->setMaxLength( 32767 );
    edit->setEchoMode( QLineEdit::Normal );
    edit->setFrame( TRUE );
    
    cancel = new QPushButton( this, "cancel" );
    cancel->setGeometry(300, 300, 100, 30 );
    cancel->setText( "Cancel" );
    cancel->setAutoRepeat( FALSE );
    cancel->setAutoResize( FALSE );
    
    label_filename = new QLabel( this, "label_filename" );
    label_filename->setGeometry(  290, 60, 60, 30 );
    label_filename->setText( "Filename:" );
    label_filename->setAlignment( 289 );
    label_filename->setMargin( -1 );
   
    // the tabview
    tab = new KTabCtl(this);
    tab->setGeometry(20, 33, 260, 230  );
    tab->setBorder(false);
    
    list_gnu = new QListBox( tab, "list_gnu" );
    list_gnu->insertItem( "INSTALL" );
    list_gnu->insertItem( "README" );
    list_gnu->insertItem( "COPYING" );
    list_gnu->insertItem( "AUTHORS" );
    list_gnu->insertItem( "TODO" );
    list_gnu->insertItem( "ChangeLog" );
    list_gnu->setMultiSelection( FALSE );
    list_gnu->setCurrentItem(0);
    
    list_linux = new QListBox( tab, "list_linux" );
    list_linux->insertItem( "lsm-File (.lsm) - for the Linux Software Map" );
    list_linux->setMultiSelection( FALSE );
    list_linux->setCurrentItem(0);
    
    list_kde = new QListBox( tab, "list_kde" );
    list_kde->insertItem( "sgml-File (.sgml) - for the User-Manual" );
    list_kde->insertItem( "Link-File (.kdelnk) - for the K-Menu" );
    list_kde->setMultiSelection( FALSE );
    list_kde->setCurrentItem(0);
   
    list_cpp = new QListBox( tab, "list_cpp" );
    list_cpp->insertItem( "Header (*.h) - a C/C++ Header File" );
    list_cpp->insertItem( "C/C++ File (*.cpp,*.c,*.cc,*.C) - Impl. File" );
    list_cpp->insertItem( "Empty Textfile" );
    list_cpp->setMultiSelection( FALSE );
    list_cpp->setCurrentItem(0);
    
    tab->addTab(list_cpp,"General");
    tab->addTab(list_gnu,"GNU");
    tab->addTab(list_linux,"Linux");
    tab->addTab(list_kde,"KDE");
      
    resize(510,350 );
    setFixedSize(510,350);
    edit->setFocus();
    
    connect(tab,SIGNAL(tabSelected(int)),this,SLOT(slotTabSelected(int)));
    connect(ok,SIGNAL(clicked()),this,SLOT(slotOKClicked()));
    connect(cancel,SIGNAL(clicked()),this,SLOT(reject()));
}

void CNewFileDlg::slotTabSelected(int item){
  if (item == 1){
    edit->setEnabled(false);
  }
  else {
    edit->setEnabled(true);
  }
  current = item;
}
void CNewFileDlg::slotOKClicked(){
  QString text = edit->text();
  if ( (fileType() == "CPP") && 
       !(text.right(4) == ".cpp" || text.right(3) == ".cc" 
	|| text.right(2) == ".C" || text.right(2) == ".c")){
    KMsgBox::message(this,"Error...","The filename must end with .cpp,.c,.cc or .C !"
		     ,KMsgBox::EXCLAMATION);
    return;
  }
  if ( (fileType() == "HEADER") && (text.right(2) != ".h")){
    KMsgBox::message(this,"Error...","The filename must end with .h !",KMsgBox::EXCLAMATION);
    return;
  }
  if ( (fileType() == "LSM") && (text.right(4) != ".lsm")){
    KMsgBox::message(this,"Error...","The filename must end with .lsm !",KMsgBox::EXCLAMATION);
    return;
   }
  if ( (fileType() == "KDELNK") && (text.right(7) != ".kdelnk")){
    KMsgBox::message(this,"Error...","The filename must end with .kdelnk !",KMsgBox::EXCLAMATION);
    return;
  }
  if ( (fileType() == "SGML") && (text.right(5) != ".sgml")){
    KMsgBox::message(this,"Error...","The filename must end with .sgml !",KMsgBox::EXCLAMATION);
    return;
  }
   if (text.isEmpty()){
     KMsgBox::message(this,"Error...","You must enter a filename!",KMsgBox::EXCLAMATION);
     return;
   }
   accept();
}
QString CNewFileDlg::fileName(){
  return edit->text();
}
QString CNewFileDlg::fileType(){ 
  QString str;
  if (current == 0){ // cpp/header
    str = list_cpp->text(list_cpp->currentItem());
    if (str == "C/C++ File (*.cpp,*.c,*.cc,*.C) - Impl. File"){
      return "CPP";
    }
    if (str == "Header (*.h) - a C/C++ Header File"){
      return "HEADER";
    }
    if (str == "Empty Textfile"){
      return "TEXTFILE";
    }
  }
  if (current == 1){ // GNU
    str = list_gnu->text(list_gnu->currentItem());
    return str;
  }
  
  if (current == 2){ // linux
    str = list_linux->text(list_linux->currentItem());
    if (str == "lsm-File (.lsm) - for the Linux Software Map"){
      return "LSM";
    }
  }
  if (current == 3){ // kde
    str = list_kde->text(list_kde->currentItem());
    if (str == "Link-File (.kdelnk) - for the K-Menu"){
      return "KDELNK";
    }
    if (str == "sgml-File (.sgml) - for the User-Manual"){
      return "SGML";
    }
  }
  return "TEST";
}
bool CNewFileDlg::useTemplate(){
  return check_use_template->isChecked();
}
bool CNewFileDlg::addToProject(){
  return check_add_to_project->isChecked();
}
void CNewFileDlg::setUseTemplate(){
  check_use_template->setChecked(true);
}
void CNewFileDlg::setAddToProject(){
  check_add_to_project->setChecked(true);
}
