#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "skel.h"

Skel::Skel(){
  init();
}
Skel::~Skel(){
}
void Skel::init(){  
  // create the main widget for skel, replace this with your own widgetclass
  view = new QWidget(this,"view");  
  setView(view);
  initMenu();
  initToolbar();
  initStatusBar();  
}
void Skel::initMenu(){
  // build the file menu
  QPopupMenu* p = new QPopupMenu;
  p->insertItem(i18n("&New"), this, SLOT(slotFileNew()), CTRL+Key_N);
  p->insertItem(i18n("&Open"), this, SLOT(slotFileOpen()), CTRL+Key_O);
  p->insertItem(i18n("&Save"), this, SLOT(slotFileSave()), CTRL+Key_S);
  p->insertItem(i18n("Save &As"), this, SLOT(slotFileSaveAs()));
  p->insertSeparator();
  p->insertItem(i18n("&Quit"), kapp, SLOT(quit()), CTRL+Key_Q);

  // put the popupmenu as File-menu into the menu bar
  menuBar()->insertItem(i18n("&File"), p);
  menuBar()->insertSeparator();

  // build the edit menu
  p = new QPopupMenu;
  p->insertItem(i18n("C&ut"), this, SLOT(slotEditCut()), CTRL+Key_X);
  p->insertItem(i18n("&Copy"), this, SLOT(slotEditCopy()), CTRL+Key_C);
  p->insertItem(i18n("&Paste"), this, SLOT(slotEditPaste()), CTRL+Key_V);
  
  menuBar()->insertItem(i18n("&Edit"), p);
  menuBar()->insertSeparator();
  
  // build the view menu
  p = new QPopupMenu;
  p->insertItem(i18n("Toogle &Toolbar"),this, SLOT(slotViewTToolbar()),CTRL+Key_T);
  p->insertItem(i18n("Toogle Status&bar"),this, SLOT(slotViewTStatusbar()),CTRL+Key_B);

  menuBar()->insertItem(i18n("&View"), p);
  menuBar()->insertSeparator();

  // generate the help menu
  p = kapp->getHelpMenu(true, i18n("Skel Version 0.1  \n\n"
				   "(c) 1998 AUTHOR\n"));
  menuBar()->insertItem(i18n("&Help"), p);
}
void Skel::initToolbar(){

  // build a toolbar and insert some buttons
  toolBar()->insertButton(Icon("filenew.xpm"),TOOLBAR_NEW, true,i18n("New"));
  toolBar()->insertButton(Icon("fileopen.xpm"),TOOLBAR_OPEN, true,i18n("Open File"));
  toolBar()->insertButton(Icon("filefloppy.xpm"),TOOLBAR_SAVE,true,i18n("Save File"));

  toolBar()->insertSeparator();
  toolBar()->insertButton(Icon("editcopy.xpm"),TOOLBAR_COPY, true,i18n("Copy"));
  toolBar()->insertButton(Icon("editpaste.xpm"),TOOLBAR_PASTE, true,i18n("Paste"));
  toolBar()->insertButton(Icon("editcut.xpm"),TOOLBAR_CUT,true,i18n("Cut"));
  
  connect(toolBar(), SIGNAL(clicked(int)), SLOT(slotToolbarClicked(int)));
}
void Skel::initStatusBar(){
  statusBar()->insertItem(i18n("ready"),STATUSBAR_TEXT);
}
void Skel::slotFileNew(){
  statusBar()->changeItem(i18n("ready"),STATUSBAR_TEXT);
}
void Skel::slotFileOpen(){
  KFileDialog::getOpenFileName();
  statusBar()->changeItem(i18n("ready"),STATUSBAR_TEXT);
}
void Skel::slotFileSave(){
  statusBar()->changeItem(i18n("file saved"),STATUSBAR_TEXT);
}
void Skel::slotFileSaveAs(){
  QString name =  KFileDialog::getSaveFileName();
}
void Skel::slotEditCut(){
}
void Skel::slotEditCopy(){
}
void Skel::slotEditPaste(){
}
void Skel::slotViewTToolbar(){
  enableToolBar();
}
void Skel::slotViewTStatusbar(){
  enableStatusBar();
}
void Skel::slotToolbarClicked(int item){
  switch (item) {
  case TOOLBAR_NEW:
    slotFileNew();
    break;
  case TOOLBAR_OPEN:
    slotFileOpen();
    break;
  case TOOLBAR_SAVE:
    slotFileSave();
    break;
  case TOOLBAR_COPY:
    slotEditCopy();
    break;
  case TOOLBAR_PASTE:
    slotEditPaste();
    break;
  case TOOLBAR_CUT:
    slotEditCut();
    break;
  }
}
