#include "ukTracker.h"

void preServerStartup( void )
{
	int	i;

	for(i = 0; i < 255; i++)
	{
		memset(trk[i].srv_name, 0, 40);
		memset(trk[i].srv_ip, 0, 20);
		trk[i].srv_port	= 0;
		trk[i].srv_mcli	= 0;
		trk[i].srv_cli	= 0;
		trk[i].id	= -1;
	}
}

void preServerShutdown( void )
{
}

void postServerShutdown( int sig )
{
}

void midcheckServer( void )
{
}

int findServer( int id )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (trk[i].id == id)
			return	i;

	return	-1;
}
	
static int addServer( struct tracking_information *tmptrk )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (trk[i].srv_port == 0)
		{
			sprintf(trk[i].srv_name, tmptrk->srv_name);
			sprintf(trk[i].srv_ip, tmptrk->srv_ip);
			trk[i].srv_port	= tmptrk->srv_port;
			trk[i].srv_mcli	= tmptrk->srv_mcli;
			trk[i].srv_cli	= tmptrk->srv_cli;
			trk[i].id 	= tmptrk->id;

			return	1;
		}

	return	0;
}

static void delServer( int sock )
{
	int	i;

	if ((i = findServer(sock)) == -1)
		return;

	memset(trk[i].srv_name, 0, 40);
	memset(trk[i].srv_ip, 0, 20);
	trk[i].srv_port	= 0;
	trk[i].srv_mcli	= 0;
	trk[i].srv_cli	= 0;
	trk[i].id	= -1;
}

static void killServer( int sock )
{
	int	i;

	if ((i = findServer(sock)) == -1)
		return;

	addLog("(%3i) Del: %s (%s:%i)", sock,
		trk[i].srv_name, trk[i].srv_ip,
		trk[i].srv_port);

	memset(trk[i].srv_name, 0, 40);
	memset(trk[i].srv_ip, 0, 20);
	trk[i].srv_port	= 0;
	trk[i].srv_mcli	= 0;
	trk[i].srv_cli	= 0;
	trk[i].id	= -1;
}

void updServer( int sock, int cli )
{
	trk[findServer(sock)].srv_cli = cli;
	return;
}

static void parseAddServer( char *buf, struct tracking_information *tmptrk )
{
	char	tmpbuf[10];

	getNext(buf, tmptrk->srv_name);
	getNext(buf, tmptrk->srv_ip);
	getNext(buf, tmpbuf); tmptrk->srv_port = atoi(tmpbuf);
	getNext(buf, tmpbuf); tmptrk->srv_mcli = atoi(tmpbuf);
	tmptrk->srv_cli = atoi(buf);
}

static void parseUpdServer( char *buf, struct tracking_information *tmptrk )
{
	tmptrk->srv_cli = atoi(buf);
}

static void lstServer( int sock )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (trk[i].srv_port != 0)
			sockSend(cli[sock].sock, "%i;%s;%s;%i;%i;%i",
				PKT_LST, trk[i].srv_name, trk[i].srv_ip,
				trk[i].srv_port,
				trk[i].srv_cli, trk[i].srv_mcli);
}

void processPacket( int id, int sock, char *buf )
{
	struct tracking_information	tmptrk;
	int				sw;

	getNext(buf, temp_buffer);
	sw = atoi(temp_buffer);

	switch(sw)
	{
	case PKT_ADD:
		parseAddServer(buf, &tmptrk);
		tmptrk.id = sock;
		if (addServer(&tmptrk))
		{
			sockSend(cli[sock].sock, "%i;%i", PKT_ADD, PKT_OK);
			addLog("(%3i) Add: %s (%s:%i)", sock,
				tmptrk.srv_name, tmptrk.srv_ip,
				tmptrk.srv_port);
		}
		else
		{
			sockSend(cli[sock].sock, "%i;%i", PKT_ADD, PKT_ERR);
			addLog("Failed to add server, too many connected.");
		}
		break;
	case PKT_DEL:
		addLog("(%3i) Del: %s (%s:%i)", sock,
			trk[sock].srv_name, trk[sock].srv_ip,
			trk[sock].srv_port);
		delServer(sock);
		break;
	case PKT_UPD:
		parseUpdServer(buf, &tmptrk);
		updServer(sock, tmptrk.srv_cli);
		break;
	case PKT_LST:
		lstServer(sock);
		sockSend(cli[sock].sock, "%i", PKT_OK);
		break;
	}
}

void ProgramProcess( int id, int sock, char *buf )
{
	switch (id)
	{
	case SERVER_CONNECTED:
		addLog("(%3i) Connect from %s.", sock, cli[sock].from);
		break;
	case SERVER_DISCONNECT:
		killServer(sock);
		addLog("(%3i) Disconnect.", sock);
		sockClose(sock);
		break;
	case SERVER_DATARDY:
		processPacket(id, sock, buf);
		memset(buf, 0, 1024);
		break;
	}
}
