#include "ukServer.h"

static void sendAll( char *msg, ... )
{
	unsigned char	buffer[1024];
	va_list		va;
	int	i;

	va_start(va, msg);
	vsnprintf(buffer, 1024, msg, va);
	va_end(va);

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (cli[i].sock != -1)
			sockSend(cli[i].sock, buffer);
}

static void sendAllLevel( int lvl, char *msg, ... )
{
	unsigned char	buffer[1024];
	va_list		va;
	int	i;

	va_start(va, msg);
	vsnprintf(buffer, 1024, msg, va);
	va_end(va);

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (cli[i].sock != -1 && uI[i].level == lvl)
			sockSend(cli[i].sock, buffer);
}

static int findMonster( int x, int y, int l )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].posX == x && MONSTER[i].posY == y
			&& MONSTER[i].level == l)
			return	i;

	return	-1;
}

static void deleteMonster( int num )
{
	int	i;

	MONSTER[num].monIndex = -1;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (uI[i].level == MONSTER[num].level)
			sockSend(cli[i].sock, "%i;%i;-1", PKT_MON, num);
}

static int checkLevel( int cL, int cX )
{
	if (cX >= expTable[cL + 1])
		return	1;

	return	0;
}

static void sendUpdate( int sock )
{
	if (checkLevel(uI[sock].ad.level + 1, uI[sock].ad.exp))
	{
		uI[sock].ad.hp += (uI[sock].ad.hp * 0.14) + 1;
		uI[sock].ad.mp += (uI[sock].ad.mp * 0.14) + 1;
		uI[sock].ad.str += CLASS[uI[sock].ad.class].incStr;
		uI[sock].ad.def += CLASS[uI[sock].ad.class].incDef;
		uI[sock].ad.mag += CLASS[uI[sock].ad.class].incMag;
		uI[sock].ad.spd += CLASS[uI[sock].ad.class].incSpd;
		uI[sock].ad.level++;
	}

	sockSend(cli[sock].sock, "%i;%i;%lu;%i;%i",
		PKT_CUP,
		uI[sock].ad.level, uI[sock].ad.exp,
		uI[sock].ad.hp, uI[sock].ad.mp);
}

static void attackMonster( int num, int sock )
{
	int	t;
	float	a, b;

	t = MONSTER[num].monIndex;

	if (uI[sock].ad.spd <= MONS[t].spd)
		if ((rand()%100) < 25)
			return;

	MONSTER[num].curHP -= 30;

	if (MONSTER[num].curHP <= 0)
	{
		sockSend(cli[sock].sock, "%i;%i experience!",
			PKT_NFO, MONS[MONSTER[num].monIndex].experience);

		uI[sock].ad.exp += MONS[MONSTER[num].monIndex].experience;
		deleteMonster(num);
		sendUpdate(sock);
	}
	else
	{
		a = (float)MONS[MONSTER[num].monIndex].hp / 100;
		b = (float)MONSTER[num].curHP / a;
		sendAllLevel(uI[sock].level, "%i;%i;%f", PKT_HIT, num, b);
	}

}

static void createMonster( int type, int l, int x, int y, int sock )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].monIndex == -1)
		{
			MONSTER[i].monIndex	= type;
			MONSTER[i].level	= l;
			MONSTER[i].posX		= x;
			MONSTER[i].posY		= y;
			MONSTER[i].curHP	= MONS[type].hp;
			MONSTER[i].curMP	= MONS[type].mp;
			MONSTER[i].attack	= MONS[type].attack;
			MONSTER[i].seek		= -1;

			sockSend(cli[sock].sock,
				"%i;%i;%i;%i;%i;%i;%i",
				PKT_MON, i,
				MONS[type].gfx, MONS[type].color,
				MONSTER[i].posX, MONSTER[i].posY, 0);

			return;
		}
}

static void processNpc1( FILE *fd, int sock )
{
	char	tmpbuf[512];

	while(fgets(tmpbuf, 512, fd))
	{
		if (strlen(tmpbuf))
			tmpbuf[strlen(tmpbuf)-1] = 0;

		if (!strncasecmp(tmpbuf, "END", 3))
		{
			sockSend(cli[sock].sock, "%i;%i", PKT_CMN, CMN_END);
			return;
		}

		sockSend(cli[sock].sock, "%i;%i;%s", PKT_CMN, CMN_TEXT, tmpbuf);
	}
}

static void sendNpcTalk( int i, char *filename, int num, int sock )
{
	FILE	*fd;
	char	tmpbuf[512], tmpbuf2[10], tmpbuf3[10], fn[20];

	sprintf(fn, "%s%s", TEXT_DIR, filename);
	if ((fd = fopen(fn, "r")) == NULL)
		return;

	while(fgets(tmpbuf, 512, fd))
	{
		if (!strncasecmp(tmpbuf, "BEGIN ", 6))
		{
			strcpy(tmpbuf, tmpbuf + 7);
			sscanf(tmpbuf, "%s %s", tmpbuf2, tmpbuf3);

			if (atoi(tmpbuf2) != num)
				break;

			sockSend(cli[sock].sock, "%i;%s",
				PKT_NFO, NPCS[i].name);
			sockSend(cli[sock].sock, "%i;%i;%s;%i",
				PKT_CMN, CMN_START, tmpbuf3, i);

			if (atoi(tmpbuf3) == 1)
				processNpc1(fd, sock);
		}
	}

	fclose(fd);
}

static void processPlayerTalk( int l, int x, int y, int sock )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (uI[i].posX == x && uI[i].posY == y
			&& uI[i].level == l)
		{
			sockSend(cli[sock].sock, "%i;%s",
				PKT_NFO, uI[i].name);
			sockSend(cli[sock].sock, "%i;%s",
				PKT_NFO, uI[i].ad.info);
		}
}

static void processNpcTalk( int l, int x, int y, int sock )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
		if (npcM[i].posX == x && npcM[i].posY == y && NPCS[i].level == l)
			sendNpcTalk(i, NPCS[i].npcfile, 1, sock);
}

static void processMonsterTalk( int l, int x, int y, int sock )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].posX == x && MONSTER[i].posY == y
			&& MONSTER[i].level == l)
			sockSend(cli[sock].sock, "%i;%s",
				PKT_NFO, MONS[MONSTER[i].monIndex].name);
}

static void sendAllNpc( int sock )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
		if (NPCS[i].level == uI[sock].level)
			sockSend(cli[sock].sock,
				"%i;%i;%s;%i;%i;%i;%i;%i;%i;%i",
				PKT_NPC, i,
				NPCS[i].name, NPCS[i].gfx,
				NPCS[i].armor, NPCS[i].helm,
				npcM[i].posX, npcM[i].posY, NPCS[i].level, 0);
}

static void sendAllMonsters( int sock )
{
	int	i, k;


	for(i = 0; i < MAXMONS; i++)
	{
		k = MONSTER[i].monIndex;
		if (MONSTER[i].monIndex != -1 && MONSTER[i].level == uI[sock].level)
			sockSend(cli[sock].sock,
				"%i;%i;%i;%i;%i;%i;%i",
				PKT_MON, i,
				MONS[k].gfx, MONS[k].color,
				MONSTER[i].posX, MONSTER[i].posY, 0);
	}
}

static void initNpc( void )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
		if (NPCS[i].delay)
		{
			npcM[i].posX = NPCS[i].startx;
			npcM[i].posY = NPCS[i].starty;
			npcM[i].time = 0;
		}
}

static void initMonsters( void )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
	{
		MONSTER[i].time		= 0;
		MONSTER[i].monIndex	= -1;
	}
}

static int loadMap( char *filename, int num )
{
	FILE	*fd;
	int	i, j;

	if ((fd = fopen(filename, "r")) == NULL)
		return	0;

	MAPS[num].X = (unsigned char)fgetc(fd);
	MAPS[num].Y = (unsigned char)fgetc(fd);

	for(i = 0; i < MAPS[num].Y; i++)
		for(j = 0; j < MAPS[num].X; j++)
			MAPS[num].data[(i * MAPS[num].X) + j] = fgetc(fd);

	fclose(fd);

	return	1;
}

static int loadMaps( void )
{
	FILE	*fd;
	char	fn[20], tmpbuf[512];
	int	cnt = 0;

	sprintf(fn, "%s%s", MAP_DIR, MAP_DATA);
	if ((fd = fopen(fn, "r")) == NULL)
		return	0;

	while(fgets(tmpbuf, 512, fd))
	{
		cnt++;
		tmpbuf[strlen(tmpbuf)-1] = 0;
		sprintf(fn, "%s%s", MAP_DIR, tmpbuf);
		if (!loadMap(fn, cnt))
			return	0;

		memset(tmpbuf, 0, 512);
	}

	fclose(fd);

	return	1;
}

static int connectTracker( char *host, int port )
{
	struct sockaddr_in	server;
	struct hostent		*lookup;
	int			tempsock;

	if ((lookup = gethostbyname(host)) == NULL)
		return	-1;

	memset((char *)&server, 0, sizeof(server));
	memcpy(&server.sin_addr, lookup->h_addr, lookup->h_length);

	server.sin_family	= AF_INET;
	server.sin_port		= htons(port);

	if ((tempsock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
		return	-1;

	if (connect(tempsock, (struct sockaddr *)&server, sizeof(server)) == -1)
		return	-1;

        return	tempsock;
}

static void addSrv( int sock )
{
	sockSend(sock, "%i;%s;%s;%i;%i;%i", PKT_ADD,
		SERVER_DESC, SERVER_IP, SERVER_PORT, SERVER_CLIENTS, 0);
}

static void delSrv( int sock )
{
	sockSend(sock, "%i", PKT_DEL);
}

void preServerStartup( void )
{
	int	i;

	for(i = 0; i < 255; i++)
	{
		memset(uI[i].id, 0, 20);
		memset(uI[i].badid, 0, 20);
		memset(uI[i].name, 0, 13);
		uI[i].loggedin	= 0;
		uI[i].posX	= 0;
		uI[i].posY	= 0;
		uI[i].facing	= 0;
		memset(&uI[i].ai, 0, sizeof(uI[i].ai));
		memset(&uI[i].ad, 0, sizeof(uI[i].ad));
	}

	for(i = 0; i < NPCCNT; i++)
	{
		npcM[i].posX	= 0;
		npcM[i].posY	= 0;
		npcM[i].time	= 0;
	}

	if ((temp_sock = connectTracker(TRK_IP, TRK_PORT)) == -1)
	{
		addLog("Unable to connect to Tracking Server.");
		return;
	}

	addLog("Connected to Tracking Server: sending information.");
	addSrv(temp_sock);

	clearArmorStuff();	initArmorStuff();
	clearHelmStuff();	initHelmStuff();
	clearClassStuff();	initClassStuff();
	clearLandStuff();	initLandStuff();
	clearSpellStuff();	initSpellStuff();
	clearNpcStuff();	initNpcStuff();
	clearWarpStuff();	initWarpStuff();
	clearMonsterStuff();	initMonsterStuff();


	if (!loadMaps())
		addLog("Unable to load maps!");

	initNpc();
	initMonsters();
}

void preServerShutdown( void )
{
}

void postServerShutdown( int sig )
{
	delSrv(temp_sock);
}

static int parseAddServer( char *buf )
{
	return	atoi(buf);
}

static void showMap( int sock )
{
	if (uI[sock].posX < 1)
		uI[sock].posX = 0;
	if (uI[sock].posX > 126)
		uI[sock].posX = MAPM_X;
	if (uI[sock].posY < 1)
		uI[sock].posY = 0;
	if (uI[sock].posY > 126)
		uI[sock].posY = MAPM_Y;

	sockSend(cli[sock].sock, "%i;%i;%i;%i",
		PKT_MOV, uI[sock].posX, uI[sock].posY, uI[sock].level);
}

static int processLogin( int sock, char *buf )
{
	int			r;
	char			tmpID[20], tmpPW[20];
	accountInformation	db;

	memset(tmpID, 0, 20);
	memset(tmpPW, 0, 20);

	getNext(buf, tmpID);
	getNext(buf, tmpPW);

	if (!strlen(tmpID) || !strlen(tmpPW))
	{
		sprintf(uI[sock].badid, "[NONE]");
		return	PKT_ERR;
	}

	if ((r = searchInformation(tmpID, &db)) == -1)
	{
		sprintf(uI[sock].badid, "%s", tmpID);
		return	PKT_ERR;
	}

	if (strcasecmp(db.pass, tmpPW))
	{
		sprintf(uI[sock].badid, "%s", tmpID);
		return	PKT_ERR;
	}

	memcpy(&uI[sock].ai, &db, sizeof(db));

	sprintf(uI[sock].id, "%s", tmpID);
	return	PKT_OK;
}

static int processNew( int sock, char *buf )
{
	int			r;
	char			tmpID[20], tmpPW[20];
	accountInformation	db;

	memset(tmpID, 0, 20);
	memset(tmpPW, 0, 20);

	getNext(buf, tmpID);
	getNext(buf, tmpPW);

	if (!strlen(tmpID) || !strlen(tmpPW))
	{
		sprintf(uI[sock].badid, "[NONE]");
		return	PKT_ERR;
	}

	if ((r = searchInformation(tmpID, &db)) != -1)
	{
		sprintf(uI[sock].badid, "%s", tmpID);
		return	PKT_ERR;
	}

	sprintf(uI[sock].ai.id, "%s", tmpID);
	sprintf(uI[sock].ai.pass, "%s", tmpPW);
	uI[sock].ai.created = time(NULL);

	for(r = 0; r < 5; r++)
		uI[sock].ai.idS[r] = -1;

	if (!addInformation(&uI[sock].ai, -1))
	{
		sprintf(uI[sock].badid, "%s", tmpID);
		return	PKT_ERR;
	}

	sprintf(uI[sock].id, "%s", tmpID);
	return	PKT_OK;
}

static int processCreate( int sock, char *buf )
{
	int			i, r, C, ok = 0, nameNum, infoNum;
	char			tmpName[12], tmpDesc[20], tmpClass[3];
	accountDatabase		db;

	memset(tmpName, 0, 12);
	memset(tmpDesc, 0, 20);

	for(r = 0; r < 5; r++)
		if (uI[sock].ai.idS[r] == -1)
			ok = 1;

	if (!ok)
	{
		sprintf(uI[sock].badid, "[NONE]");
		return	PKT_ERR;
	}

	getNext(buf, tmpName);
	getNext(buf, tmpDesc);
	getNext(buf, tmpClass);
	C = atoi(tmpClass) - 1;

	if ((strlen(tmpName) < 2))
	{
		sprintf(uI[sock].badid, "[NONE]");
		return	PKT_ERR;
	}

	if (searchDatabase(tmpName, &db) != -1)
	{
		sprintf(uI[sock].badid, "%s", tmpName);
		return	PKT_ERR;
	}

	memset(&uI[sock].ad, 0, sizeof(accountDatabase));
	sprintf(uI[sock].ad.name, "%s", tmpName);
	sprintf(uI[sock].ad.info, "%s", tmpDesc);
	uI[sock].ad.timeOnline		= 0;
	uI[sock].ad.timesConnect	= 1;
	uI[sock].ad.created		= time(NULL);
	uI[sock].ad.class		= C;
	uI[sock].ad.str			= CLASS[C].startStr;
	uI[sock].ad.def			= CLASS[C].startDef;
	uI[sock].ad.mag			= CLASS[C].startMag;
	uI[sock].ad.spd			= CLASS[C].startSpd;
	uI[sock].ad.hp			= CLASS[C].startHp;
	uI[sock].ad.curhp		= CLASS[C].startHp;
	uI[sock].ad.mp			= CLASS[C].startMp;
	uI[sock].ad.curmp		= CLASS[C].startMp;
	uI[sock].ad.level		= 1;
	uI[sock].ad.exp			= 1;
	uI[sock].ad.left		= 0;
	uI[sock].ad.right		= 0;
	uI[sock].ad.armor		= 0;
	uI[sock].ad.helm		= 0;
	uI[sock].ad.itemA		= 0;
	uI[sock].ad.itemB		= 0;
	uI[sock].ad.boots		= 0;
	uI[sock].ad.neck		= 0;
	uI[sock].ad.skillA		= 0;
	uI[sock].ad.skillB		= 0;
	uI[sock].ad.skillC		= 0;
	uI[sock].ad.posLevel		= 1;
	uI[sock].ad.posX		= 4;
	uI[sock].ad.posY		= 4;
	uI[sock].ad.sysop		= 0;

	for(i = 0; i < 26; i++)	
		uI[sock].ad.inventory[0][i]	= 0;
	for(i = 0; i < 26; i++)	
		uI[sock].ad.inventory[1][i]	= 0;
	for(i = 0; i < 26; i++)	
		uI[sock].ad.inventory[2][i]	= 0;

	for(i = 0; i < 26; i++)	
		uI[sock].ad.spells[i]	= 0;

	if (!addDatabase(&uI[sock].ad, -1))
	{
		sprintf(uI[sock].badid, "%s", tmpName);
		return	PKT_ERR;
	}

	sprintf(uI[sock].name, "%s", tmpName);

	memset(&uI[sock].ad, 0, sizeof(accountDatabase));
	memset(&uI[sock].ai, 0, sizeof(accountInformation));

	nameNum = searchDatabase(tmpName, &uI[sock].ad);
	infoNum = searchInformation(uI[sock].id, &uI[sock].ai);

	for(i = 0; i < 5; i++)
		if (uI[sock].ai.idS[i] == -1)
		{
			uI[sock].ai.idS[i] = nameNum;
			addInformation(&uI[sock].ai, infoNum);
			return	PKT_OK;
		}

	return	PKT_OK;
}

static void showPlayerList( int sock )
{
	int		i;
	accountDatabase	db;

	for(i = 0; i < 5; i++)
		if (uI[sock].ai.idS[i] != -1)
			if (lookupDatabase(uI[sock].ai.idS[i], &db))
				sockSend(cli[sock].sock,
					"%i;%i;%s;%s;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%lu;%i;%i;%i",
					PKT_PLT, i, db.name, db.info, db.class,
					db.str, db.def, db.mag, db.spd,
					db.hp, db.curhp, db.mp, db.curmp,
					db.level, db.exp,
					db.armor, db.helm, db.sysop);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static void showClassList( int sock )
{
	int		i;

	for(i = 0; i < 10; i++)
		if (CLASS[i].startHp)
			sockSend(cli[sock].sock,
				"%i;%i;%s;%s;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i;%i",
				PKT_CLS, i, CLASS[i].name, CLASS[i].desc,
				CLASS[i].gfx,
				CLASS[i].startHp, CLASS[i].startMp,
				CLASS[i].startStr, CLASS[i].startDef,
				CLASS[i].startMag, CLASS[i].startSpd,
				CLASS[i].incStr, CLASS[i].incDef,
				CLASS[i].incMag, CLASS[i].incSpd);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static void showLandList( int sock )
{
	int		i;

	for(i = 0; i < numLand; i++)
		sockSend(cli[sock].sock, "%i;%i;%i",
			PKT_LND, i, landType[i].type);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static void showArmorList( int sock )
{
	int		i;

	for(i = 0; i < ARMORCNT; i++)
		if (ARMORS[i].color)
			sockSend(cli[sock].sock, "%i;%i;%s;%i;%i",
				PKT_ARM, i,
				ARMORS[i].name, ARMORS[i].color, ARMORS[i].ac);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static void showHelmList( int sock )
{
	int		i;

	for(i = 0; i < HELMCNT; i++)
		if (HELMS[i].color)
			sockSend(cli[sock].sock, "%i;%i;%s;%i;%i",
				PKT_HLM, i,
				HELMS[i].name, HELMS[i].color, HELMS[i].ac);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static void showSpellList( int sock )
{
	int		i;

	for(i = 0; i < SPELLCNT; i++)
		if (SPELLS[i].active)
			sockSend(cli[sock].sock, "%i;%i;%s;%i;%i;%i;%i;%i;%i",
				PKT_SPL, i,
				SPELLS[i].name, SPELLS[i].type,
				SPELLS[i].effect, SPELLS[i].modifier,
				SPELLS[i].class, SPELLS[i].battleonly,
				SPELLS[i].gfx, SPELLS[i].mana);

	sockSend(cli[sock].sock, "%i", PKT_OK);
}

static int totalOnline( void )
{
	int	i, cnt = 0;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (cli[i].sock != -1)
			cnt++;

	return	cnt;
}

static void refresh( int type, int sock )
{
	if (!uI[sock].ad.sysop)
	{
		sockSend(cli[sock].sock, "%i;Not Game Master.", PKT_NFO);
		return;
	}

	switch(type)
	{
	case RFH_NPC:
		addLog("Refreshing NPC [%s]", uI[sock].name);
		clearNpcStuff();
		initNpcStuff();
		initNpc();
		sockSend(cli[sock].sock, "%i;Refreshed NPC", PKT_NFO);
		sendAll("%i;%i", PKT_CLR, RFH_NPC);
		break;
	case RFH_MON:
		addLog("Refrshing MON [%s]", uI[sock].name);
		clearMonsterStuff();
		initMonsterStuff();
		initMonsters();
		sockSend(cli[sock].sock, "%i;Refreshed MON", PKT_NFO);
		sendAll("%i;%i", PKT_CLR, RFH_MON);
		break;
	case RFH_ITEM:
		break;
	case RFH_HELM:
		addLog("Refreshing HELM [%s]", uI[sock].name);
		clearHelmStuff();
		initHelmStuff();
		sockSend(cli[sock].sock, "%i;Refreshed HELM", PKT_NFO);
		break;
	case RFH_ARMOR:
		addLog("Refreshing ARMOR [%s]", uI[sock].name);
		clearArmorStuff();
		initArmorStuff();
		sockSend(cli[sock].sock, "%i;Refreshed ARMOR", PKT_NFO);
		break;
	case RFH_LAND:
		addLog("Refreshing LAND [%s]", uI[sock].name);
		clearLandStuff();
		initArmorStuff();
		sockSend(cli[sock].sock, "%i;Refreshed LAND", PKT_NFO);
		break;
	case RFH_WARP:
		addLog("Refreshing WARP [%s]", uI[sock].name);
		clearWarpStuff();
		initWarpStuff();
		sockSend(cli[sock].sock, "%i;Refreshed WARP", PKT_NFO);
		break;
	case RFH_MAPS:
		addLog("Refreshing MAPS [%s]", uI[sock].name);
		loadMaps();
		sockSend(cli[sock].sock, "%i;Refreshed MAPS", PKT_NFO);
		break;
	}
}

static int checkPass( int x, int y, int l )
{
	int	i;

	if (x < 0)
		return	0;

	if (x >= MAPS[l].X)
		return	0;

	if (y < 0)
		return	0;

	if (y >= MAPS[l].Y)
		return	0;

	if (landType[MAPS[l].data[(y * MAPS[l].X) + x]].type)
		return	0;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (uI[i].posX == x && uI[i].posY == y && uI[i].level == l)
			return	0;

	for(i = 0; i < NPCCNT; i++)
		if (npcM[i].posX == x && npcM[i].posY == y && NPCS[i].level == l)
			return	0;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].monIndex != -1
			&& MONSTER[i].posX == x && MONSTER[i].posY == y
			&& MONSTER[i].level == l)
			return	0;

	return	1;
}

static int moveRandom( int num )
{
	int	i;

	if (!NPCS[num].roam)
		return	-1;

	i = rand()%4;

	if (i == 0)
	{
		if (checkPass(npcM[num].posX-1, npcM[num].posY, NPCS[num].level))
			npcM[num].posX--;

		return	6;
	}
	else if (i == 1)
	{
		if (checkPass(npcM[num].posX, npcM[num].posY-1, NPCS[num].level))
			npcM[num].posY--;

		return	4;
	}
	else if (i == 2)
	{
		if (checkPass(npcM[num].posX+1, npcM[num].posY, NPCS[num].level))
			npcM[num].posX++;

		return	2;
	}
	else if (i == 3)
	{
		if (checkPass(npcM[num].posX, npcM[num].posY+1, NPCS[num].level))
			npcM[num].posY++;

		return	0;
	}

	return	-1;
}

static int moveMonster( int num )
{
	int	i, k;

	i = rand()%4;
	k = MONSTER[num].monIndex;

	if (i == 0)
	{
		if (checkPass(MONSTER[num].posX-1, MONSTER[num].posY, MONSTER[num].level))
			MONSTER[num].posX--;

		return	6;
	}
	else if (i == 1)
	{
		if (checkPass(MONSTER[num].posX, MONSTER[num].posY-1, MONSTER[num].level))
			MONSTER[num].posY--;

		return	4;
	}
	else if (i == 2)
	{
		if (checkPass(MONSTER[num].posX+1, MONSTER[num].posY, MONSTER[num].level))
			MONSTER[num].posX++;

		return	2;
	}
	else if (i == 3)
	{
		if (checkPass(MONSTER[num].posX, MONSTER[num].posY+1, MONSTER[num].level))
			MONSTER[num].posY++;

		return	0;
	}

	return	-1;
}

static void moveNpc( void )
{
	int	i, moved;
	long	t;

	if (!totalOnline())
		return;

	t = time(NULL);

	for(i = 0; i < NPCCNT; i++)
		if (NPCS[i].delay && ((t-npcM[i].time) >= NPCS[i].delay))
		{
			npcM[i].time = t;

			moved = moveRandom(i);

			sendAllLevel(NPCS[i].level,
				"%i;%i;%s;%i;%i;%i;%i;%i;%i;%i",
				PKT_NPC, i,
				NPCS[i].name, NPCS[i].gfx,
				NPCS[i].armor, NPCS[i].helm,
				npcM[i].posX, npcM[i].posY, NPCS[i].level,
				moved);
		}
}

static void moveMonsters( void )
{
	int	i, k, moved;
	long	t;

	if (!totalOnline())
		return;

	t = time(NULL);

	for(i = 0; i < MAXMONS; i++)
	{
		k = MONSTER[i].monIndex;
		if (MONSTER[i].monIndex != -1 && MONS[k].delay
			&& ((t-MONSTER[i].time) >= MONS[k].delay))
		{
			MONSTER[i].time = t;

			moved = moveMonster(i);

			sendAllLevel(MONSTER[i].level,
				"%i;%i;%i;%i;%i;%i;%i",
				PKT_MON, i,
				MONS[k].gfx, MONS[k].color,
				MONSTER[i].posX, MONSTER[i].posY,
				moved);
		}
	}
}

static int checkForPlayer( int X, int Y, int sock )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
		if (uI[i].posX == X && uI[i].posY == Y
			&& uI[i].level == uI[sock].level)
				return	1;

	return	0;
}

static int checkForNPC( int X, int Y, int sock )
{
	int	i;

	for(i = 0; i < NPCCNT; i++)
		if (npcM[i].posX == X && npcM[i].posY == Y
			&& NPCS[i].level == uI[sock].level)
				return	1;

	return	0;
}

static int checkForMonster( int X, int Y, int sock )
{
	int	i;

	for(i = 0; i < MAXMONS; i++)
		if (MONSTER[i].monIndex != -1
			&& MONSTER[i].posX == X
			&& MONSTER[i].posY == Y
			&& MONSTER[i].level == uI[sock].level)
				return	1;

	return	0;
}

static void checkUserWarp( int X, int Y, int L, int sock )
{
	int	i;

	for(i = 0; i < maxWarp; i++)
		if (warp[i].oldL == L
			&& warp[i].oldX-1 == X
			&& warp[i].oldY-1 == Y)
		{
			uI[sock].level = warp[i].newL;
			uI[sock].posX = warp[i].newX - 1;
			uI[sock].posY = warp[i].newY - 1;
			sendAll("%i;%i", PKT_CLR, RFH_NPC);
			sendAllNpc(sock);
			sendAllMonsters(sock);
			sendAll("%i;%i;%i", PKT_CLV, sock, uI[sock].level);
		}
}

static int checkUserOK( int X, int Y, int L )
{
	return landType[MAPS[L].data[(Y * MAPS[L].X) + X]].type;
}

static void processPacket( int id, int sock, char *buf )
{
	int		sw, ret, i, tmpX, tmpY, tmpL;
	char		tmpbuf[1024];
	accountDatabase	db;

	memset(tmpbuf, 0, 1024);

	getNext(buf, tmpbuf);
	sw = atoi(tmpbuf);

	switch(sw)
	{
	case PKT_ADD:
		ret = parseAddServer(buf);
		if (ret == PKT_OK)
			addLog("Tracker has accepted the server.");
		else if (ret == PKT_ERR)
			addLog("Tracking server was full, server declined.");
		break;
	case PKT_LGN:
		ret = processLogin(sock, buf);
		if (ret == PKT_OK)
		{
			addLog("ID Login: %s", uI[sock].id);
			sockSend(cli[sock].sock, "%i;%i", PKT_LGN, PKT_OK);
		}
		else if (ret == PKT_ERR)
		{
			addLog("ID Login: %s [FAILED]", uI[sock].badid);
			sockSend(cli[sock].sock, "%i;%i", PKT_LGN, PKT_ERR);
		}
		break;
	case PKT_NEW:
		ret = processNew(sock, buf);
		if (ret == PKT_OK)
		{
			addLog("ID Create: %s [OK]", uI[sock].id);
			sockSend(cli[sock].sock, "%i;%i", PKT_LGN, PKT_OK);
		}
		else if (ret == PKT_ERR)
		{
			addLog("ID Create: %s [FAILED]", uI[sock].badid);
			sockSend(cli[sock].sock, "%i;%i", PKT_LGN, PKT_ERR);
		}
		break;	
	case PKT_PLT:
		showPlayerList(sock);
		break;
	case PKT_CLS:
		showClassList(sock);
		break;
	case PKT_LND:
		showLandList(sock);
		break;
	case PKT_ARM:
		showArmorList(sock);
		break;
	case PKT_HLM:
		showHelmList(sock);
		break;
	case PKT_SPL:
		showSpellList(sock);
		break;
	case PKT_CRT:
		ret = processCreate(sock, buf);
		if (ret == PKT_OK)
		{
			addLog("CHAR Create: %s [OK]", uI[sock].name);
			sockSend(cli[sock].sock, "%i;%i", PKT_CRT, PKT_OK);
		}
		else if (ret == PKT_ERR)
		{
			addLog("CHAR Create: %s [FAILED]", uI[sock].badid);
			sockSend(cli[sock].sock, "%i;%i", PKT_CRT, PKT_ERR);
		}
		break;
	case PKT_GO:
		getNext(buf, tmpbuf);
		i = atoi(tmpbuf) - 1;
		ret = lookupDatabase(uI[sock].ai.idS[i], &uI[sock].ad);
		uI[sock].posX = uI[sock].ad.posX;
		uI[sock].posY = uI[sock].ad.posY;
		uI[sock].level = uI[sock].ad.posLevel;
		sprintf(uI[sock].name, uI[sock].ad.name);
		uI[sock].loggedin = 1;
		addLog("%s joined the game.", uI[sock].name);
		sendAllNpc(sock);
		sendAllMonsters(sock);
		sockSend(cli[sock].sock, "%i;%i", PKT_LVL, uI[sock].level);
		sockSend(cli[sock].sock, "%i;%i", PKT_GO, PKT_OK);
		sockSend(cli[sock].sock, "%i;%i;%i;Welcome to %s!\n",
			PKT_TLK, TLK_SERV, TLKcSERV, SERVER_DESC);
		sockSend(cli[sock].sock, "%i;%i;%i;There is currently %i people online.\n",
			PKT_TLK, TLK_SERV, TLKcSERV, totalOnline());
		sendAll("%i;%i;%i;%s has joined the game.",
			PKT_TLK, TLK_SERV, TLKcSERV, uI[sock].name);
		sendAll("%i;%i;%i;%s;%i;%i;%i;%i;%i", PKT_ENT, sock,
			uI[sock].ad.class,
			uI[sock].name,
			uI[sock].posX, uI[sock].posY, uI[sock].level,
			uI[sock].ad.armor, uI[sock].ad.helm);

		for(i = 0; i < SERVER_CLIENTS; i++)
			if (uI[i].loggedin && i != sock)
				sockSend(cli[sock].sock,
					"%i;%i;%i;%s;%i;%i;%i;%i;%i",
					PKT_ENT, i,
					uI[i].ad.class,
					uI[i].name,
					uI[i].posX, uI[i].posY, uI[i].level,
					uI[i].ad.armor, uI[i].ad.helm);

		sockSend(temp_sock, "%i;%i", PKT_UPD, totalOnline());
		break;
	case PKT_MOV:
		tmpX = uI[sock].posX;
		tmpY = uI[sock].posY;
		getNext(buf, tmpbuf); tmpX += atoi(tmpbuf);
		getNext(buf, tmpbuf); tmpY += atoi(tmpbuf);
		getNext(buf, tmpbuf); uI[sock].facing = atoi(tmpbuf);
		if (tmpX == uI[sock].posX && tmpY == uI[sock].posY)
			;
		else if (!checkUserOK(tmpX, tmpY, uI[sock].level))
		{
			uI[sock].posX = tmpX;
			uI[sock].posY = tmpY;
			checkUserWarp(uI[sock].posX, uI[sock].posY,
				uI[sock].level, sock);
		}
		showMap(sock);
		sendAllLevel(uI[sock].level, "%i;%i;%i;%i;%i;%i",
			PKT_PMV, sock,
			uI[sock].posX, uI[sock].posY,
			uI[sock].level, uI[sock].facing);
		break;
	case PKT_TLK:
		getNext(buf, tmpbuf); i = atoi(tmpbuf);
		if (i == PKT_TLK)
		{
			if (uI[sock].ad.sysop)
				sprintf(tmpbuf, "%i;%i;%i;%s",
					PKT_TLK, TLK_CHAR, TLKcGM, buf);
			else
				sprintf(tmpbuf, "%i;%i;%i;%s",
					PKT_TLK, TLK_CHAR, TLKcCHAR, buf);
			sendAll(tmpbuf);
		}
		else if (i == PKT_RFH)
		{
			getNext(buf, tmpbuf);
			refresh(atoi(tmpbuf), sock);
		}
		else if (i == PKT_MON)
		{
			getNext(buf, tmpbuf); i = atoi(tmpbuf);
			getNext(buf, tmpbuf); tmpL = atoi(tmpbuf);
			getNext(buf, tmpbuf); tmpX = atoi(tmpbuf);
			getNext(buf, tmpbuf); tmpY = atoi(tmpbuf);

			createMonster(i, tmpL, tmpX, tmpY, sock);

			sockSend(cli[sock].sock, "%i;Created %s",
				PKT_NFO, MONS[i].name);
		}
		break;
	case PKT_EXT:
		uI[sock].loggedin = 0;
		addLog("%s exiting game.", uI[sock].name);
		sendAll("%i;%i;%i;%s has left the game.",
			PKT_TLK, TLK_SERV, TLKcSERV, uI[sock].name);
		sendAll("%i;%i;-1", PKT_ENT, sock);
		sockSend(temp_sock, "%i;%i", PKT_UPD, totalOnline()-1);

		uI[sock].ad.posX = uI[sock].posX;
		uI[sock].ad.posY = uI[sock].posY;
		uI[sock].ad.posLevel = uI[sock].level;

		if ((i = searchDatabase(uI[sock].name, &db)) == -1)
			addLog("Not found: name -> %s??", uI[sock].name);
		else
			addDatabase(&uI[sock].ad, i);
		break;
	case PKT_CMN:
		getNext(buf, tmpbuf); tmpX = atoi(tmpbuf);
		getNext(buf, tmpbuf); tmpY = atoi(tmpbuf);
		if (checkForPlayer(tmpX, tmpY, sock))
		{
			processPlayerTalk(uI[sock].level, tmpX, tmpY, sock);
		}
		else if (checkForNPC(tmpX, tmpY, sock))
		{
			processNpcTalk(uI[sock].level, tmpX, tmpY, sock);
		}
		else if (checkForMonster(tmpX, tmpY, sock))
		{
			processMonsterTalk(uI[sock].level, tmpX, tmpY, sock);
		}
		else
			sockSend(cli[sock].sock, "%i;No one there.", PKT_NFO);
		break;
	case PKT_ATK:
		getNext(buf, tmpbuf); tmpL = atoi(tmpbuf);
		getNext(buf, tmpbuf); tmpX = atoi(tmpbuf);
		getNext(buf, tmpbuf); tmpY = atoi(tmpbuf);
		if (checkForMonster(tmpX, tmpY, sock))
		{
			attackMonster(findMonster(tmpX, tmpY, uI[sock].level), sock);
		}
		break;
	case PKT_GMI:
		sockSend(cli[sock].sock, "%i;L=%i X=%i Y=%i",
			PKT_NFO, uI[sock].level,
			uI[sock].posX, uI[sock].posY);
		break;
	case PKT_KIL:
		getNext(buf, tmpbuf);
		i = atoi(tmpbuf);
		getNext(buf, tmpbuf);
		addLog("Shutdown by %s: %s.",
			uI[sock].name, tmpbuf);
		sendAll("%i;Shutdown by %s: %s.",
			PKT_KIL, uI[sock].name, tmpbuf);
		sleep(1);
		if (i)	serverRestart(NULL);
		else	serverShutdown(NULL);
		break;
	}
}

void midcheckServer( void )
{
	if (sockReadReady(temp_sock))
	{
		sockRead(temp_sock, temp_buffer);
		processPacket(0, 0, temp_buffer);
	}

	if (t != time(NULL))
	{
		t = time(NULL);
		moveNpc();
		moveMonsters();
	}
}

void ProgramProcess( int id, int sock, char *buf )
{
	switch (id)
	{
	case SERVER_CONNECTED:
		addLog("(%3i) Connect from %s.", sock, cli[sock].from);
		break;
	case SERVER_DISCONNECT:
		addLog("(%3i) Disconnect.", sock);
		sockClose(sock);
		break;
	case SERVER_DATARDY:
		processPacket(id, sock, buf);
		memset(buf, 0, 1024);
		break;
	}
}
