#include "ukPatch.h"

void preServerStartup( void )
{
	int	i;

	for(i = 0; i < SERVER_CLIENTS; i++)
	{
		pi[i].sending	= 0;
		pi[i].remaining = 0;
		pi[i].sock	= 0;
	}
}

void preServerShutdown( void )
{
}

void postServerShutdown( int sig )
{
}

static void sendFile( int sock, char *buf )
{
	char	tmpbuf[100];

	memset(tmpbuf, 0, 100);
	sprintf(tmpbuf, "%s%s", CLIENTD, buf);

	if ((pi[sock].fd = fopen(tmpbuf, "r")) == NULL)
	{
		addLog("Unable to send file: %s", tmpbuf);
		sockSend(cli[sock].sock, "%i;%i", PKT_ERR, PKT_RCV);
		return;
	}

	srand(time(NULL));

	fseek(pi[sock].fd, 0, SEEK_END);
	pi[sock].remaining	= ftell(pi[sock].fd);
	pi[sock].sending	= 1;
	pi[sock].sock		= cli[sock].sock;
	fseek(pi[sock].fd, 0, SEEK_SET);
}

static void sendNext( int num )
{
	char	tmpbuf[1024], send_buf[4098];
	int	i, j;

	memset(tmpbuf, 0, 1024);
	memset(send_buf, 0, 4098);

	if (pi[num].remaining > 0)
	{
		i = 257;
		if (i > pi[num].remaining)
			i = pi[num].remaining;

		pi[num].remaining -= i;

		for(j = 0; j < i; j++)
			sprintf(send_buf, "%s;%i", send_buf,
				(unsigned char)fgetc(pi[num].fd));

		sockSend(pi[num].sock, "%i;%i%s", PKT_RCV, i, send_buf);
	}
	else
	{
		pi[num].sending 	= 0;
		fclose(pi[num].fd);
		sockSend(pi[num].sock, "%i;%i", PKT_OK, PKT_RCV);
	}
}

static void showLst( int sock )
{
	FILE	*fd;
	char	tmpbuf1[100], tmpbuf2[100], tmpbuf3[100];

	if ((fd = fopen(UPDATEF, "r")) == NULL)
	{
		sockSend(sock, "%i;%i", PKT_ERR, PKT_LUP);
		return;
	}

	while(fgets(tmpbuf1, 100, fd))
	{
		fgets(tmpbuf2, 100, fd);
		fgets(tmpbuf3, 100, fd);

		tmpbuf1[strlen(tmpbuf1)-1] = 0;
		tmpbuf2[strlen(tmpbuf2)-1] = 0;
		tmpbuf3[strlen(tmpbuf3)-1] = 0;

		sockSend(sock, "%i;%s;%s;%s", PKT_LUP,
			tmpbuf1, tmpbuf2, tmpbuf3);
	}

	fclose(fd);

	sockSend(sock, "%i;%i", PKT_OK, PKT_LUP);
}

static void processPacket( int id, int sock, char *buf )
{
	int	sw;
	char	tmpbuf[10];

	getNext(buf, tmpbuf);
	sw = atoi(tmpbuf);

	switch(sw)
	{
	case PKT_LUP:
		showLst(cli[sock].sock);
		break;
	case PKT_RCV:
		sendFile(sock, buf);
		sendNext(sock);
		break;
	case PKT_CON:
		sendNext(sock);
		break;
	}
}

void midcheckServer( void )
{
}

void ProgramProcess( int id, int sock, char *buf )
{
	switch (id)
	{
	case SERVER_CONNECTED:
		addLog("(%3i) Connect from %s.", sock, cli[sock].from);
		break;
	case SERVER_DISCONNECT:
		addLog("(%3i) Disconnect.", sock);
		sockClose(sock);
		break;
	case SERVER_DATARDY:
		processPacket(id, sock, buf);
		memset(buf, 0, 1024);
		break;
	}
}
