#include "ukEditor.h"

void processWarpListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	warpStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_WARP, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(warpStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(warpStruct), F_WARP);

		printf("[%03i] Level: %i  (X=%i Y=%i)\n",
			i, db.oldL, db.oldX, db.oldY);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processWarpListLong( void )
{
	warpStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Warp # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(warpStruct), F_WARP))
	{
		printf("Could not lookup Warp # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Warp old Level: %i\n", db.oldL);
	printf("Warp old X: %i\n", db.oldX);
	printf("Warp old Y: %i\n", db.oldY);
	printf("Warp new Level: %i\n", db.newL);
	printf("Warp new X: %i\n", db.newX);
	printf("Warp new Y: %i\n", db.newY);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processWarpEdit( void )
{
	int		id;
	warpStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Warp # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(warpStruct), F_WARP))
	{
		printf("Could not lookup Warp # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Warp old Level [default=%i]: ", db.oldL);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.oldL = atoi(c);

	printf("Warp old X [default=%i]: ", db.oldX);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.oldX = atoi(c);

	printf("Warp old Y [default=%i]: ", db.oldY);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.oldY = atoi(c);

	printf("Warp new Level [default=%i]: ", db.newL);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.newL = atoi(c);

	printf("Warp new X [default=%i]: ", db.newX);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.newX = atoi(c);

	printf("Warp new Y [default=%i]: ", db.newY);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.newY = atoi(c);

	printf("\n");
	printf("Warp old Level: %i\n", db.oldL);
	printf("Warp old X: %i\n", db.oldX);
	printf("Warp old Y: %i\n", db.oldY);
	printf("Warp new Level: %i\n", db.newL);
	printf("Warp new X: %i\n", db.newX);
	printf("Warp new Y: %i\n", db.newY);

	printf("\n");
	printf("Save Warp? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(warpStruct), F_WARP);
}

void processWarpAdd( void )
{
	warpStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(warpStruct));

	printf("\n");

	printf("Warp old Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.oldL = atoi(c);

	printf("Warp old X [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.oldX = atoi(c);

	printf("Warp old Y [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.oldY = atoi(c);

	printf("Warp new Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.newL = atoi(c);

	printf("Warp new X [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.newX = atoi(c);

	printf("Warp new Y [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.newY = atoi(c);

	printf("\n");
	printf("Warp old Level: %i\n", db.oldL);
	printf("Warp old X: %i\n", db.oldX);
	printf("Warp old Y: %i\n", db.oldY);
	printf("Warp new Level: %i\n", db.newL);
	printf("Warp new X: %i\n", db.newX);
	printf("Warp new Y: %i\n", db.newY);

	printf("\n");
	printf("Save Warp? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(warpStruct), F_WARP);
}

void processWarp( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processWarpListShort();
			break;
		case 'L':
			processWarpListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processWarpAdd();
			break;
		case 'a':
			processWarpAdd();
			break;
		case 'E':
			processWarpEdit();
			break;
		case 'e':
			processWarpEdit();
			break;
		default:
			return;
			break;
		}
	}
}
