#include "ukEditor.h"

void processNpcListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	npcStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_NPC, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(npcStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(npcStruct), F_NPC);

		printf("[%03i] %-15s L=%03i X=%02i Y=%02i", i,
			db.name, db.level, db.startx, db.starty);

		if (db.roam)
			printf(" Roam\n");
		else
			printf("\n");

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processNpcListLong( void )
{
	npcStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Npc # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(npcStruct), F_NPC))
	{
		printf("Could not lookup Npc # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Npc Name: %s [%03i]\n", db.name, atoi(c));
	printf("Npc File: %s\n", db.npcfile);
	printf("Gfx Set : %i\n", db.gfx);
	printf("Armor   : %i\n", db.armor);
	printf("Helm    : %i\n", db.helm);
	printf("Roam    : %i\n", db.roam);
	printf("Level   : %i\n", db.level);
	printf("Start X : %i\n", db.startx);
	printf("Start Y : %i\n", db.starty);
	printf("Delay   : %i\n", db.delay);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processNpcEdit( void )
{
	int		id;
	npcStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Npc # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(npcStruct), F_NPC))
	{
		printf("Could not lookup Npc # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Npc Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 15, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Npc File [default=%s]: ", db.npcfile);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.npcfile, c);

	printf("Graphic Set [default=%i]: ", db.gfx);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.gfx = atoi(c);

	printf("Armor [default=%i]: ", db.armor);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.armor = atoi(c);

	printf("Helm [default=%i]: ", db.helm);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.helm = atoi(c);

	printf("Roam (0=no, 1=yes) [default=%i]: ", db.roam);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.roam = atoi(c);

	printf("Level [default=%i]: ", db.level);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.level = atoi(c);

	printf("Starting X Pos [default=%i]: ", db.startx);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startx = atoi(c);

	printf("Starting Y Pos [default=%i]: ", db.starty);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.starty = atoi(c);

	printf("Second Delay [default=%i]: ", db.delay);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.delay = atoi(c);

	printf("\n");
	printf("Npc Name: %s [%05i]\n", db.name, atoi(c));
	printf("Npc File: %s\n", db.npcfile);
	printf("Gfx Set : %i\n", db.gfx);
	printf("Armor   : %i\n", db.armor);
	printf("Helm    : %i\n", db.helm);
	printf("Roam    : %i\n", db.roam);
	printf("Level   : %i\n", db.level);
	printf("Start X : %i\n", db.startx);
	printf("Start Y : %i\n", db.starty);
	printf("Delay   : %i\n", db.delay);

	printf("\n");
	printf("Save Npc? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(npcStruct), F_NPC);
}

void processNpcAdd( void )
{
	npcStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(npcStruct));

	printf("\n");

	printf("Npc Name [default=quit]: ");
	fflush(stdout);
	fgets(db.name, 15, stdin);
	db.name[strlen(db.name)-1] = 0;
	if (strlen(db.name) <= 1) return;

	printf("Npc File [default=quit]: ");
	fflush(stdout);
	fgets(db.npcfile, 20, stdin);
	db.npcfile[strlen(db.npcfile)-1] = 0;
	if (strlen(db.npcfile) <= 1) return;

	printf("Graphic Set [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.gfx = atoi(c);

	printf("Armor [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.armor = atoi(c);

	printf("Helm [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.helm = atoi(c);

	printf("Roam (0=no, 1=yes) [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.roam = atoi(c);

	printf("Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.level = atoi(c);

	printf("Starting X Pos [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startx = atoi(c);

	printf("Starting Y Pos [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.starty = atoi(c);

	printf("Second Delay [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.delay = atoi(c);

	printf("\n");
	printf("Npc Name: %s [%05i]\n", db.name, atoi(c));
	printf("Npc File: %s\n", db.npcfile);
	printf("Gfx Set : %i\n", db.gfx);
	printf("Armor   : %i\n", db.armor);
	printf("Helm    : %i\n", db.helm);
	printf("Roam    : %i\n", db.roam);
	printf("Level   : %i\n", db.level);
	printf("Start X : %i\n", db.startx);
	printf("Start Y : %i\n", db.starty);
	printf("Delay   : %i\n", db.delay);

	printf("\n");
	printf("Save Npc? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(npcStruct), F_NPC);
}

void processNpc( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processNpcListShort();
			break;
		case 'L':
			processNpcListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processNpcAdd();
			break;
		case 'a':
			processNpcAdd();
			break;
		case 'E':
			processNpcEdit();
			break;
		case 'e':
			processNpcEdit();
			break;
		default:
			return;
			break;
		}
	}
}
