#include "ukEditor.h"

void processMonsterListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	monsterStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_MONSTER, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(monsterStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(monsterStruct), F_MONSTER);

		printf("[%03i] %s\n", i, db.name);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processMonsterListLong( void )
{
	monsterStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Monster # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(monsterStruct), F_MONSTER))
	{
		printf("Could not lookup Monster # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Name      : %s [%03i]\n", db.name, atoi(c));
	printf("Gfx Set   : %i\n", db.gfx);
	printf("Color     : %i\n", db.color);
	printf("Attack    : %i\n", db.attack);
	printf("Strength  : %i\n", db.str);
	printf("Defense   : %i\n", db.def);
	printf("Magic     : %i\n", db.mag);
	printf("Speed     : %i\n", db.spd);
	printf("Delay     : %i\n", db.delay);
	printf("Experience: %lu\n", db.experience);
	printf("HP        : %i\n", db.hp);
	printf("MP        : %i\n", db.mp);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processMonsterEdit( void )
{
	int		id;
	monsterStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Monster # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(monsterStruct), F_MONSTER))
	{
		printf("Could not lookup Monster # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Monster Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 15, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Graphic Set [default=%i]: ", db.gfx);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.gfx = atoi(c);

	printf("Color [default=%i]: ", db.color);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.color = atoi(c);

	printf("Attack (0=dont attack, 1=attack) [default=%i]: ", db.attack);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.attack = atoi(c);

	printf("Strength [default=%i]: ", db.str);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.str = atoi(c);

	printf("Defense [default=%i]: ", db.def);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.def = atoi(c);

	printf("Magic [default=%i]: ", db.mag);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.mag = atoi(c);

	printf("Speed [default=%i]: ", db.spd);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.spd = atoi(c);

	printf("Second Delay [default=%i]: ", db.delay);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.delay = atoi(c);

	printf("Experience [default=%lu]: ", db.experience);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.experience = atoi(c);

	printf("Hit Points [default=%i]: ", db.hp);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.hp = atoi(c);

	printf("Magic Points [default=%i]: ", db.mp);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.mp = atoi(c);

	printf("\n");
	printf("Name      : %s [%05i]\n", db.name, atoi(c));
	printf("Gfx Set   : %i\n", db.gfx);
	printf("Color     : %i\n", db.color);
	printf("Attack    : %i\n", db.attack);
	printf("Strength  : %i\n", db.str);
	printf("Defense   : %i\n", db.def);
	printf("Magic     : %i\n", db.mag);
	printf("Speed     : %i\n", db.spd);
	printf("Delay     : %i\n", db.delay);
	printf("Experience: %lu\n", db.experience);
	printf("HP        : %i\n", db.hp);
	printf("MP        : %i\n", db.mp);

	printf("\n");
	printf("Save Monster? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(monsterStruct), F_MONSTER);
}

void processMonsterAdd( void )
{
	monsterStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(monsterStruct));

	printf("\n");

	printf("Monster Name [default=quit]: ");
	fflush(stdout);
	fgets(db.name, 15, stdin);
	db.name[strlen(db.name)-1] = 0;
	if (strlen(db.name) <= 1) return;

	printf("Graphic Set [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.gfx = atoi(c);

	printf("Color [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.color = atoi(c);

	printf("Attack (0=dont attack, 1=attack) [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.attack = atoi(c);

	printf("Strength [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.str = atoi(c);

	printf("Defense [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.def = atoi(c);

	printf("Magic [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.mag = atoi(c);

	printf("Speed [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.spd = atoi(c);

	printf("Second Delay [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.delay = atoi(c);

	printf("Experience [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.experience = atoi(c);

	printf("Hit Points [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.hp = atoi(c);

	printf("Magic Points [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.mp = atoi(c);

	printf("\n");
	printf("Name      : %s [%05i]\n", db.name, atoi(c));
	printf("Gfx Set   : %i\n", db.gfx);
	printf("Color     : %i\n", db.color);
	printf("Attack    : %i\n", db.attack);
	printf("Strength  : %i\n", db.str);
	printf("Defense   : %i\n", db.def);
	printf("Magic     : %i\n", db.mag);
	printf("Speed     : %i\n", db.spd);
	printf("Delay     : %i\n", db.delay);
	printf("Experience: %lu\n", db.experience);
	printf("HP        : %i\n", db.hp);
	printf("MP        : %i\n", db.mp);

	printf("\n");
	printf("Save Monster? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(monsterStruct), F_MONSTER);
}

void processMonster( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processMonsterListShort();
			break;
		case 'L':
			processMonsterListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processMonsterAdd();
			break;
		case 'a':
			processMonsterAdd();
			break;
		case 'E':
			processMonsterEdit();
			break;
		case 'e':
			processMonsterEdit();
			break;
		default:
			return;
			break;
		}
	}
}
