#include "ukEditor.h"

void processHelmListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	helmStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_HELM, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(helmStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(helmStruct), F_HELM);

		printf("[%03i] %s\n", i, db.name);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}	
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processHelmListLong( void )
{
	helmStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Helm # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(helmStruct), F_HELM))
	{
		printf("Could not lookup Helm # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Helm Name: %s [%03i]\n", db.name, atoi(c));
	printf("Color    : %i\n", db.color);
	printf("AC Adjust: %i\n", db.ac);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processHelmEdit( void )
{
	int		id;
	helmStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Helm # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(helmStruct), F_HELM))
	{
		printf("Could not lookup Helm # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Helm Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 15, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Color [default=%i]: ", db.color);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.color = atoi(c);

	printf("Armor Class Adjustment [default=%i]: ", db.ac);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.ac = atoi(c);

	printf("\n");
	printf("Armor Name: %s [%05i]\n", db.name, atoi(c));
	printf("Color     : %i\n", db.color);
	printf("AC Adjust : %i\n", db.ac);

	printf("\n");
	printf("Save Helm? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(helmStruct), F_HELM);
}

void processHelmAdd( void )
{
	helmStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(helmStruct));

	printf("\n");

	printf("Helm Name [default=quit]: ");
	fflush(stdout);
	fgets(db.name, 15, stdin);
	db.name[strlen(db.name)-1] = 0;
	if (strlen(db.name) <= 1) return;

	printf("Color [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.color = atoi(c);

	printf("Armor Class Adjustment [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.ac = atoi(c);

	printf("\n");
	printf("Helm Name: %s [%03i]\n", db.name, atoi(c));
	printf("Color    : %i\n", db.color);
	printf("AD Adjust: %i\n", db.ac);

	printf("\n");
	printf("Save Helm? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(helmStruct), F_HELM);
}

void processHelm( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processHelmListShort();
			break;
		case 'L':
			processHelmListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processHelmAdd();
			break;
		case 'a':
			processHelmAdd();
			break;
		case 'E':
			processHelmEdit();
			break;
		case 'e':
			processHelmEdit();
			break;
		default:
			return;
			break;
		}
	}
}
