#include "ukEditor.h"

void processDatabaseListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	accountDatabase	db;
	struct tm	timeT;
	u_char		c[10];

	fd = fopen(F_DATABASE, "r");

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(accountDatabase);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(accountDatabase), F_DATABASE);
		memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
		printf("[%05i] %-13s (create: %02i/%02i/%02i)", i, db.name,
			timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year);

		if (db.sysop)
			printf(" Game master\n");
		else
			printf("\n");

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}	
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processDatabaseListLong( void )
{
	accountDatabase		db;
	struct tm		timeT;
	u_char			c[20];

	printf("\n");
	printf("Enter Character # [default=0]: ");
	fflush(stdout);
	fgets(c, 19, stdin);
	printf("\n");

	if (strlen(c) <= 1)
		return;

	c[strlen(c)-1] = 0;

	if (!lookupData(atoi(c), &db, sizeof(accountDatabase), F_DATABASE))
	{
		printf("Could not lookup Character #%i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
	printf("Name    : %s\n", db.name);
	printf("Info    : %s\n", db.info);
	printf("Online  : Total Time %lu minutes.\n", db.timeOnline);
	printf("Logins  : Connected %lu times.\n", db.timesConnect);
	printf("Created : %02i/%02i/%02i at %02i:%02i:%02i.\n",
		timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year,
		timeT.tm_hour, timeT.tm_min, timeT.tm_sec);
	printf("Class   : %i\n", db.class);
	printf("Stats.  : STR %i  DEF %i  MAG %i  SPD %i\n",
		db.str, db.def, db.mag, db.spd);
	printf("HP - MP : %i/%i %i/%i\n",
		db.curhp, db.hp, db.curmp, db.mp);
	printf("LVL/EXP : Level %i, %lu experience.\n", db.level, db.exp);
	printf("Equip.  : Armor [%i]  Helm [%i]  Left [%i]  Right [%i]\n",
		db.armor, db.helm, db.left, db.right);
	printf("Necklace: %i\n", db.neck);
	printf("Boots   : %i\n", db.boots);
	printf("Items   : A [%i]  B [%i]\n", db.itemA, db.itemB);
	printf("Skills  : A [%i]  B [%i]  C [%i]\n",
		db.skillA, db.skillB, db.skillC);
	if (db.sysop)	printf("GM      : YES\n");
	else		printf("GM      : no\n");

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processDatabaseEdit( void )
{
	int			id;
	accountDatabase		db;
	struct tm		timeT;
	u_char			c[20];

	printf("\n");
	printf("Enter Character # [default=0]: ");
	fflush(stdout);
	fgets(c, 19, stdin);
	printf("\n");

	if (strlen(c) <= 1)
		return;

	c[strlen(c)-1] = 0;
	id = atoi(c);

	if (!lookupData(atoi(c), &db, sizeof(accountDatabase), F_DATABASE))
	{
		printf("Could not lookup Character #%i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 12, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Description [default=%s]: ", db.info);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.info, c);

	printf("Class [default=%i]: ", db.class);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.class = atoi(c);

	printf("Level [default=%i]: ", db.level);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.level = atoi(c);

	printf("Experience [default=%lu]: ", db.exp);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.exp = atol(c);

	printf("Strength [default=%i]: ", db.str);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.str = atoi(c);

	printf("Defense [default=%i]: ", db.def);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.def = atoi(c);

	printf("Magic [default=%i]: ", db.mag);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.mag = atoi(c);

	printf("Speed [default=%i]: ", db.spd);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.spd = atoi(c);

	printf("Map HP [default=%i]: ", db.hp);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.hp = atoi(c);
	if (db.curhp > db.hp) db.curhp = db.hp;

	printf("Map MP [default=%i]: ", db.mp);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.mp = atoi(c);
	if (db.curmp > db.mp) db.curmp = db.mp;

	printf("Armor [default=%i]: ", db.armor);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.armor = atoi(c);

	printf("Helm [default=%i]: ", db.helm);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.helm = atoi(c);

	printf("Left [default=%i]: ", db.left);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.left = atoi(c);

	printf("Right [default=%i]: ", db.right);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.right = atoi(c);

	printf("Necklace [default=%i]: ", db.neck);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.neck = atoi(c);

	printf("Boots [default=%i]: ", db.boots);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.boots = atoi(c);

	printf("Item A [default=%i]: ", db.itemA);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.itemA = atoi(c);

	printf("Item B [default=%i]: ", db.itemB);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.itemB = atoi(c);

	printf("Skill A [default=%i]: ", db.skillA);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.skillA = atoi(c);

	printf("Skill B [default=%i]: ", db.skillB);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.skillB = atoi(c);

	printf("Skill C [default=%i]: ", db.skillC);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.skillC = atoi(c);

	printf("Game Master [default=%i]: ", db.sysop);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.sysop = atoi(c);

	memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
	printf("Name    : %s\n", db.name);
	printf("Info    : %s\n", db.info);
	printf("Online  : Total Time %lu minutes.\n", db.timeOnline);
	printf("Logins  : Connected %lu times.\n", db.timesConnect);
	printf("Created : %02i/%02i/%02i at %02i:%02i:%02i.\n",
		timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year,
		timeT.tm_hour, timeT.tm_min, timeT.tm_sec);
	printf("Class   : %i\n", db.class);
	printf("Stats.  : STR %i  DEF %i  MAG %i  SPD %i\n",
		db.str, db.def, db.mag, db.spd);
	printf("HP - MP : %i/%i %i/%i\n",
		db.curhp, db.hp, db.curmp, db.mp);
	printf("LVL/EXP : Level %i, %lu experience.\n", db.level, db.exp);
	printf("Equip.  : Armor [%i]  Helm [%i]  Left [%i]  Right [%i]\n",
		db.armor, db.helm, db.left, db.right);
	printf("Necklace: %i\n", db.neck);
	printf("Boots   : %i\n", db.boots);
	printf("Items   : A [%i]  B [%i]\n", db.itemA, db.itemB);
	printf("Skills  : A [%i]  B [%i]  C [%i]\n",
		db.skillA, db.skillB, db.skillC);
	if (db.sysop)	printf("GM      : YES\n");
	else		printf("GM      : no\n");

	printf("\n");
	printf("Save Database? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(accountDatabase), F_DATABASE);
}

void processDatabase( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, 'Q/q' to quit, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processDatabaseListShort();
			break;
		case 'L':
			processDatabaseListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'E':
			processDatabaseEdit();
			break;
		case 'e':
			processDatabaseEdit();
			break;
		default:
			return;
			break;
		}
	}
}
