#include "ukEditor.h"

void processClassListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	classStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_CLASS, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(classStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(classStruct), F_CLASS);

		printf("[%03i] %-15s %s\n", i, db.name, db.desc);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 1, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}	
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processClassListLong( void )
{
	classStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Class # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(classStruct), F_CLASS))
	{
		printf("Could not lookup Class # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Class Name  : %s [%03i]\n", db.name, atoi(c));
	printf("Description : %s\n", db.desc);
	printf("Graphic Set : %i\n", db.gfx);
	printf("Start HP    : %i\n", db.startHp);
	printf("Start MP    : %i\n", db.startMp);
	printf("Start STR   : %i\n", db.startStr);
	printf("Start MAG   : %i\n", db.startDef);
	printf("Start DEF   : %i\n", db.startMag);
	printf("Start SPD   : %i\n", db.startSpd);
	printf("Increase STR: %i\n", db.incStr);
	printf("Increase DEF: %i\n", db.incDef);
	printf("Increase MAG: %i\n", db.incMag);
	printf("Increase SPD: %i\n", db.incSpd);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processClassEdit( void )
{
	int		id;
	classStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Class # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(classStruct), F_CLASS))
	{
		printf("Could not lookup Class # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Class Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 15, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Description [default=%s]: ", db.desc);
	fflush(stdout);
	fgets(c, 25, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.desc, c);

	printf("Graphic Set [default=%i]: ", db.gfx);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.gfx = atoi(c);

	printf("Starting Hit Points [default=%i]: ", db.startHp);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startHp = atoi(c);

	printf("Starting Magic Points [default=%i]: ", db.startMp);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startMp = atoi(c);

	printf("Starting Strength [default=%i]: ", db.startStr);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startStr = atoi(c);

	printf("Starting Defense [default=%i]: ", db.startDef);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startDef = atoi(c);

	printf("Starting Magic [default=%i]: ", db.startMag);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startMag = atoi(c);

	printf("Starting Speed [default=%i]: ", db.startSpd);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.startSpd = atoi(c);

	printf("Increase Strength per Level [default=%i]: ", db.incStr);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.incStr = atoi(c);

	printf("Increase Defense per Level [default=%i]: ", db.incDef);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.incDef = atoi(c);

	printf("Increase Magic per Level [default=%i]: ", db.incMag);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.incMag = atoi(c);

	printf("Increase Speed per Level [default=%i]: ", db.incSpd);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.incSpd = atoi(c);

	printf("\n");
	printf("Class Name  : %s [%05i]\n", db.name, atoi(c));
	printf("Description : %s\n", db.desc);
	printf("Graphic Set : %i\n", db.gfx);
	printf("Start HP    : %i\n", db.startHp);
	printf("Start MP    : %i\n", db.startMp);
	printf("Start STR   : %i\n", db.startStr);
	printf("Start MAG   : %i\n", db.startDef);
	printf("Start DEF   : %i\n", db.startMag);
	printf("Start SPD   : %i\n", db.startSpd);
	printf("Increase STR: %i\n", db.incStr);
	printf("Increase DEF: %i\n", db.incDef);
	printf("Increase MAG: %i\n", db.incMag);
	printf("Increase SPD: %i\n", db.incSpd);

	printf("\n");
	printf("Save Class? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(classStruct), F_CLASS);
}

void processClassAdd( void )
{
	classStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(classStruct));

	printf("\n");

	printf("Class Name [default=quit]: ");
	fflush(stdout);
	fgets(db.name, 15, stdin);
	db.name[strlen(db.name)-1] = 0;
	if (strlen(db.name) <= 1) return;

	printf("Description [default=quit]: ");
	fflush(stdout);
	fgets(db.desc, 25, stdin);
	db.desc[strlen(db.desc)-1] = 0;
	if (strlen(db.desc) <= 1) return;

	printf("Graphic Set [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.gfx = atoi(c);

	printf("Starting Hit Points [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startHp = atoi(c);

	printf("Starting Magic Points [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startMp = atoi(c);

	printf("Starting Strength [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startStr = atoi(c);

	printf("Starting Defense [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startDef = atoi(c);

	printf("Starting Magic [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startMag = atoi(c);

	printf("Starting Speed [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.startSpd = atoi(c);

	printf("Increase Strength per Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.incStr = atoi(c);

	printf("Increase Defense per Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.incDef = atoi(c);

	printf("Increase Magic per Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.incMag = atoi(c);

	printf("Increase Speed per Level [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.incSpd = atoi(c);

	printf("\n");
	printf("Class Name  : %s [%03i]\n", db.name, atoi(c));
	printf("Description : %s\n", db.desc);
	printf("Graphic Set : %i\n", db.gfx);
	printf("Start HP    : %i\n", db.startHp);
	printf("Start MP    : %i\n", db.startMp);
	printf("Start STR   : %i\n", db.startStr);
	printf("Start MAG   : %i\n", db.startDef);
	printf("Start DEF   : %i\n", db.startMag);
	printf("Start SPD   : %i\n", db.startSpd);
	printf("Increase STR: %i\n", db.incStr);
	printf("Increase DEF: %i\n", db.incDef);
	printf("Increase MAG: %i\n", db.incMag);
	printf("Increase SPD: %i\n", db.incSpd);

	printf("\n");
	printf("Save Class? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(classStruct), F_CLASS);
}

void processClass( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processClassListShort();
			break;
		case 'L':
			processClassListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processClassAdd();
			break;
		case 'a':
			processClassAdd();
			break;
		case 'E':
			processClassEdit();
			break;
		case 'e':
			processClassEdit();
			break;
		default:
			return;
			break;
		}
	}
}
