#include "ukEditor.h"

void processArmorListShort( void )
{
	int		i, r, len, cnt = 0;
	FILE		*fd;
	armorStruct	db;
	u_char		c[10];

	if ((fd = fopen(F_ARMOR, "r")) == NULL)
	{
		printf("\n");
		printf("File not found, use 'A'dd to create.\n");
		return;
	}

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(armorStruct);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(armorStruct), F_ARMOR);

		printf("[%03i] %s\n", i, db.name);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}	
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processArmorListLong( void )
{
	armorStruct	db;
	u_char		c[10];

	printf("\n");
	printf("Enter Armor # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(armorStruct), F_ARMOR))
	{
		printf("Could not lookup Armor # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	printf("Armor Name: %s [%03i]\n", db.name, atoi(c));
	printf("Color     : %i\n", db.color);
	printf("AC Adjust : %i\n", db.ac);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processArmorEdit( void )
{
	int		id;
	armorStruct	db;
	u_char		c[27];

	printf("\n");
	printf("Enter Armor # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(armorStruct), F_ARMOR))
	{
		printf("Could not lookup Armor # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("Armor Name [default=%s]: ", db.name);
	fflush(stdout);
	fgets(c, 15, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.name, c);

	printf("Color [default=%i]: ", db.color);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.color = atoi(c);

	printf("Armor Class Adjustment [default=%i]: ", db.ac);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.ac = atoi(c);

	printf("\n");
	printf("Armor Name: %s [%05i]\n", db.name, atoi(c));
	printf("Color     : %i\n", db.color);
	printf("AC Adjust : %i\n", db.ac);

	printf("\n");
	printf("Save Armor? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(armorStruct), F_ARMOR);
}

void processArmorAdd( void )
{
	armorStruct	db;
	u_char		c[27];

	memset(&db, 0, sizeof(armorStruct));

	printf("\n");

	printf("Armor Name [default=quit]: ");
	fflush(stdout);
	fgets(db.name, 15, stdin);
	db.name[strlen(db.name)-1] = 0;
	if (strlen(db.name) <= 1) return;

	printf("Color [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.color = atoi(c);

	printf("Armor Class Adjustment [default=quit]: ");
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) <= 0) return;
	db.ac = atoi(c);

	printf("\n");
	printf("Armor Name: %s [%03i]\n", db.name, atoi(c));
	printf("Color     : %i\n", db.color);
	printf("AD Adjust : %i\n", db.ac);

	printf("\n");
	printf("Save Armor? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(-1, &db, sizeof(armorStruct), F_ARMOR);
}

void processArmor( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, " \
			"'Q/q' to quit, 'A/a' to add, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processArmorListShort();
			break;
		case 'L':
			processArmorListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'A':
			processArmorAdd();
			break;
		case 'a':
			processArmorAdd();
			break;
		case 'E':
			processArmorEdit();
			break;
		case 'e':
			processArmorEdit();
			break;
		default:
			return;
			break;
		}
	}
}
