#include "ukEditor.h"

void processAccountListShort( void )
{
	int			i, r, len, cnt = 0;
	FILE			*fd;
	accountInformation	db;
	struct tm		timeT;
	u_char			c[10];

	fd = fopen(F_ACCOUNT, "r");

	fseek(fd, 0, SEEK_END);
	len = ftell(fd) / sizeof(accountInformation);
	fseek(fd, 0, SEEK_SET);

	fclose(fd);

	printf("\n");

	for(i = 0; i < len; i++, cnt++)
	{
		r = lookupData(i, &db, sizeof(accountInformation), F_ACCOUNT);
		memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
		printf("[%05i] %-20s (create: %02i/%02i/%02i)\n", i, db.id,
			timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year);

		if (cnt == 20)
		{
			printf("\n");
			printf("Press enter to continue [Q/q=quit]: ");
			fflush(stdin);
			fgets(c, 10, stdin);
			printf("\n");
			if (c[0] == 'Q' || c[0] == 'q')
				return;
			cnt = 0;
		}	
	}

	printf("\n");
	printf("Press enter to return: ");
	fgets(c, 10, stdin);
}

void processAccountListLong( void )
{
	int			i;
	accountInformation	db;
	accountDatabase		db2;
	struct tm		timeT;
	u_char			c[10];

	printf("\n");
	printf("Enter ID # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(accountInformation), F_ACCOUNT))
	{
		printf("Could not lookup ID # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
	printf("UK ID  : %s [%05i]\n", db.id, atoi(c));
	printf("UK PW  : %s\n", db.pass);
	printf("Created: %02i/%02i/%02i at %02i:%02i:%02i.\n",
		timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year,
		timeT.tm_hour, timeT.tm_min, timeT.tm_sec);

	for(i = 0; i < 5; i++)
		if (db.idS[i] != -1 && lookupData(db.idS[i], &db2, sizeof(accountDatabase), F_DATABASE))
			printf("Char #%i: [db=%05i] %s\n",
				i+1, db.idS[i], db2.name);

	printf("\n");
	printf("Press enter to return: ");
	fflush(stdout);
	fgets(c, 10, stdin);
}

void processAccountEdit( void )
{
	int			i, id;
	accountInformation	db;
	accountDatabase		db2;
	struct tm		timeT;
	u_char			c[21];

	printf("\n");
	printf("Enter ID # [default=0]: ");
	fflush(stdout);
	fgets(c, 10, stdin);
	printf("\n");

	if (!lookupData(atoi(c), &db, sizeof(accountInformation), F_ACCOUNT))
	{
		printf("Could not lookup ID # %i.\n", atoi(c));
		printf("Press enter to return: ");
		fflush(stdout);
		fgets(c, 10, stdin);
		return;
	}

	id = atoi(c);

	printf("UK ID [default=%s]: ", db.id);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.id, c);

	printf("UK Password [default=%s]: ", db.pass);
	fflush(stdout);
	fgets(c, 20, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 2) sprintf(db.pass, c);

	printf("Character #1 [default=%i]: ", db.idS[0]);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.idS[0] = atoi(c);

	printf("Character #2 [default=%i]: ", db.idS[1]);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.idS[1] = atoi(c);

	printf("Character #3 [default=%i]: ", db.idS[2]);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.idS[2] = atoi(c);

	printf("Character #4 [default=%i]: ", db.idS[3]);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.idS[3] = atoi(c);

	printf("Character #5 [default=%i]: ", db.idS[4]);
	fflush(stdout);
	fgets(c, 5, stdin);
	c[strlen(c)-1] = 0;
	if (strlen(c) >= 1) db.idS[4] = atoi(c);

	memcpy(&timeT, localtime(&db.created), sizeof(struct tm));
	printf("\n");
	printf("UK ID  : %s [%05i]\n", db.id, id);
	printf("UK PW  : %s\n", db.pass);
	printf("Created: %02i/%02i/%02i at %02i:%02i:%02i.\n",
		timeT.tm_mon+1, timeT.tm_mday, timeT.tm_year,
		timeT.tm_hour, timeT.tm_min, timeT.tm_sec);

	for(i = 0; i < 5; i++)
		if (db.idS[i] != -1 && lookupData(db.idS[i], &db2, sizeof(accountDatabase), F_DATABASE))
			printf("Char #%i: [db=%05i] %s\n",
				i+1, db.idS[i], db2.name);

	printf("\n");
	printf("Save Account? [y/N]: ");
	fflush(stdout);
	fgets(c, 10, stdin);

	if (c[0] == 'y' || c[1] == 'Y')
		saveData(id, &db, sizeof(accountInformation), F_ACCOUNT);
}

void processAccount( void )
{
	u_char	c[10];

	for( ;; )
	{
		printf("\n");
		printf("'l' short list, 'L' long list, 'Q/q' to quit, 'E/e' to edit.\n");
		printf("Choice [default=quit]: ");
		fflush(stdout);

		fgets(c, 10, stdin);
		switch(c[0])
		{
		case 'l':
			processAccountListShort();
			break;
		case 'L':
			processAccountListLong();
			break;
		case 'Q':
			return;
			break;
		case 'q':
			return;
			break;
		case 'E':
			processAccountEdit();
			break;
		case 'e':
			processAccountEdit();
			break;
		default:
			return;
			break;
		}
	}
}
