#include "server.h"

int lookupDatabase( int num, accountDatabase *db )
{
	FILE		*fd;

	if ((fd = fopen(F_DATABASE, "r")) == NULL)
	{
		addLog("Unable to open database [%s].", F_DATABASE);
		return	0;
	}

	fseek(fd, (num * sizeof(accountDatabase)), SEEK_SET);
	if (!fread((accountDatabase *)db, sizeof(accountDatabase), 1, fd))
		return	0;
	fclose(fd);

	return	1;
}

int lookupInformation( int num, accountInformation *db )
{
	FILE		*fd;

	if ((fd = fopen(F_ACCOUNT, "r")) == NULL)
	{
		addLog("Unable to open database [%s].", F_ACCOUNT);
		return	0;
	}

	fseek(fd, (num * sizeof(accountInformation)), SEEK_SET);
	if (!fread((accountInformation *)db, sizeof(accountInformation), 1, fd))
		return	0;
	fclose(fd);

	return	1;
}

int searchDatabase( char *name, accountDatabase *db )
{
	FILE		*fd;
	long		entries, i;

	if ((fd = fopen(F_DATABASE, "r")) == NULL)
	{
		addLog("Unable to open database [%s], assuming new database.",
			F_DATABASE);

		if ((fd = fopen(F_DATABASE, "w")) == NULL)
		{
			addLog("Unable to open new database [%s].", F_DATABASE);
			addLog("Shutting down server due to unknown error.");
			serverShutdown("Unknown error, server shutting down.");
		}
		fclose(fd);

		if ((fd = fopen(F_DATABASE, "r")) == NULL)
		{
			addLog("Unable to read database file [%s], server cannot continue",
				F_DATABASE);
			serverShutdown("Unknown error, server shutting down.");
		}
	}

	fseek(fd, 0, SEEK_END);
	entries = ftell(fd) / sizeof(accountDatabase);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < entries; i++)
	{
		fread((accountDatabase *)db, sizeof(accountDatabase), 1, fd);

		if (!strncasecmp(name, db->name, strlen(name)))
		{
			fclose(fd);
			return	i;
		}
	}

	fclose(fd);

	return	-1;
}

int searchInformation( char *name, accountInformation *db )
{
	FILE		*fd;
	long		entries, i;

	if ((fd = fopen(F_ACCOUNT, "r")) == NULL)
	{
		addLog("Unable to open database [%s], assuming new database.",
			F_ACCOUNT);

		if ((fd = fopen(F_ACCOUNT, "w")) == NULL)
		{
			addLog("Unable to open new database [%s].", F_ACCOUNT);
			addLog("Shutting down server due to unknown error.");
			serverShutdown("Unknown error, server shutting down.");
		}
		fclose(fd);

		if ((fd = fopen(F_ACCOUNT, "r")) == NULL)
		{
			addLog("Unable to read database file [%s], server cannot continue",
				F_ACCOUNT);
			serverShutdown("Unknown error, server shutting down.");
		}
	}

	fseek(fd, 0, SEEK_END);
	entries = ftell(fd) / sizeof(accountInformation);
	fseek(fd, 0, SEEK_SET);

	for(i = 0; i < entries; i++)
	{
		fread((accountInformation *)db, sizeof(accountInformation), 1, fd);

		if (!strncasecmp(name, db->id, strlen(name)))
		{
			fclose(fd);
			return	i;
		}
	}

	fclose(fd);

	return	-1;
}

int addDatabase( accountDatabase *db, int en )
{
	FILE	*fd;

	if ((fd = fopen(F_DATABASE, "r+")) == NULL)
	{
		addLog("Unable to open database [%s], assuming new database.",
			F_DATABASE);

		if ((fd = fopen(F_DATABASE, "w")) == NULL)
		{
			addLog("Unable to open new database [%s].", F_DATABASE);
			addLog("Shutting down server due to unknown error.");
			serverShutdown("Unknown error, server shutting down.");
		}
	}

	if (en == -1)
		fseek(fd, 0, SEEK_END);
	else
		fseek(fd, (en * sizeof(accountDatabase)), SEEK_SET);

	if (!fwrite((accountDatabase *)db, sizeof(accountDatabase), 1, fd))
	{
		addLog("Unable to write to database [%s].", F_DATABASE);
		fclose(fd);
		return	0;
	}

	fclose(fd);

	return	1;
}

int addInformation( accountInformation *db, int en )
{
	FILE	*fd;

	if ((fd = fopen(F_ACCOUNT, "r+")) == NULL)
	{
		addLog("Unable to open database [%s], assuming new database.",
			F_ACCOUNT);

		if ((fd = fopen(F_ACCOUNT, "w")) == NULL)
		{
			addLog("Unable to open new database [%s].", F_ACCOUNT);
			addLog("Shutting down server due to unknown error.");
			serverShutdown("Unknown error, server shutting down.");
		}
	}

	if (en != -1)
		fseek(fd, (en * sizeof(accountInformation)), SEEK_SET);
	else
		fseek(fd, 0, SEEK_END);

	if (!fwrite((accountInformation *)db, sizeof(accountInformation), 1, fd))
	{
		addLog("Unable to write to database [%s].", F_ACCOUNT);
		fclose(fd);
		return	0;
	}

	fclose(fd);

	return	1;
}

