#include <stdio.h>
#include <string.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <netinet/in.h>
#include <netdb.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include "log.h"

#include "/home/devel/UnholyKnights-CommonSource/pkt_code.h"
#include "/home/devel/UnholyKnights-CommonSource/files.h"
#ifdef C_EXTRA
#include "/home/devel/UnholyKnights-CommonSource/armor.h"
#include "/home/devel/UnholyKnights-CommonSource/helm.h"
#include "/home/devel/UnholyKnights-CommonSource/class.h"
#include "/home/devel/UnholyKnights-CommonSource/land.h"
#include "/home/devel/UnholyKnights-CommonSource/spell.h"
#include "/home/devel/UnholyKnights-CommonSource/npc.h"
#include "/home/devel/UnholyKnights-CommonSource/warp.h"
#include "/home/devel/UnholyKnights-CommonSource/monster.h"
#endif

#define	SERVER_CONNECTED	101
#define	SERVER_NOCHANGE		102
#define	SERVER_DATARDY		103
#define	SERVER_DISCONNECT	104

fd_set	readFds, usedFds, nullFds, tempFds;
int	listenSock,
	currentSock,
	SERVER_PORT,
	SERVER_CLIENTS,
	TRK_PORT,
	ACT_PORT,
	temp_sock,
	someoneConnected;
char	SERVER_DESC[40],
	TRK_IP[20],
	ACT_IP[20],
#ifndef	SERVER_IP
	SERVER_IP[20],
#endif
	temp_buffer[1024];

struct	return_information {
	int	sock;
	int	id;
	char	buf[1024];
};

struct  client_information {
	int	sock;
	char	from[20];
};

struct tracking_information {
	char	srv_name[40];
	char	srv_ip[20];
	int	srv_port;
	int	srv_cli;
	int	srv_mcli;
	int	id;
};

typedef struct {
	char	name[13];
	char	info[20];
	long	timeOnline;
	long	timesConnect;
	long	created;
	int	class;
	int	str;
	int	def;
	int	mag;
	int	spd;
	int	hp;
	int	curhp;
	int	mp;
	int	curmp;
	int	level;
	long	exp;
	int	left;
	int	right;
	int	armor;
	int	helm;
	int	itemA;
	int	itemB;
	int	boots;
	int	neck;
	int	skillA;
	int	skillB;
	int	skillC;
	int	posLevel;
	int	posX;
	int	posY;
	int	sysop;
	int	inventory[3][26];
	int	spells[26];
} accountDatabase;

typedef struct {
	char	id[20];
	char	pass[20];
	long	created;
	int	idS[5];
} accountInformation;

struct	return_information	ret;
struct	client_information	cli[255];

/* server.c */
void	sockSend( int, char *, ... );
int	sockRead( int, char * );
int	sockReadReady( int );
void	sockClose( int );
int	sockInit( void );
void	sockDeInit( void );
int	sockConnect( void );
void	sockProcess( void );
void	ProgramProcess( int, int, char * );
void	preServerShutdown( void );
void	postServerShutdown( int );
void	initSig( void );
void	signalHandler( int sig );
void	Error( char * );
void	recycleServer( void );
void	preServerStartup( void );
void	getNext( char *, char * );
void	midcheckServer( void );
void	serverShutdown( char * );
void	serverRestart( char * );

/* server_io.c */
int searchDatabase( char *, accountDatabase * );
int searchInformation( char *, accountInformation * );
int addDatabase( accountDatabase *, int );
int addInformation( accountInformation *, int );
int lookupDatabase( int, accountDatabase * );
int lookupInformation( int, accountInformation * );
